/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.ArrayList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.StyleContext;
import javax.swing.undo.UndoableEdit;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.CharSeq;
import org.netbeans.editor.DocumentUtilities;
import org.netbeans.editor.GapBranchElement;
import org.netbeans.editor.LineElement;
import org.netbeans.editor.ObjectArrayUtilities;
import org.netbeans.editor.Syntax;

final class LineRootElement
extends GapBranchElement {
    private static final String NAME = "section";
    private BaseDocument doc;
    private ArrayList addedLines = new ArrayList();

    LineRootElement(BaseDocument doc) {
        this.doc = doc;
        this.replace(0, 0, new Element[]{new LineElement(this, 0, null)});
    }

    public Element getElement(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Invalid line index=" + index + " < 0");
        }
        int elementCount = this.getElementCount();
        if (index >= elementCount) {
            throw new IndexOutOfBoundsException("Invalid line index=" + index + " >= lineCount=" + elementCount);
        }
        return super.getElement(index);
    }

    UndoableEdit insertUpdate(int offset, int length) {
        int startOffset = offset;
        offset += length;
        LineElement lastCreatedLine = null;
        CharSeq docText = this.doc.getText();
        while (--offset >= startOffset) {
            if (docText.charAt(offset) != '\n') continue;
            lastCreatedLine = new LineElement(this, offset + 1, lastCreatedLine);
            this.addedLines.add(lastCreatedLine);
        }
        if (lastCreatedLine != null) {
            Object[] linesAdded = new Element[this.addedLines.size()];
            this.addedLines.toArray(linesAdded);
            this.addedLines.clear();
            ObjectArrayUtilities.reverse(linesAdded);
            int index = this.getElementIndex(startOffset) + 1;
            this.replace(index, 0, (Element[])linesAdded);
            return new GapBranchElement.Undo(index, EMPTY_ELEMENT_ARRAY, (Element[])linesAdded);
        }
        return null;
    }

    UndoableEdit removeUpdate(int offset, int length) {
        int endOffset = offset + length;
        CharSeq docText = this.doc.getText();
        while (offset < endOffset) {
            if (docText.charAt(offset) == '\n') {
                int index = this.getElementIndex(offset + 1);
                LineElement lineElem = this.getLineElement(index);
                int removeCount = 0;
                do {
                    ++removeCount;
                } while ((lineElem = lineElem.getNext()) != null && lineElem.getStartOffset() <= endOffset);
                Element[] linesRemoved = new Element[removeCount];
                this.copyElements(index, index + removeCount, linesRemoved, 0);
                this.replace(index, linesRemoved.length, EMPTY_ELEMENT_ARRAY);
                return new GapBranchElement.Undo(index, linesRemoved, EMPTY_ELEMENT_ARRAY);
            }
            ++offset;
        }
        return null;
    }

    protected void replace(int index, int removeCount, Element[] addedElems) {
        if (removeCount > 0) {
            LineElement lastRemoved = this.getLineElement(index + removeCount - 1);
            if (index > 0) {
                this.getLineElement(index - 1).setNext(lastRemoved.getNext());
            }
            lastRemoved.setNext(null);
        }
        super.replace(index, removeCount, addedElems);
        if (addedElems.length > 0) {
            if (index > 0) {
                LineElement firstAdded = (LineElement)addedElems[0];
                ((LineElement)this.getElement(index - 1)).setNext(firstAdded);
            }
            int firstAfterAddedIndex = index + addedElems.length - removeCount;
            ((LineElement)addedElems[addedElems.length - 1]).setNext(firstAfterAddedIndex < this.getElementCount() ? this.getLineElement(firstAfterAddedIndex) : null);
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public Element getParentElement() {
        return null;
    }

    public String getName() {
        return NAME;
    }

    public AttributeSet getAttributes() {
        return StyleContext.getDefaultStyleContext().getEmptySet();
    }

    public int getStartOffset() {
        return 0;
    }

    public int getEndOffset() {
        return this.doc.getLength() + 1;
    }

    public int getElementIndex(int offset) {
        if (offset == 0) {
            return 0;
        }
        return super.getElementIndex(offset);
    }

    void invalidateAllSyntaxStateInfos() {
        int elemCount = this.getElementCount();
        for (int i = elemCount - 1; i >= 0; --i) {
            LineElement line = this.getValidLineElement(i);
            line.clearSyntaxStateInfo();
        }
    }

    void prepareSyntax(Segment text, Syntax syntax, int reqPos, int reqLen, boolean forceLastBuffer, boolean forceNotLastBuffer) throws BadLocationException {
        int preScan;
        if (reqPos < 0 || reqLen < 0 || reqPos + reqLen > this.doc.getLength()) {
            throw new BadLocationException("reqPos=" + reqPos + ", reqLen=" + reqLen + ", doc.getLength()=" + this.doc.getLength(), -1);
        }
        int reqPosLineIndex = this.getElementIndex(reqPos);
        LineElement reqPosLineElem = this.getValidSyntaxStateInfoLineElement(reqPosLineIndex);
        int lineStartOffset = reqPosLineElem.getStartOffset();
        Syntax.StateInfo stateInfo = reqPosLineElem.getSyntaxStateInfo();
        if (reqPosLineIndex > 0) {
            preScan = stateInfo.getPreScan();
        } else {
            preScan = 0;
            if (stateInfo != null) {
                throw new IllegalStateException("stateInfo=" + stateInfo);
            }
        }
        int intraLineLength = reqPos - lineStartOffset;
        this.doc.getText(lineStartOffset - preScan, preScan + intraLineLength + reqLen, text);
        text.offset += preScan;
        text.count -= preScan;
        syntax.load(stateInfo, text.array, text.offset, intraLineLength, false, reqPos);
        while (syntax.nextToken() != null) {
        }
        text.offset += intraLineLength;
        text.count -= intraLineLength;
        boolean forceLB = forceNotLastBuffer ? false : forceLastBuffer || reqPos + reqLen >= this.getDocument().getLength();
        syntax.relocate(text.array, text.offset, text.count, forceLB, reqPos + reqLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LineElement getValidSyntaxStateInfoLineElement(int lineIndex) throws BadLocationException {
        LineElement lineElem = this.getValidLineElement(lineIndex);
        Syntax.StateInfo stateInfo = lineElem.getSyntaxStateInfo();
        if (lineIndex > 0 && stateInfo == null) {
            int validLineIndex;
            LineElement validLineElem = null;
            for (validLineIndex = lineIndex - 1; validLineIndex > 0 && (stateInfo = (validLineElem = this.getValidLineElement(validLineIndex)).getSyntaxStateInfo()) == null; --validLineIndex) {
            }
            Segment text = DocumentUtilities.SEGMENT_CACHE.getSegment();
            try {
                Syntax syntax = this.doc.getFreeSyntax();
                try {
                    int validLineOffset;
                    int lineElemOffset = lineElem.getStartOffset();
                    int preScan = 0;
                    if (validLineIndex > 0) {
                        validLineOffset = validLineElem.getStartOffset();
                        preScan = stateInfo.getPreScan();
                    } else {
                        validLineOffset = 0;
                        stateInfo = null;
                    }
                    this.doc.getText(validLineOffset - preScan, lineElemOffset - validLineOffset + preScan, text);
                    text.offset += preScan;
                    text.count -= preScan;
                    syntax.load(stateInfo, text.array, text.offset, text.count, false, lineElemOffset);
                    int textEndOffset = text.offset + text.count;
                    do {
                        validLineElem = this.getValidLineElement(++validLineIndex);
                        int scanLength = validLineOffset;
                        validLineOffset = validLineElem.getStartOffset();
                        scanLength = validLineOffset - scanLength;
                        syntax.relocate(text.array, syntax.getOffset(), scanLength, false, validLineOffset);
                        while (syntax.nextToken() != null) {
                        }
                        validLineElem.updateSyntaxStateInfo(syntax);
                    } while (validLineIndex != lineIndex);
                }
                finally {
                    this.doc.releaseSyntax(syntax);
                }
            }
            finally {
                DocumentUtilities.SEGMENT_CACHE.releaseSegment(text);
            }
        }
        return lineElem;
    }

    /*
     * Exception decompiling
     */
    int fixSyntaxStateInfos(int offset, int length) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[UNCONDITIONALDOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private LineElement getLineElement(int index) {
        return (LineElement)this.getElement(index);
    }

    private LineElement getValidLineElement(int lineIndex) {
        if (lineIndex < 0 || lineIndex >= this.getElementCount()) {
            throw new IllegalArgumentException("lineIndex=" + lineIndex + ", lineCount=" + this.getElementCount());
        }
        return this.getLineElement(lineIndex);
    }

    int getTokenSafeOffset(int offset) {
        if (offset == 0) {
            return offset;
        }
        try {
            int lineIndex = this.getElementIndex(offset);
            LineElement lineElem = this.getValidSyntaxStateInfoLineElement(lineIndex);
            int lineStartOffset = lineElem.getStartOffset();
            Syntax.StateInfo stateInfo = lineElem.getSyntaxStateInfo();
            if (offset == lineStartOffset && stateInfo.getPreScan() == 0) {
                return offset;
            }
            int lineCount = this.getElementCount();
            while (++lineIndex < lineCount) {
                lineElem = this.getValidSyntaxStateInfoLineElement(lineIndex);
                lineStartOffset = lineElem.getStartOffset();
                if (lineStartOffset - (stateInfo = lineElem.getSyntaxStateInfo()).getPreScan() < offset) continue;
                return lineStartOffset;
            }
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e.toString());
        }
        return this.doc.getLength();
    }
}

