/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.Comparator;
import org.netbeans.editor.ObjectArray;

public class ObjectArrayUtilities {
    private ObjectArrayUtilities() {
    }

    public static int binarySearch(ObjectArray objectArray, Object key) {
        int low = 0;
        int high = objectArray.getItemCount() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Object midVal = objectArray.getItem(mid);
            int cmp = ((Comparable)midVal).compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int binarySearch(ObjectArray objectArray, Object key, Comparator c) {
        int low = 0;
        int high = objectArray.getItemCount() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Object midVal = objectArray.getItem(mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int findIndex(ObjectArray objectArray, Object item) {
        int index = ObjectArrayUtilities.binarySearch(objectArray, item);
        if (index < 0) {
            return -1;
        }
        if (objectArray.getItem(index) == item) {
            return index;
        }
        int cnt = objectArray.getItemCount();
        for (int upIndex = index + 1; upIndex < cnt; ++upIndex) {
            Object indexItem = objectArray.getItem(upIndex);
            if (indexItem == item) {
                return upIndex;
            }
            if (((Comparable)item).compareTo(indexItem) != 0) break;
        }
        while (--index >= 0) {
            Object indexItem = objectArray.getItem(index);
            if (indexItem == item) {
                return index;
            }
            if (((Comparable)item).compareTo(indexItem) == 0) continue;
            break;
        }
        return -1;
    }

    public static int findIndex(ObjectArray objectArray, Object item, Comparator c) {
        int index = ObjectArrayUtilities.binarySearch(objectArray, item, c);
        if (index < 0) {
            return -1;
        }
        if (objectArray.getItem(index) == item) {
            return index;
        }
        int cnt = objectArray.getItemCount();
        for (int upIndex = index + 1; upIndex < cnt; ++upIndex) {
            Object indexItem = objectArray.getItem(upIndex);
            if (indexItem == item) {
                return upIndex;
            }
            if (c.compare(item, indexItem) != 0) break;
        }
        while (--index >= 0) {
            Object indexItem = objectArray.getItem(index);
            if (indexItem == item) {
                return index;
            }
            if (c.compare(item, indexItem) == 0) continue;
            break;
        }
        return -1;
    }

    public static Object[] toArray(ObjectArray objectArray) {
        return ObjectArrayUtilities.toArray(objectArray, 0, objectArray.getItemCount());
    }

    public static Object[] toArray(ObjectArray objectArray, int startIndex, int endIndex) {
        Object[] dest = new Object[endIndex - startIndex];
        ObjectArrayUtilities.copyItems(objectArray, startIndex, endIndex, dest, 0);
        return dest;
    }

    public static void copyItems(ObjectArray srcObjectArray, int srcStartIndex, int srcEndIndex, Object[] dest, int destIndex) {
        if (srcObjectArray instanceof ObjectArray.CopyItems) {
            ((ObjectArray.CopyItems)((Object)srcObjectArray)).copyItems(srcStartIndex, srcEndIndex, dest, destIndex);
        } else {
            while (srcStartIndex < srcEndIndex) {
                dest[destIndex++] = srcObjectArray.getItem(srcStartIndex++);
            }
        }
    }

    public static void reverse(Object[] array) {
        int i = 0;
        for (int j = array.length - 1; i < j; ++i, --j) {
            Object o = array[i];
            array[i] = array[j];
            array[j] = o;
        }
    }
}

