/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Toolkit;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatWriter;

public class ExtFormatter
extends Formatter
implements FormatLayer {
    private List formatLayerList = new ArrayList();
    private static final Object NULL_VALUE = new Object();
    private HashMap settingsMap = new HashMap();
    private HashMap customSettingsNamesMap = new HashMap();
    private Acceptor indentHotCharsAcceptor;
    private boolean reindentWithTextBefore;
    static /* synthetic */ Class class$org$netbeans$editor$Settings;

    public ExtFormatter(Class kitClass) {
        super(kitClass);
        this.initFormatLayers();
    }

    protected void initFormatLayers() {
    }

    public String getName() {
        return this.getKitClass().getName().substring(this.getKitClass().getName().lastIndexOf(46) + 1);
    }

    public void settingsChange(SettingsChangeEvent evt) {
        super.settingsChange(evt);
        String settingName = evt != null ? evt.getSettingName() : null;
        Class kitClass = this.getKitClass();
        Iterator eit = this.settingsMap.entrySet().iterator();
        while (eit.hasNext()) {
            Map.Entry e = eit.next();
            if (settingName != null && !e.getKey().equals(e.getKey()) || this.customSettingsNamesMap.containsKey(e.getKey())) continue;
            e.setValue(Settings.getValue(kitClass, (String)e.getKey()));
        }
        this.indentHotCharsAcceptor = SettingsUtil.getAcceptor(kitClass, "indent-hot-chars-acceptor", AcceptorFactory.FALSE);
        this.reindentWithTextBefore = SettingsUtil.getBoolean(kitClass, "reindent-with-text-before", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSettingValue(String settingName) {
        Class clazz = class$org$netbeans$editor$Settings == null ? (class$org$netbeans$editor$Settings = ExtFormatter.class$("org.netbeans.editor.Settings")) : class$org$netbeans$editor$Settings;
        synchronized (clazz) {
            Object value = this.settingsMap.get(settingName);
            if (value == null && !this.customSettingsNamesMap.containsKey(settingName)) {
                value = Settings.getValue(this.getKitClass(), settingName);
                if (value == null) {
                    value = NULL_VALUE;
                }
                this.settingsMap.put(settingName, value);
            }
            return value != NULL_VALUE ? value : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSettingValue(String settingName, Object settingValue) {
        Class clazz = class$org$netbeans$editor$Settings == null ? (class$org$netbeans$editor$Settings = ExtFormatter.class$("org.netbeans.editor.Settings")) : class$org$netbeans$editor$Settings;
        synchronized (clazz) {
            this.customSettingsNamesMap.put(settingName, settingName);
            this.settingsMap.put(settingName, settingValue);
        }
    }

    public synchronized void addFormatLayer(FormatLayer layer) {
        this.formatLayerList.add(layer);
    }

    public synchronized boolean replaceFormatLayer(String layerName, FormatLayer layer) {
        int cnt = this.formatLayerList.size();
        for (int i = 0; i < cnt; ++i) {
            if (!layerName.equals(((FormatLayer)this.formatLayerList.get(i)).getName())) continue;
            this.formatLayerList.set(i, layer);
            return true;
        }
        return false;
    }

    public synchronized void removeFormatLayer(String layerName) {
        Iterator it = this.formatLayerIterator();
        while (it.hasNext()) {
            if (!layerName.equals(((FormatLayer)it.next()).getName())) continue;
            it.remove();
            return;
        }
    }

    public Iterator formatLayerIterator() {
        return this.formatLayerList.iterator();
    }

    public boolean isSimple() {
        return false;
    }

    public synchronized void format(FormatWriter fw) {
        boolean done = false;
        int safetyCounter = 0;
        do {
            fw.setChainModified(false);
            fw.setRestartFormat(false);
            Iterator it = this.formatLayerIterator();
            while (it.hasNext()) {
                ((FormatLayer)it.next()).format(fw);
                if (!fw.isRestartFormat()) continue;
            }
            if (!it.hasNext() && !fw.isRestartFormat()) {
                done = true;
            }
            if (safetyCounter <= 1000) continue;
            new Exception("Indentation infinite loop detected").printStackTrace();
            break;
        } while (!done);
    }

    public Writer reformat(BaseDocument doc, int startOffset, int endOffset, boolean indentOnly) throws BadLocationException, IOException {
        CharArrayWriter cw = new CharArrayWriter();
        Writer w = this.createWriter(doc, startOffset, cw);
        FormatWriter fw = w instanceof FormatWriter ? (FormatWriter)w : null;
        boolean fix5620 = true;
        if (fw != null) {
            fw.setIndentOnly(indentOnly);
            if (fix5620) {
                fw.setReformatting(true);
            }
        }
        w.write(doc.getChars(startOffset, endOffset - startOffset));
        w.close();
        if (!fix5620 || fw == null) {
            String out = new String(cw.toCharArray());
            doc.remove(startOffset, endOffset - startOffset);
            doc.insertString(startOffset, out, null);
        }
        return w;
    }

    public int reformat(BaseDocument doc, int startOffset, int endOffset) throws BadLocationException {
        try {
            Position pos = doc.createPosition(endOffset);
            this.reformat(doc, startOffset, endOffset, false);
            return pos.getOffset() - startOffset;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int[] getReformatBlock(JTextComponent target, String typedText) {
        if (this.indentHotCharsAcceptor == null) {
            this.settingsChange(null);
        }
        if (this.indentHotCharsAcceptor.accept(typedText.charAt(0))) {
            if (!this.reindentWithTextBefore && this.hasTextBefore(target, typedText)) {
                return null;
            }
            int dotPos = target.getCaret().getDot();
            return new int[]{Math.max(dotPos - 1, 0), dotPos};
        }
        return null;
    }

    protected boolean hasTextBefore(JTextComponent target, String typedText) {
        BaseDocument doc = Utilities.getDocument(target);
        int dotPos = target.getCaret().getDot();
        try {
            int fnw = Utilities.getRowFirstNonWhite(doc, dotPos);
            return dotPos != fnw + typedText.length();
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public Writer createWriter(Document doc, int offset, Writer writer) {
        return new FormatWriter(this, doc, offset, writer, false);
    }

    public int indentLine(Document doc, int offset) {
        if (doc instanceof BaseDocument) {
            block7: {
                try {
                    BaseDocument bdoc = (BaseDocument)doc;
                    int lineStart = Utilities.getRowStart(bdoc, offset);
                    int nextLineStart = Utilities.getRowStart(bdoc, offset, 1);
                    if (nextLineStart < 0) {
                        nextLineStart = bdoc.getLength();
                    }
                    this.reformat(bdoc, lineStart, nextLineStart, false);
                    return Utilities.getRowEnd(bdoc, lineStart);
                }
                catch (GuardedException e) {
                    Toolkit.getDefaultToolkit().beep();
                }
                catch (BadLocationException e) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block7;
                    e.printStackTrace();
                }
            }
            return offset;
        }
        return super.indentLine(doc, offset);
    }

    protected int getEOLOffset(BaseDocument bdoc, int offset) throws BadLocationException {
        return Utilities.getRowEnd(bdoc, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int indentNewLine(Document doc, int offset) {
        if (doc instanceof BaseDocument) {
            BaseDocument bdoc = (BaseDocument)doc;
            boolean newLineInserted = false;
            bdoc.atomicLock();
            try {
                bdoc.insertString(offset, "\n", null);
                newLineInserted = true;
                int eolOffset = Utilities.getRowEnd(bdoc, ++offset);
                Writer w = this.reformat(bdoc, offset, eolOffset, true);
                eolOffset = Utilities.getRowFirstNonWhite(bdoc, offset);
                if (eolOffset < 0) {
                    eolOffset = this.getEOLOffset(bdoc, offset);
                }
                offset = eolOffset;
                if (!(w instanceof FormatWriter)) return offset;
                offset += ((FormatWriter)w).getIndentShift();
                return offset;
            }
            catch (GuardedException e) {
                if (newLineInserted) return offset;
                Toolkit.getDefaultToolkit().beep();
                return offset;
            }
            catch (BadLocationException e) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) return offset;
                e.printStackTrace();
                return offset;
            }
            catch (IOException e) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) return offset;
                e.printStackTrace();
                return offset;
            }
            finally {
                bdoc.atomicUnlock();
            }
        }
        try {
            doc.insertString(offset, "\n", null);
            ++offset;
            return offset;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return offset;
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Simple
    extends ExtFormatter {
        public Simple(Class kitClass) {
            super(kitClass);
        }

        public boolean isSimple() {
            return true;
        }

        protected int getEOLOffset(BaseDocument bdoc, int offset) throws BadLocationException {
            return offset;
        }
    }
}

