/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.ext.ListCompletionView;
import org.netbeans.editor.ext.java.JCCellRenderer;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaFastOpenPanel;

public class JavaFastOpen
implements ActionListener {
    private static final int TIMER_DELAY = 500;
    private JavaFastOpenPanel panel;
    private ListCellRenderer cellRenderer;
    private JList resultList;
    private Dialog dialog;
    private JButton[] buttons;
    private Evaluator evaluator;
    private static final int SET_EXP = 1;
    private static final int POPULATE_LIST = 2;
    private static final int OPEN = 3;
    protected static JavaFastOpen fastOpen = null;

    public void setDialogVisible(boolean visible) {
        if (this.dialog == null) {
            this.dialog = this.createDialog();
        }
        this.dialog.setVisible(visible);
        if (visible) {
            this.getPanel().popupNotify();
        } else {
            if (this.evaluator != null) {
                this.evaluator.breakLoop();
            }
            this.dialog.dispose();
            fastOpen = null;
        }
    }

    protected void openSource(Object item) {
    }

    protected ListCellRenderer createCellRenderer() {
        JCCellRenderer rr = new JCCellRenderer();
        rr.setClassDisplayFullName(true);
        return rr;
    }

    protected JList createResultList() {
        ListCompletionView list = new ListCompletionView(this.getCellRenderer());
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JavaFastOpen.this.actionPerformed(new ActionEvent(JavaFastOpen.this.getButtons()[0], 0, ""));
                }
            }
        });
        return list;
    }

    private JButton[] getButtons() {
        if (this.buttons == null) {
            this.buttons = new JButton[]{new JButton(LocaleSupport.getString("JFO_openSourceButton", "Open Source")), new JButton(LocaleSupport.getString("JFO_closeButton", "Close"))};
            this.buttons[0].setEnabled(false);
            String mnemonic = LocaleSupport.getString("JFO_openSourceButtonMnemonic", "O");
            if (mnemonic != null && mnemonic.length() > 0) {
                this.buttons[0].setMnemonic(mnemonic.charAt(0));
            }
            if ((mnemonic = LocaleSupport.getString("JFO_closeButtonMnemonic", "C")) != null && mnemonic.length() > 0) {
                this.buttons[1].setMnemonic(mnemonic.charAt(0));
            }
            this.buttons[0].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFO_openSourceButton"));
            this.buttons[1].getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFO_closeButton"));
        }
        return this.buttons;
    }

    private Dialog createDialog() {
        String title = LocaleSupport.getString("JFO_title", "Open Java Source");
        Dialog dialog = DialogSupport.createDialog(title, this.getPanel(), false, this.getButtons(), false, 0, 1, this);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JavaFastOpen.this.setDialogVisible(false);
            }

            public void windowClosed(WindowEvent evt) {
            }
        });
        return dialog;
    }

    private JavaFastOpenPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JavaFastOpenPanel(this);
        }
        return this.panel;
    }

    ListCellRenderer getCellRenderer() {
        if (this.cellRenderer == null) {
            this.cellRenderer = this.createCellRenderer();
        }
        return this.cellRenderer;
    }

    JList getResultList() {
        if (this.resultList == null) {
            this.resultList = this.createResultList();
        }
        return this.resultList;
    }

    private Evaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = new Evaluator(0);
            this.evaluator.start();
        }
        return this.evaluator;
    }

    public void setSearchText(String text) {
        this.getPanel().setSearchText(text);
        this.postUpdate();
    }

    void postUpdate() {
        SwingUtilities.invokeLater(new Evaluator(1));
    }

    List evaluate(String exp) {
        List ret = Collections.EMPTY_LIST;
        if (exp != null && exp.length() > 0) {
            JCFinder finder = JavaCompletion.getFinder();
            ret = finder.findClasses(null, exp, false);
            Iterator it = ret.iterator();
            while (it.hasNext()) {
                JCClass cls = (JCClass)it.next();
                if (cls.getName().indexOf(46) < 0) continue;
                it.remove();
            }
        }
        return ret;
    }

    void populate(List result) {
        if (result != null && this.getResultList() instanceof ListCompletionView) {
            SwingUtilities.invokeLater(new Evaluator(2, result));
        }
    }

    private String listActionFor(KeyEvent ev) {
        InputMap map = this.resultList.getInputMap();
        Object o = map.get(KeyStroke.getKeyStrokeForEvent(ev));
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    boolean boundScrollingKey(KeyEvent ev) {
        String action = this.listActionFor(ev);
        return "selectPreviousRow".equals(action) || "selectNextRow".equals(action) || "selectFirstRow".equals(action) || "selectLastRow".equals(action) || "scrollUp".equals(action) || "scrollDown".equals(action);
    }

    void delegateScrollingKey(KeyEvent ev) {
        String action = this.listActionFor(ev);
        Action a = this.resultList.getActionMap().get(action);
        if (a != null) {
            a.actionPerformed(new ActionEvent(this.resultList, 0, action));
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.buttons[0] || src == this.panel) {
            this.getEvaluator().postOpen();
        } else {
            this.setDialogVisible(false);
        }
    }

    private void open() {
        SwingUtilities.invokeLater(new Evaluator(3));
    }

    private class Evaluator
    extends Thread {
        private int opID;
        private List result;
        private String exp;
        private String lastExp;
        private boolean open;
        private boolean exit;

        Evaluator(int opID) {
            this(opID, null);
        }

        Evaluator(int opID, List result) {
            this.opID = opID;
            this.result = result;
        }

        synchronized void setExp(String exp) {
            this.exp = exp;
        }

        synchronized void postOpen() {
            this.open = true;
        }

        void breakLoop() {
            this.exit = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            switch (this.opID) {
                case 1: {
                    String text = JavaFastOpen.this.getPanel().getSearchText();
                    if (((JavaFastOpen)JavaFastOpen.this).getEvaluator().lastExp == null && text.length() > 0) {
                        JavaFastOpen.this.getButtons()[0].setEnabled(true);
                    }
                    JavaFastOpen.this.getEvaluator().setExp(text);
                    return;
                }
                case 2: {
                    ((ListCompletionView)JavaFastOpen.this.getResultList()).setResult(this.result);
                    JavaFastOpen.this.getResultList().setSelectedIndex(0);
                    JavaFastOpen.this.getButtons()[0].setEnabled(this.result.size() > 0);
                    if (JavaFastOpen.this.dialog instanceof JDialog) {
                        JDialog jd = (JDialog)JavaFastOpen.this.dialog;
                        jd.getRootPane().setDefaultButton(JavaFastOpen.this.getButtons()[0].isEnabled() ? JavaFastOpen.this.getButtons()[0] : null);
                    }
                    return;
                }
                case 3: {
                    int selIndex = JavaFastOpen.this.getResultList().getSelectedIndex();
                    if (selIndex >= 0) {
                        JavaFastOpen.this.openSource(JavaFastOpen.this.getResultList().getModel().getElementAt(selIndex));
                        JavaFastOpen.this.setDialogVisible(false);
                    }
                    return;
                }
            }
            try {
                while (!this.exit) {
                    Object result;
                    if (this.exp != null && !this.exp.equals(this.lastExp)) {
                        this.lastExp = this.exp;
                        if (this.lastExp != null) {
                            result = JavaFastOpen.this.evaluate(this.lastExp);
                            if (this.lastExp == this.exp) {
                                JavaFastOpen.this.populate((List)result);
                            }
                        }
                    }
                    result = this;
                    synchronized (result) {
                        if (this.exp != null && this.exp.equals(this.lastExp) && this.open) {
                            JavaFastOpen.this.open();
                            this.open = false;
                        }
                    }
                    Evaluator.sleep(200L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

