/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.TextBatchProcessor;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaImport;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JavaSyntaxSupport
extends ExtSyntaxSupport {
    static final int INIT = 0;
    static final int AFTER_TYPE = 1;
    static final int AFTER_VARIABLE = 2;
    static final int AFTER_COMMA = 3;
    static final int AFTER_DOT = 4;
    static final int AFTER_TYPE_LSB = 5;
    static final int AFTER_MATCHING_VARIABLE_LSB = 6;
    static final int AFTER_MATCHING_VARIABLE = 7;
    static final int AFTER_EQUAL = 8;
    private static final TokenID[] COMMENT_TOKENS = new TokenID[]{JavaTokenContext.LINE_COMMENT, JavaTokenContext.BLOCK_COMMENT};
    private static final TokenID[] BRACKET_SKIP_TOKENS = new TokenID[]{JavaTokenContext.LINE_COMMENT, JavaTokenContext.BLOCK_COMMENT, JavaTokenContext.CHAR_LITERAL, JavaTokenContext.STRING_LITERAL};
    private static final char[] COMMAND_SEPARATOR_CHARS = new char[]{';', '{', '}'};
    private JavaImport javaImport;

    public JavaSyntaxSupport(BaseDocument doc) {
        super(doc);
        this.tokenNumericIDsValid = true;
        this.javaImport = new JavaImport();
    }

    protected void documentModified(DocumentEvent evt) {
        super.documentModified(evt);
        this.javaImport.documentModifiedAtPosition(evt.getOffset(), this.getDocument());
    }

    public TokenID[] getCommentTokens() {
        return COMMENT_TOKENS;
    }

    public TokenID[] getBracketSkipTokens() {
        return BRACKET_SKIP_TOKENS;
    }

    public int getLastCommandSeparator(int pos) throws BadLocationException {
        TextBatchProcessor tbp = new TextBatchProcessor(){

            public int processTextBatch(BaseDocument doc, int startPos, int endPos, boolean lastBatch) {
                try {
                    int[] blks = JavaSyntaxSupport.this.getCommentBlocks(endPos, startPos);
                    FinderFactory.CharArrayBwdFinder cmdFinder = new FinderFactory.CharArrayBwdFinder(COMMAND_SEPARATOR_CHARS);
                    int lastSeparatorOffset = JavaSyntaxSupport.this.findOutsideBlocks(cmdFinder, startPos, endPos, blks);
                    if (lastSeparatorOffset < 1) {
                        return lastSeparatorOffset;
                    }
                    TokenID separatorID = JavaSyntaxSupport.this.getTokenID(lastSeparatorOffset);
                    if (separatorID.getNumericID() != 57 && separatorID.getNumericID() != 58 && separatorID.getNumericID() != 51) {
                        lastSeparatorOffset = this.processTextBatch(doc, lastSeparatorOffset, 0, lastBatch);
                    }
                    return lastSeparatorOffset;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    return -1;
                }
            }
        };
        return this.getDocument().processText(tbp, pos, 0);
    }

    public JCClass getClassFromName(String className, boolean searchByName) {
        this.refreshJavaImport();
        JCClass ret = JavaCompletion.getPrimitiveClass(className);
        if (ret == null) {
            ret = this.javaImport.getClazz(className);
        }
        if (ret == null && searchByName) {
            if (this.isUnknownImport(className)) {
                return null;
            }
            List clsList = JavaCompletion.getFinder().findClasses(null, className, true);
            if (clsList != null && clsList.size() > 0 && clsList.size() > 0) {
                ret = (JCClass)clsList.get(0);
            }
        }
        return ret;
    }

    public JavaImport getJavaImport() {
        this.javaImport.update(this.getDocument());
        return this.javaImport;
    }

    protected boolean isUnknownImport(String className) {
        return this.javaImport.isUnknownImport(className);
    }

    protected List getUnknownImports() {
        return this.javaImport.getUnknownImports();
    }

    public boolean isImported(JCClass cls) {
        return this.javaImport.isImported(cls);
    }

    public void refreshJavaImport() {
        this.javaImport.update(this.getDocument());
    }

    protected void refreshClassInfo() {
    }

    protected List getImportedInnerClasses() {
        this.refreshJavaImport();
        return this.javaImport.getInnerClasses();
    }

    public JCClass getClass(int pos) {
        return null;
    }

    public boolean isStaticBlock(int pos) {
        return false;
    }

    protected ExtSyntaxSupport.DeclarationTokenProcessor createDeclarationTokenProcessor(String varName, int startPos, int endPos) {
        return new JavaDeclarationTokenProcessor(this, varName);
    }

    protected ExtSyntaxSupport.VariableMapTokenProcessor createVariableMapTokenProcessor(int startPos, int endPos) {
        return new JavaDeclarationTokenProcessor(this, null);
    }

    private boolean insideMethod(JTextComponent textComp, int startPos) {
        try {
            int level = 0;
            BaseDocument doc = (BaseDocument)textComp.getDocument();
            for (int i = startPos - 1; i > 0; --i) {
                char ch = doc.getChars(i, 1)[0];
                if (ch == ';') {
                    return false;
                }
                if (ch == ')') {
                    ++level;
                }
                if (ch != '(') continue;
                if (level == 0) {
                    return true;
                }
                --level;
            }
            return false;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public int checkCompletion(JTextComponent target, String typedText, boolean visible) {
        if (!visible) {
            int dotPos = target.getCaret().getDot();
            switch (typedText.charAt(0)) {
                case ' ': {
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    if (dotPos < 2) break;
                    int pos = Math.max(dotPos - 8, 0);
                    try {
                        String txtBeforeSpace = doc.getText(pos, dotPos - pos);
                        if (txtBeforeSpace.endsWith("new ") && txtBeforeSpace.length() > 4 && !Character.isJavaIdentifierPart(txtBeforeSpace.charAt(txtBeforeSpace.length() - 5))) {
                            return 0;
                        }
                        if (txtBeforeSpace.endsWith("import ") && !Character.isJavaIdentifierPart(txtBeforeSpace.charAt(0))) {
                            return 0;
                        }
                        if (txtBeforeSpace.endsWith(", ") && this.insideMethod(target, dotPos)) {
                            return 0;
                        }
                    }
                    catch (BadLocationException e) {}
                    break;
                }
                case '.': {
                    return 0;
                }
                case ',': {
                    if (!this.insideMethod(target, dotPos)) break;
                    return 0;
                }
            }
            return 1;
        }
        switch (typedText.charAt(0)) {
            case ';': 
            case '=': 
            case '{': {
                return 4;
            }
        }
        return 3;
    }

    public static class JavaDeclarationTokenProcessor
    implements ExtSyntaxSupport.DeclarationTokenProcessor,
    ExtSyntaxSupport.VariableMapTokenProcessor {
        protected JavaSyntaxSupport sup;
        int decStartPos = -1;
        int decArrayDepth;
        int typeStartPos;
        int typeEndPos;
        int decVarNameOffset;
        int decVarNameLen;
        int parenthesisCounter;
        int arrayDepth;
        char[] buffer;
        int bufferStartPos;
        String varName;
        int state;
        HashMap varMap;

        public JavaDeclarationTokenProcessor(JavaSyntaxSupport sup, String varName) {
            this.sup = sup;
            this.varName = varName;
            if (varName == null) {
                this.varMap = new HashMap();
            }
        }

        public int getDeclarationPosition() {
            return this.decStartPos;
        }

        public Map getVariableMap() {
            return this.varMap;
        }

        private void processDeclaration() {
            if (this.varName == null) {
                JCClass cls;
                String decType = new String(this.buffer, this.typeStartPos - this.bufferStartPos, this.typeEndPos - this.typeStartPos);
                if (decType.indexOf(32) >= 0) {
                    decType = Analyzer.removeSpaces(decType);
                }
                String decVarName = new String(this.buffer, this.decVarNameOffset, this.decVarNameLen);
                JCClass innerClass = null;
                JCClass outerCls = this.sup.getClass(this.decVarNameOffset);
                if (outerCls != null) {
                    String outerClassName = outerCls.getFullName();
                    innerClass = JavaCompletion.getFinder().getExactClass(outerClassName + "." + decType);
                    if (innerClass != null) {
                        this.varMap.put(decVarName, JavaCompletion.getType(innerClass, this.decArrayDepth));
                    }
                }
                if (innerClass == null && (cls = this.sup.getClassFromName(decType, true)) != null) {
                    this.varMap.put(decVarName, JavaCompletion.getType(cls, this.decArrayDepth));
                }
            } else {
                this.decStartPos = this.typeStartPos;
            }
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int tokenOffset, int tokenLen) {
            int pos = this.bufferStartPos + tokenOffset;
            if (!tokenContextPath.contains(JavaTokenContext.contextPath)) {
                this.state = 0;
                return true;
            }
            block0 : switch (tokenID.getNumericID()) {
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: {
                    this.typeStartPos = pos;
                    this.arrayDepth = 0;
                    this.typeEndPos = pos + tokenLen;
                    this.state = 1;
                    break;
                }
                case 48: {
                    switch (this.state) {
                        case 1: {
                            this.state = 4;
                            this.typeEndPos = pos + tokenLen;
                            break block0;
                        }
                        case 2: 
                        case 8: {
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 55: {
                    switch (this.state) {
                        case 1: {
                            this.state = 5;
                            ++this.arrayDepth;
                            break block0;
                        }
                        case 7: {
                            this.state = 6;
                            ++this.decArrayDepth;
                            break block0;
                        }
                        case 8: {
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 56: {
                    switch (this.state) {
                        case 5: {
                            this.state = 1;
                            break block0;
                        }
                        case 6: {
                            this.state = 7;
                            break block0;
                        }
                        case 8: {
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 53: {
                    ++this.parenthesisCounter;
                    if (this.state == 8) break;
                    this.state = 0;
                    break;
                }
                case 54: {
                    if (this.state == 7) {
                        this.processDeclaration();
                    }
                    if (this.parenthesisCounter > 0) {
                        --this.parenthesisCounter;
                    }
                    if (this.state == 8) break;
                    this.state = 0;
                    break;
                }
                case 57: 
                case 58: {
                    if (this.parenthesisCounter > 0) {
                        --this.parenthesisCounter;
                    }
                    this.state = 0;
                    break;
                }
                case 49: {
                    if (this.parenthesisCounter > 0) {
                        if (this.parenthesisCounter == 1 && this.state == 7) {
                            this.processDeclaration();
                        }
                        if (this.state == 8) break;
                        this.state = 0;
                        break;
                    }
                    switch (this.state) {
                        case 7: {
                            this.processDeclaration();
                        }
                        case 2: 
                        case 8: {
                            this.state = 3;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 96: {
                    if (this.state == 8) break;
                    this.state = 0;
                    break;
                }
                case 17: {
                    switch (this.state) {
                        case 7: {
                            this.processDeclaration();
                        }
                        case 2: {
                            this.state = 8;
                            break block0;
                        }
                        case 8: {
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 51: {
                    if (this.state == 7) {
                        this.processDeclaration();
                    }
                    this.state = 0;
                    break;
                }
                case 6: {
                    switch (this.state) {
                        case 1: 
                        case 3: {
                            if (this.varName == null || Analyzer.equals(this.varName, this.buffer, tokenOffset, tokenLen)) {
                                this.decArrayDepth = this.arrayDepth;
                                this.decVarNameOffset = tokenOffset;
                                this.decVarNameLen = tokenLen;
                                this.state = 7;
                                break block0;
                            }
                            this.state = 2;
                            break block0;
                        }
                        case 2: {
                            this.state = 0;
                            break block0;
                        }
                        case 8: {
                            break block0;
                        }
                        case 4: {
                            this.typeEndPos = pos + tokenLen;
                            this.state = 1;
                            break block0;
                        }
                        case 0: {
                            this.typeStartPos = pos;
                            this.arrayDepth = 0;
                            this.typeEndPos = pos + tokenLen;
                            this.state = 1;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    this.state = 0;
                }
            }
            return true;
        }

        public int eot(int offset) {
            return 0;
        }

        public void nextBuffer(char[] buffer, int offset, int len, int startPos, int preScan, boolean lastBuffer) {
            this.buffer = buffer;
            this.bufferStartPos = startPos - offset;
        }
    }
}

