/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.fold.api;

import java.util.Collection;
import java.util.List;
import org.netbeans.editor.fold.api.Fold;
import org.netbeans.editor.fold.api.FoldHierarchy;
import org.netbeans.editor.fold.api.FoldType;
import org.netbeans.lib.editor.fold.FoldUtilitiesImpl;

public final class FoldUtilities {
    private FoldUtilities() {
    }

    public static Fold getRootFold(Fold fold) {
        while (fold != null && !fold.isRootFold()) {
            fold = fold.getParent();
        }
        return fold;
    }

    public static Fold getRootFold(FoldHierarchy hierarchy, FoldType foldType) {
        int rootFoldCount = hierarchy.getRootFoldCount();
        for (int i = 0; i < rootFoldCount; ++i) {
            Fold rootFold = hierarchy.getRootFold(i);
            if (rootFold.getType() != foldType) continue;
            return rootFold;
        }
        return null;
    }

    public static void collapse(FoldHierarchy hierarchy, FoldType foldType) {
        FoldUtilitiesImpl.collapseOrExpand(hierarchy, foldType, true);
    }

    public static void expand(FoldHierarchy hierarchy, FoldType foldType) {
        FoldUtilitiesImpl.collapseOrExpand(hierarchy, foldType, false);
    }

    public static boolean containsOffset(Fold fold, int offset) {
        return offset < fold.getEndOffset() && offset >= fold.getStartOffset();
    }

    public static Fold[] childrenToArray(Fold fold) {
        return FoldUtilities.childrenToArray(fold, 0, fold.getFoldCount());
    }

    public static Fold[] childrenToArray(Fold fold, int index, int count) {
        return FoldUtilitiesImpl.childrenToArray(fold, index, count);
    }

    public static List childrenAsList(Fold fold) {
        return FoldUtilities.childrenAsList(fold, 0, fold.getFoldCount());
    }

    public static List childrenAsList(Fold fold, int index, int count) {
        return FoldUtilitiesImpl.childrenAsList(fold, index, count);
    }

    public static List find(Fold fold, FoldType type) {
        return FoldUtilitiesImpl.find(fold, type);
    }

    public static List find(Fold fold, Collection foldTypes) {
        return FoldUtilitiesImpl.find(fold, foldTypes);
    }

    public static List findRecursive(Fold fold) {
        return FoldUtilities.findRecursive(fold, (FoldType)null);
    }

    public static List findRecursive(Fold fold, FoldType type) {
        return FoldUtilitiesImpl.findRecursive(null, fold, type);
    }

    public static List findRecursive(Fold fold, Collection foldTypes) {
        return FoldUtilitiesImpl.findRecursive(null, fold, foldTypes);
    }

    public static List findRecursive(FoldHierarchy hierarchy) {
        return FoldUtilities.findRecursive(hierarchy, (FoldType)null);
    }

    public static List findRecursive(FoldHierarchy hierarchy, FoldType foldType) {
        return FoldUtilitiesImpl.findRecursive(hierarchy, foldType);
    }

    public static List findRecursive(FoldHierarchy hierarchy, Collection foldTypes) {
        return FoldUtilitiesImpl.findRecursive(hierarchy, foldTypes);
    }

    public static Fold findNearestFold(FoldHierarchy hierarchy, int offset) {
        return FoldUtilitiesImpl.findNearestFold(hierarchy, offset);
    }

    public static Fold findFoldAtOffset(FoldHierarchy hierarchy, int offset) {
        return FoldUtilitiesImpl.findFoldAtOffset(hierarchy, offset);
    }
}

