/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageioimpl.plugins.clib.CLibImageReader;
import com.sun.media.imageioimpl.plugins.clib.InputStreamAdapter;
import com.sun.media.imageioimpl.plugins.jpeg.I18N;
import com.sun.medialib.codec.jpeg.Decoder;
import com.sun.medialib.mlib.mediaLibImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

final class CLibJPEGImageReader
extends CLibImageReader {
    private static final boolean DEBUG = false;
    private mediaLibImage infoImage = null;
    private ImageTypeSpecifier imageType = null;
    private int bitDepth;

    CLibJPEGImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    protected final synchronized mediaLibImage decode(InputStream stream) throws IOException {
        mediaLibImage mlImage = null;
        Decoder decoder = null;
        try {
            if (stream instanceof InputStreamAdapter) {
                ImageInputStream iis = ((InputStreamAdapter)stream).getWrappedStream();
                decoder = new Decoder(iis);
            } else {
                decoder = new Decoder(stream);
            }
            mlImage = decoder.decode(null);
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
        if (mlImage == null) {
            throw new IIOException(I18N.getString("CLibJPEGImageReader0"));
        }
        this.infoImage = mlImage;
        try {
            this.bitDepth = decoder.getDepth();
        }
        catch (Throwable t) {
            throw new IIOException("codecLib error", t);
        }
        return mlImage;
    }

    private synchronized mediaLibImage getInfoImage() throws IOException {
        if (this.infoImage == null) {
            if (this.input == null) {
                throw new IllegalStateException("input == null");
            }
            ImageInputStream iis = null;
            if (!(this.input instanceof ImageInputStream)) {
                throw new IllegalArgumentException("!(input instanceof ImageInputStream)");
            }
            iis = (ImageInputStream)this.input;
            iis.mark();
            InputStreamAdapter stream = new InputStreamAdapter(iis);
            Decoder decoder = null;
            try {
                decoder = new Decoder((InputStream)stream);
                this.infoImage = decoder.getSize();
            }
            catch (Throwable t) {
                throw new IIOException("codecLib error", t);
            }
            if (this.infoImage == null) {
                throw new IIOException(I18N.getString("CLibJPEGImageReader0"));
            }
            try {
                this.bitDepth = decoder.getDepth();
            }
            catch (Throwable t) {
                throw new IIOException("codecLib error", t);
            }
            iis.reset();
        }
        return this.infoImage;
    }

    public int getWidth(int imageIndex) throws IOException {
        if (imageIndex != 0) {
            throw new IllegalArgumentException("imageIndex != 0");
        }
        return this.getInfoImage().getWidth();
    }

    public int getHeight(int imageIndex) throws IOException {
        if (imageIndex != 0) {
            throw new IllegalArgumentException("imageIndex != 0");
        }
        return this.getInfoImage().getHeight();
    }

    public synchronized ImageTypeSpecifier getRawImageType(int imageIndex) throws IOException {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException("imageIndex != 0");
        }
        if (this.imageType == null) {
            mediaLibImage mlImage = this.getInfoImage();
            this.imageType = CLibImageReader.createImageType(mlImage, this.bitDepth, null, null, null, null);
        }
        return this.imageType;
    }

    protected void resetLocal() {
        this.infoImage = null;
        this.imageType = null;
        super.resetLocal();
    }

    static {
        DEBUG = false;
    }
}

