/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class CLibJPEGImageReaderSpi
extends ImageReaderSpi {
    private static final String[] names = new String[]{"jpeg", "JPEG", "jpg", "JPG", "jfif", "JFIF", "jpeg-lossless", "JPEG-LOSSLESS", "jpeg-ls", "JPEG-LS"};
    private static final String[] suffixes = new String[]{"jpeg", "jpg", "jfif", "jls"};
    private static final String[] MIMETypes = new String[]{"image/jpeg"};
    private static final String readerClassName = "com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageReader";
    private static final String[] writerSpiNames;

    public CLibJPEGImageReaderSpi() {
        super(PackageUtil.getVendor(), PackageUtil.getVersion(), names, suffixes, MIMETypes, readerClassName, ImageReaderSpi.STANDARD_INPUT_TYPE, writerSpiNames, false, null, null, null, null, false, null, null, null, null);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        if (!PackageUtil.isCodecLibAvailable()) {
            registry.deregisterServiceProvider(this);
        } else {
            Object coreReaderSPI;
            Class<?> coreReaderSPIClass = null;
            try {
                coreReaderSPIClass = Class.forName("com.sun.imageio.plugins.jpeg.JPEGImageReaderSpi");
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (coreReaderSPIClass != null && (coreReaderSPI = registry.getServiceProviderByClass(coreReaderSPIClass)) != null) {
                registry.setOrdering(category, this, coreReaderSPI);
            }
        }
    }

    public String getDescription(Locale locale) {
        return "codecLib JPEG Image Reader";
    }

    public boolean canDecodeInput(Object source) throws IOException {
        if (!(source instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream iis = (ImageInputStream)source;
        iis.mark();
        int byte1 = iis.read();
        int byte2 = iis.read();
        if (byte1 != 255 || byte2 != 216) {
            iis.reset();
            return false;
        }
        block0: while (true) {
            byte1 = iis.read();
            byte2 = iis.read();
            if (byte1 != 255 || byte2 == 218) break;
            if (byte2 == 194) {
                iis.reset();
                return false;
            }
            if (byte2 >= 192 && byte2 <= 195) break;
            int length = iis.read() << 8;
            length += iis.read();
            length -= 2;
            while (true) {
                if (length <= 0) continue block0;
                byte1 = iis.read();
                --length;
            }
            break;
        }
        iis.reset();
        return true;
    }

    public ImageReader createReaderInstance(Object extension) throws IIOException {
        return new CLibJPEGImageReader(this);
    }

    static {
        readerClassName = readerClassName;
        writerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriterSpi"};
    }
}

