/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadataFormatImpl;

public class J2KMetadataFormat
extends IIOMetadataFormatImpl {
    private static Hashtable parents = new Hashtable();
    private static J2KMetadataFormat instance;
    String resourceBaseName = this.getClass().getName() + "Resources";

    public static synchronized J2KMetadataFormat getInstance() {
        if (instance == null) {
            instance = new J2KMetadataFormat();
        }
        return instance;
    }

    J2KMetadataFormat() {
        super("com_sun_media_imageio_plugins_jpeg2000_image_1.0", 1);
        this.setResourceBaseName(this.resourceBaseName);
        this.addElements();
    }

    private void addElements() {
        this.addElement("JPEG2000SignatureBox", this.getParent("JPEG2000SignatureBox"), 0);
        this.addElement("JPEG2000FileTypeBox", this.getParent("JPEG2000FileTypeBox"), 1);
        this.addElement("OtherBoxes", this.getParent("OtherBoxes"), 3);
        this.addElement("JPEG2000HeaderSuperBox", this.getParent("JPEG2000HeaderSuperBox"), 3);
        this.addElement("JPEG2000CodeStreamBox", this.getParent("JPEG2000CodeStreamBox"), 0);
        this.addElement("JPEG2000IntellectualPropertyRightsBox", this.getParent("JPEG2000IntellectualPropertyRightsBox"), 1);
        this.addElement("JPEG2000XMLBox", this.getParent("JPEG2000XMLBox"), 1);
        this.addElement("JPEG2000UUIDBox", this.getParent("JPEG2000UUIDBox"), 1);
        this.addElement("JPEG2000UUIDInfoBox", this.getParent("JPEG2000UUIDInfoBox"), 1);
        this.addElement("JPEG2000HeaderBox", "JPEG2000HeaderSuperBox", 1);
        this.addElement("OptionalBoxes", "JPEG2000HeaderSuperBox", 3);
        this.addElement("JPEG2000BitsPerComponentBox", "OptionalBoxes", 1);
        this.addElement("JPEG2000ColorSpecificationBox", "OptionalBoxes", 1);
        this.addElement("JPEG2000PaletteBox", "OptionalBoxes", 1);
        this.addElement("JPEG2000ComponentMappingBox", "OptionalBoxes", 1);
        this.addElement("JPEG2000ChannelDefinitionBox", "OptionalBoxes", 1);
        this.addElement("JPEG2000ResolutionBox", "OptionalBoxes", 1);
        this.addElement("JPEG2000CaptureResolutionBox", "JPEG2000ResolutionBox", 1);
        this.addElement("JPEG2000DefaultDisplayResolutionBox", "JPEG2000ResolutionBox", 1);
        this.addElement("JPEG2000UUIDListBox", "JPEG2000UUIDInfoBox", 1);
        this.addElement("JPEG2000DataEntryURLBox", "JPEG2000UUIDInfoBox", 1);
        Enumeration keys = parents.keys();
        while (keys.hasMoreElements()) {
            String s = (String)keys.nextElement();
            if (!s.startsWith("JPEG2000")) continue;
            this.addAttribute(s, "Length", 2, true, null);
            this.addAttribute(s, "Type", 0, true, Box.getTypeByName(s));
            this.addAttribute(s, "ExtraLength", 0, false, null);
            Class c = Box.getBoxClass(Box.getTypeInt(Box.getTypeByName(s)));
            try {
                Method m = c.getMethod("getElementNames", null);
                String[] elementNames = (String[])m.invoke(null, null);
                int i = 0;
                while (i < elementNames.length) {
                    this.addElement(elementNames[i], s, 0);
                    ++i;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.addAttribute("JPEG2000SignatureBox", "Signature", 0, true, "0D0A870A");
        this.addElement("BitDepth", "JPEG2000BitsPerComponentBox", 0);
        this.addElement("NumberEntries", "JPEG2000PaletteBox", 0);
        this.addElement("NumberColors", "JPEG2000PaletteBox", 0);
        this.addElement("BitDepth", "JPEG2000PaletteBox", 0);
        this.addElement("LUT", "JPEG2000PaletteBox", 1, 1024);
        this.addElement("LUTRow", "LUT", 0);
        this.addElement("Component", "JPEG2000ComponentMappingBox", 0);
        this.addElement("ComponentType", "JPEG2000ComponentMappingBox", 0);
        this.addElement("ComponentAssociation", "JPEG2000ComponentMappingBox", 0);
        this.addElement("NumberOfDefinition", "JPEG2000ChannelDefinitionBox", 0);
        this.addElement("Definitions", "JPEG2000ChannelDefinitionBox", 0, 9);
        this.addElement("ChannelNumber", "Definitions", 0);
        this.addElement("ChannelType", "Definitions", 0);
        this.addElement("ChannelAssociation", "Definitions", 0);
        this.addElement("CodeStream", "JPEG2000CodeStreamBox", 0);
        this.addElement("Content", "JPEG2000IntellectualPropertyRightsBox", 0);
        this.addElement("Content", "JPEG2000XMLBox", 0);
        this.addElement("UUID", "JPEG2000UUIDBox", 0);
        this.addElement("Data", "JPEG2000UUIDBox", 0);
        this.addElement("NumberUUID", "JPEG2000UUIDListBox", 0);
        this.addElement("UUID", "JPEG2000UUIDListBox", 0);
        this.addElement("Version", "JPEG2000DataEntryURLBox", 0);
        this.addElement("Flags", "JPEG2000DataEntryURLBox", 0);
        this.addElement("URL", "JPEG2000DataEntryURLBox", 0);
    }

    public String getParent(String elementName) {
        return (String)parents.get(elementName);
    }

    public boolean canNodeAppear(String elementName, ImageTypeSpecifier imageType) {
        ColorModel cm = imageType.getColorModel();
        if (!(cm instanceof IndexColorModel) && "JPEG2000PaletteBox".equals(elementName)) {
            return false;
        }
        if (!cm.hasAlpha() && "JPEG2000ChannelDefinitionBox".equals(elementName)) {
            return false;
        }
        return this.getParent(elementName) != null;
    }

    public boolean isLeaf(String name) {
        Set keys = parents.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            if (!name.equals(parents.get(iterator.next()))) continue;
            return false;
        }
        return true;
    }

    public boolean singleInstance(String name) {
        return !name.equals("JPEG2000IntellectualPropertyRightsBox") && !name.equals("JPEG2000XMLBox") && !name.equals("JPEG2000UUIDBox") && !name.equals("JPEG2000UUIDInfoBox") && !name.equals("JPEG2000UUIDListBox") && !name.equals("JPEG2000DataEntryURLBox");
    }

    static {
        parents.put("JPEG2000SignatureBox", "com_sun_media_imageio_plugins_jpeg2000_image_1.0");
        parents.put("JPEG2000FileTypeBox", "com_sun_media_imageio_plugins_jpeg2000_image_1.0");
        parents.put("OtherBoxes", "com_sun_media_imageio_plugins_jpeg2000_image_1.0");
        parents.put("JPEG2000HeaderSuperBox", "OtherBoxes");
        parents.put("JPEG2000CodeStreamBox", "OtherBoxes");
        parents.put("JPEG2000IntellectualPropertyRightsBox", "OtherBoxes");
        parents.put("JPEG2000XMLBox", "OtherBoxes");
        parents.put("JPEG2000UUIDBox", "OtherBoxes");
        parents.put("JPEG2000UUIDInfoBox", "OtherBoxes");
        parents.put("JPEG2000HeaderBox", "JPEG2000HeaderSuperBox");
        parents.put("OptionalBoxes", "JPEG2000HeaderSuperBox");
        parents.put("JPEG2000BitsPerComponentBox", "OptionalBoxes");
        parents.put("JPEG2000ColorSpecificationBox", "OptionalBoxes");
        parents.put("JPEG2000PaletteBox", "OptionalBoxes");
        parents.put("JPEG2000ComponentMappingBox", "OptionalBoxes");
        parents.put("JPEG2000ChannelDefinitionBox", "OptionalBoxes");
        parents.put("JPEG2000ResolutionBox", "OptionalBoxes");
        parents.put("JPEG2000CaptureResolutionBox", "JPEG2000ResolutionBox");
        parents.put("JPEG2000DefaultDisplayResolutionBox", "JPEG2000ResolutionBox");
        parents.put("JPEG2000UUIDListBox", "JPEG2000UUIDInfoBox");
        parents.put("JPEG2000DataEntryURLBox", "JPEG2000UUIDInfoBox");
    }
}

