/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.ChannelDefinitionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.ImageInputStreamWrapper;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReadParamJava;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.util.Hashtable;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import jj2000.j2k.codestream.HeaderInfo;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.decoder.EntropyDecoder;
import jj2000.j2k.fileformat.reader.FileFormatReader;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.ImgDataConverter;
import jj2000.j2k.image.invcomptransf.InvCompTransf;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.Dequantizer;
import jj2000.j2k.roi.ROIDeScaler;
import jj2000.j2k.util.ISRandomAccessIO;
import jj2000.j2k.wavelet.synthesis.InverseWT;

public class J2KReadState {
    private ImageInputStream iis = null;
    private FileFormatReader ff;
    private HeaderDecoder hd;
    private RandomAccessIO in;
    private BitstreamReaderAgent breader;
    private EntropyDecoder entdec;
    private ROIDeScaler roids;
    private Dequantizer deq;
    private InverseWT invWT;
    private InvCompTransf ictransf;
    private ImgDataConverter converter;
    private ImgDataConverter converter2;
    private DecoderSpecs decSpec = null;
    private J2KImageReadParamJava j2krparam = null;
    private int[] destinationBands = null;
    private int[] sourceBands = null;
    private int[] levelShift = null;
    private int[] maxValues = null;
    private int[] fracBits = null;
    private DataBlkInt[] dataBlocks = null;
    private int[] bandOffsets = null;
    private int maxDepth = 0;
    private boolean isSigned = false;
    private ColorModel colorModel = null;
    private SampleModel sampleModel = null;
    private int nComp = 0;
    private int tileWidth = 0;
    private int tileHeight = 0;
    private int scaleX;
    private int scaleY;
    private int xOffset;
    private int yOffset;
    private Rectangle destinationRegion = null;
    private Point sourceOrigin;
    private int tileXOffset;
    private int tileYOffset;
    private int width;
    private int height;
    private int[] pixbuf = null;
    private byte[] bytebuf = null;
    private int[] channelMap = null;
    private boolean noTransform = true;
    private J2KMetadata metadata;
    private BufferedImage destImage;
    private J2KImageReader reader;

    public J2KReadState(ImageInputStream iis, J2KImageReadParamJava param, J2KMetadata metadata, J2KImageReader reader) {
        if (iis == null || param == null || metadata == null) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState0"));
        }
        this.iis = iis;
        this.j2krparam = param;
        this.metadata = metadata;
        this.reader = reader;
        this.initializeRead(0, param, metadata);
    }

    public J2KReadState(ImageInputStream iis, J2KImageReadParamJava param, J2KImageReader reader) {
        if (iis == null || param == null) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState0"));
        }
        this.iis = iis;
        this.j2krparam = param;
        this.reader = reader;
        this.initializeRead(0, param, null);
    }

    public int getWidth() throws IOException {
        return this.width;
    }

    public int getHeight() throws IOException {
        return this.height;
    }

    public HeaderDecoder getHeader() {
        return this.hd;
    }

    public Raster getTile(int tileX, int tileY, WritableRaster raster) throws IOException {
        Point nT = this.ictransf.getNumTiles(null);
        if (this.noTransform) {
            if (tileX >= nT.x || tileY >= nT.y) {
                throw new IllegalArgumentException(I18N.getString("J2KImageReader0"));
            }
            this.ictransf.setTile(tileX, tileY);
            int tOffx = this.ictransf.getCompULX(0) - (this.ictransf.getImgULX() + this.ictransf.getCompSubsX(0) - 1) / this.ictransf.getCompSubsX(0) + this.destinationRegion.x;
            int tOffy = this.ictransf.getCompULY(0) - (this.ictransf.getImgULY() + this.ictransf.getCompSubsY(0) - 1) / this.ictransf.getCompSubsY(0) + this.destinationRegion.y;
            if (raster == null) {
                raster = Raster.createWritableRaster(this.sampleModel, new Point(tOffx, tOffy));
            }
            int numBands = this.sampleModel.getNumBands();
            int cTileHeight = this.ictransf.getTileHeight();
            int cTileWidth = this.ictransf.getTileWidth();
            if (tOffx + cTileWidth >= this.destinationRegion.width + this.destinationRegion.x) {
                cTileWidth = this.destinationRegion.width + this.destinationRegion.x - tOffx;
            }
            if (tOffy + cTileHeight >= this.destinationRegion.height + this.destinationRegion.y) {
                cTileHeight = this.destinationRegion.height + this.destinationRegion.y - tOffy;
            }
            if (this.pixbuf == null || this.pixbuf.length < cTileWidth * numBands) {
                this.pixbuf = new int[cTileWidth * numBands];
            }
            boolean prog = false;
            int l = 0;
            while (l < cTileHeight) {
                if (!this.reader.getAbortRequest()) {
                    int i = 0;
                    while (i < numBands) {
                        int tmp;
                        int j;
                        if (this.reader.getAbortRequest()) break;
                        DataBlkInt db = this.dataBlocks[i];
                        db.ulx = 0;
                        db.uly = l;
                        db.w = cTileWidth;
                        db.h = 1;
                        this.ictransf.getInternCompData(db, this.channelMap[this.sourceBands[i]]);
                        prog = prog || db.progressive;
                        int[] data = db.data;
                        int k1 = db.offset + cTileWidth - 1;
                        int fracBit = this.fracBits[i];
                        int lS = this.levelShift[i];
                        int max = this.maxValues[i];
                        if (ImageUtil.isBinary(this.sampleModel)) {
                            if (this.bytebuf == null || this.bytebuf.length < cTileWidth * numBands) {
                                this.bytebuf = new byte[cTileWidth * numBands];
                            }
                            j = cTileWidth - 1;
                            while (j >= 0) {
                                this.bytebuf[j] = (byte)((tmp = (data[k1--] >> fracBit) + lS) < 0 ? 0 : (tmp > max ? max : tmp));
                                --j;
                            }
                        } else {
                            j = cTileWidth - 1;
                            while (j >= 0) {
                                this.pixbuf[j] = (tmp = (data[k1--] >> fracBit) + lS) < 0 ? 0 : (tmp > max ? max : tmp);
                                --j;
                            }
                            raster.setSamples(tOffx, tOffy + l, cTileWidth, 1, this.destinationBands[i], this.pixbuf);
                        }
                        ++i;
                    }
                    if (ImageUtil.isBinary(this.sampleModel)) {
                        ImageUtil.setUnpackedBinaryData(this.bytebuf, raster, new Rectangle(tOffx, tOffy + l, cTileWidth, 1));
                    }
                    ++l;
                    continue;
                }
                break;
            }
        } else {
            this.readSubsampledRaster(raster);
        }
        return raster;
    }

    public Rectangle getDestinationRegion() {
        return this.destinationRegion;
    }

    public BufferedImage readBufferedImage() throws IOException {
        this.colorModel = this.getColorModel();
        this.sampleModel = this.getSampleModel();
        WritableRaster raster = null;
        BufferedImage image = this.j2krparam.getDestination();
        int x = this.destinationRegion.x;
        int y = this.destinationRegion.y;
        this.destinationRegion.setLocation(this.j2krparam.getDestinationOffset());
        if (image == null) {
            ImageTypeSpecifier type = this.j2krparam.getDestinationType();
            if (type != null) {
                this.colorModel = type.getColorModel();
            }
            raster = Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(0, 0));
            image = new BufferedImage(this.colorModel, raster, this.colorModel.isAlphaPremultiplied(), new Hashtable());
        } else {
            raster = image.getWritableTile(0, 0);
        }
        this.destImage = image;
        this.readSubsampledRaster(raster);
        this.destinationRegion.setLocation(x, y);
        this.destImage = null;
        return image;
    }

    public Raster readAsRaster() throws IOException {
        BufferedImage image = this.j2krparam.getDestination();
        WritableRaster raster = null;
        raster = image == null ? Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(0, 0)) : image.getWritableTile(0, 0);
        this.readSubsampledRaster(raster);
        return raster;
    }

    private void initializeRead(int imageIndex, J2KImageReadParamJava param, J2KMetadata metadata) {
        try {
            this.iis.mark();
            ImageInputStreamWrapper is = new ImageInputStreamWrapper(this.iis);
            int dataLen = (int)this.iis.length();
            this.in = dataLen != -1 ? new ISRandomAccessIO(is, dataLen, 1, dataLen) : new ISRandomAccessIO(is);
            this.ff = new FileFormatReader(this.in, metadata);
            this.ff.readFileFormat();
            this.in.seek(this.ff.getFirstCodeStreamPos());
            HeaderInfo hi = new HeaderInfo();
            try {
                this.hd = new HeaderDecoder(this.in, this.j2krparam, hi);
            }
            catch (EOFException e) {
                throw new RuntimeException(I18N.getString("J2KReadState2"));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            this.width = this.hd.getImgWidth();
            this.height = this.hd.getImgHeight();
            Rectangle sourceRegion = param.getSourceRegion();
            this.sourceOrigin = new Point();
            sourceRegion = new Rectangle(this.hd.getImgULX(), this.hd.getImgULY(), this.width, this.height);
            this.destinationRegion = (Rectangle)sourceRegion.clone();
            J2KImageReader.computeRegionsWrapper(param, false, this.width, this.height, param.getDestination(), sourceRegion, this.destinationRegion);
            this.sourceOrigin = new Point(sourceRegion.x, sourceRegion.y);
            this.scaleX = param.getSourceXSubsampling();
            this.scaleY = param.getSourceYSubsampling();
            this.xOffset = param.getSubsamplingXOffset();
            this.yOffset = param.getSubsamplingYOffset();
            Point tileOffset = this.hd.getTilingOrigin(null);
            this.tileXOffset = tileOffset.x;
            this.tileYOffset = tileOffset.y;
            this.width = this.destinationRegion.width;
            this.height = this.destinationRegion.height;
            this.tileWidth = this.hd.getNomTileWidth();
            this.tileHeight = this.hd.getNomTileHeight();
            if (!this.destinationRegion.equals(sourceRegion)) {
                this.noTransform = false;
            }
            this.decSpec = this.hd.getDecoderSpecs();
            this.nComp = this.hd.getNumComps();
            boolean compConsistent = true;
            int sx = this.hd.getCompSubsX(0);
            int sy = this.hd.getCompSubsY(0);
            int i = 1;
            while (i < this.nComp) {
                if (sx != this.hd.getCompSubsX(i) || sy != this.hd.getCompSubsY(i)) {
                    throw new RuntimeException(I18N.getString("J2KReadState12"));
                }
                ++i;
            }
            int[] depth = new int[this.nComp];
            int i2 = 0;
            while (i2 < this.nComp) {
                depth[i2] = this.hd.getOriginalBitDepth(i2);
                ++i2;
            }
            ChannelDefinitionBox cdb = null;
            if (metadata != null) {
                cdb = (ChannelDefinitionBox)metadata.getElement("JPEG2000ChannelDefinitionBox");
            }
            this.channelMap = new int[this.nComp];
            if (cdb != null) {
                short[] assoc = cdb.getAssociation();
                short[] types = cdb.getTypes();
                short[] channels = cdb.getChannel();
                int i3 = 0;
                while (i3 < types.length) {
                    if (types[i3] == 0) {
                        this.channelMap[channels[i3]] = assoc[i3] - 1;
                    } else if (types[i3] == 1 || types[i3] == 2) {
                        this.channelMap[channels[i3]] = channels[i3];
                    }
                    ++i3;
                }
            } else {
                int i4 = 0;
                while (i4 < this.nComp) {
                    this.channelMap[i4] = i4;
                    ++i4;
                }
            }
            try {
                this.breader = BitstreamReaderAgent.createInstance(this.in, this.hd, this.j2krparam, this.decSpec, false, hi);
            }
            catch (IOException e) {
                throw new RuntimeException(I18N.getString("J2KReadState3") + " " + (e.getMessage() != null ? ":\n" + e.getMessage() : ""));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(I18N.getString("J2KReadState4") + " " + (e.getMessage() != null ? ":\n" + e.getMessage() : ""));
            }
            try {
                this.entdec = this.hd.createEntropyDecoder(this.breader, this.j2krparam);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(I18N.getString("J2KReadState5") + " " + (e.getMessage() != null ? ":\n" + e.getMessage() : ""));
            }
            try {
                this.roids = this.hd.createROIDeScaler(this.entdec, this.j2krparam, this.decSpec);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(I18N.getString("J2KReadState6") + " " + (e.getMessage() != null ? ":\n" + e.getMessage() : ""));
            }
            try {
                this.deq = this.hd.createDequantizer(this.roids, depth, this.decSpec);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(I18N.getString("J2KReadState7") + " " + (e.getMessage() != null ? ":\n" + e.getMessage() : ""));
            }
            try {
                this.invWT = InverseWT.createInstance(this.deq, this.decSpec);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(I18N.getString("J2KReadState8") + " " + (e.getMessage() != null ? ":\n" + e.getMessage() : ""));
            }
            int res = this.breader.getImgRes();
            int mrl = this.decSpec.dls.getMin();
            this.invWT.setImgResLevel(res);
            this.converter = new ImgDataConverter(this.invWT, 0);
            this.ictransf = new InvCompTransf(this.converter, this.decSpec, depth);
            this.sourceBands = this.j2krparam.getSourceBands();
            if (this.sourceBands == null) {
                this.sourceBands = new int[this.nComp];
                int i5 = 0;
                while (i5 < this.nComp) {
                    this.sourceBands[i5] = i5;
                    ++i5;
                }
            }
            this.nComp = this.sourceBands.length;
            this.destinationBands = this.j2krparam.getDestinationBands();
            if (this.destinationBands == null) {
                this.destinationBands = new int[this.nComp];
                int i6 = 0;
                while (i6 < this.nComp) {
                    this.destinationBands[i6] = i6;
                    ++i6;
                }
            }
            J2KImageReader.checkReadParamBandSettingsWrapper(param, this.hd.getNumComps(), this.destinationBands.length);
            this.levelShift = new int[this.nComp];
            this.maxValues = new int[this.nComp];
            this.fracBits = new int[this.nComp];
            this.dataBlocks = new DataBlkInt[this.nComp];
            depth = new int[this.nComp];
            this.bandOffsets = new int[this.nComp];
            this.maxDepth = 0;
            this.isSigned = false;
            int i7 = 0;
            while (i7 < this.nComp) {
                depth[i7] = this.hd.getOriginalBitDepth(this.sourceBands[i7]);
                if (depth[i7] > this.maxDepth) {
                    this.maxDepth = depth[i7];
                }
                this.dataBlocks[i7] = new DataBlkInt();
                this.bandOffsets[i7] = i7;
                if (this.hd.isOriginalSigned(this.sourceBands[i7])) {
                    this.isSigned = true;
                } else {
                    this.levelShift[i7] = 1 << this.ictransf.getNomRangeBits(this.sourceBands[i7]) - 1;
                }
                this.maxValues[i7] = (1 << this.ictransf.getNomRangeBits(this.sourceBands[i7])) - 1;
                this.fracBits[i7] = this.ictransf.getFixedPoint(this.sourceBands[i7]);
                ++i7;
            }
            this.iis.reset();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (Error e) {
            if (e.getMessage() != null) {
                throw new RuntimeException(e.getMessage(), e);
            }
            throw new RuntimeException(I18N.getString("J2KReadState9"), e);
        }
        catch (RuntimeException e) {
            if (e.getMessage() != null) {
                throw new RuntimeException(I18N.getString("J2KReadState10") + " " + e.getMessage(), e);
            }
            throw new RuntimeException(I18N.getString("J2KReadState10"), e);
        }
        catch (Throwable e) {
            throw new RuntimeException(I18N.getString("J2KReadState10"), e);
        }
    }

    private Raster readSubsampledRaster(WritableRaster raster) throws IOException {
        if (raster == null) {
            raster = Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(this.destinationRegion.x, this.destinationRegion.y));
        }
        int[] pixbuf = null;
        boolean prog = false;
        Point nT = this.ictransf.getNumTiles(null);
        int numBands = this.sourceBands.length;
        Rectangle destRect = raster.getBounds().intersection(this.destinationRegion);
        int offx = this.destinationRegion.x;
        int offy = this.destinationRegion.y;
        int sourceSX = (destRect.x - offx) * this.scaleX + this.sourceOrigin.x;
        int sourceSY = (destRect.y - offy) * this.scaleY + this.sourceOrigin.y;
        int sourceEX = (destRect.width - 1) * this.scaleX + sourceSX;
        int sourceEY = (destRect.height - 1) * this.scaleY + sourceSY;
        int startXTile = (sourceSX - this.tileXOffset) / this.tileWidth;
        int startYTile = (sourceSY - this.tileYOffset) / this.tileHeight;
        int endXTile = (sourceEX - this.tileXOffset) / this.tileWidth;
        int endYTile = (sourceEY - this.tileYOffset) / this.tileHeight;
        startXTile = this.clip(startXTile, 0, nT.x - 1);
        startYTile = this.clip(startYTile, 0, nT.y - 1);
        endXTile = this.clip(endXTile, 0, nT.x - 1);
        endYTile = this.clip(endYTile, 0, nT.y - 1);
        int totalXTiles = endXTile - startXTile + 1;
        int totalYTiles = endYTile - startYTile + 1;
        int totalTiles = totalXTiles * totalYTiles;
        int y = startYTile;
        while (y <= endYTile) {
            if (this.reader.getAbortRequest()) break;
            int x = startXTile;
            while (x <= endXTile) {
                if (this.reader.getAbortRequest()) break;
                float percentage = ((float)(x - startXTile) + 1.0f + (float)(y * totalXTiles)) / (float)totalTiles;
                this.ictransf.setTile(x, y);
                int cTileHeight = this.ictransf.getTileHeight();
                int cTileWidth = this.ictransf.getTileWidth();
                int tx = 0;
                int ty = 0;
                int startX = this.tileXOffset + x * this.tileWidth;
                int startY = this.tileYOffset + y * this.tileHeight;
                if (sourceSX > startX) {
                    if (startX >= this.sourceOrigin.x) {
                        cTileWidth += startX - sourceSX;
                        tx = sourceSX - startX;
                    }
                    startX = sourceSX;
                }
                if (sourceSY > startY) {
                    if (startY >= this.sourceOrigin.y) {
                        cTileHeight += startY - sourceSY;
                        ty = sourceSY - startY;
                    }
                    startY = sourceSY;
                }
                if (sourceEX < startX + cTileWidth - 1) {
                    cTileWidth += sourceEX - startX - cTileWidth + 1;
                }
                if (sourceEY < startY + cTileHeight - 1) {
                    cTileHeight += sourceEY - startY - cTileHeight + 1;
                }
                int x1 = (startX + this.scaleX - 1 - this.sourceOrigin.x) / this.scaleX;
                int x2 = (startX + this.scaleX - 1 + cTileWidth - this.sourceOrigin.x) / this.scaleX;
                int lineLength = x2 - x1;
                if (pixbuf == null || pixbuf.length < lineLength) {
                    pixbuf = new int[lineLength];
                }
                x2 = (x2 - 1) * this.scaleX + this.sourceOrigin.x - startX;
                int y1 = (startY + this.scaleY - 1 - this.sourceOrigin.y) / this.scaleY;
                startY = y1 * this.scaleY + this.sourceOrigin.y - (startY == this.sourceOrigin.y ? startY : this.tileYOffset + y * this.tileHeight);
                x1 += offx;
                int l = startY;
                int m = y1 += offy;
                while (l < ty + cTileHeight) {
                    if (this.reader.getAbortRequest()) break;
                    int i = 0;
                    while (i < numBands) {
                        int tmp;
                        int j;
                        DataBlkInt db = this.dataBlocks[i];
                        db.ulx = tx;
                        db.uly = l;
                        db.w = cTileWidth;
                        db.h = 1;
                        this.ictransf.getInternCompData(db, this.channelMap[this.sourceBands[i]]);
                        prog = prog || db.progressive;
                        int[] data = db.data;
                        int k1 = db.offset + x2;
                        int fracBit = this.fracBits[i];
                        int lS = this.levelShift[i];
                        int max = this.maxValues[i];
                        if (ImageUtil.isBinary(this.sampleModel)) {
                            if (this.bytebuf == null || this.bytebuf.length < cTileWidth * numBands) {
                                this.bytebuf = new byte[cTileWidth * numBands];
                            }
                            j = lineLength - 1;
                            while (j >= 0) {
                                tmp = (data[k1] >> fracBit) + lS;
                                this.bytebuf[j] = (byte)(tmp < 0 ? 0 : (tmp > max ? max : tmp));
                                --j;
                                k1 -= this.scaleX;
                            }
                        } else {
                            j = lineLength - 1;
                            while (j >= 0) {
                                tmp = (data[k1] >> fracBit) + lS;
                                pixbuf[j] = tmp < 0 ? 0 : (tmp > max ? max : tmp);
                                --j;
                                k1 -= this.scaleX;
                            }
                            raster.setSamples(x1, m, lineLength, 1, this.destinationBands[i], pixbuf);
                        }
                        ++i;
                    }
                    if (ImageUtil.isBinary(this.sampleModel)) {
                        ImageUtil.setUnpackedBinaryData(this.bytebuf, raster, new Rectangle(x1, m, cTileWidth, 1));
                    }
                    if (this.destImage != null) {
                        this.reader.processImageUpdateWrapper(this.destImage, x1, m, cTileWidth, 1, 1, 1, this.destinationBands);
                    }
                    this.reader.processImageProgressWrapper(percentage + ((float)(l - startY) + 1.0f) / (float)cTileHeight / (float)totalTiles);
                    l += this.scaleY;
                    ++m;
                }
                ++x;
            }
            ++y;
        }
        return raster;
    }

    public ImageTypeSpecifier getImageType() throws IOException {
        this.getSampleModel();
        this.getColorModel();
        return new ImageTypeSpecifier(this.colorModel, this.sampleModel);
    }

    public SampleModel getSampleModel() {
        if (this.sampleModel != null) {
            return this.sampleModel;
        }
        if (this.nComp == 1 && (this.maxDepth == 1 || this.maxDepth == 2 || this.maxDepth == 4)) {
            this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, this.maxDepth);
        } else if (this.maxDepth <= 8) {
            this.sampleModel = new PixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.nComp, this.tileWidth * this.nComp, this.bandOffsets);
        } else if (this.maxDepth <= 16) {
            this.sampleModel = new PixelInterleavedSampleModel(this.isSigned ? 2 : 1, this.tileWidth, this.tileHeight, this.nComp, this.tileWidth * this.nComp, this.bandOffsets);
        } else if (this.maxDepth <= 32) {
            this.sampleModel = new PixelInterleavedSampleModel(3, this.tileWidth, this.tileHeight, this.nComp, this.tileWidth * this.nComp, this.bandOffsets);
        } else {
            throw new IllegalArgumentException(I18N.getString("J2KReadState11") + " " + this.maxDepth);
        }
        return this.sampleModel;
    }

    public ColorModel getColorModel() {
        if (this.colorModel != null) {
            return this.colorModel;
        }
        this.colorModel = this.ff.getColorModel();
        if (this.colorModel != null) {
            return this.colorModel;
        }
        if (this.sampleModel == null) {
            this.sampleModel = this.getSampleModel();
        }
        if (this.sampleModel == null) {
            return null;
        }
        return ImageUtil.createColorModel(null, this.sampleModel);
    }

    private int clip(int value, int min, int max) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    private void clipDestination(Rectangle dest) {
        Point offset = this.j2krparam.getDestinationOffset();
        if (dest.x < offset.x) {
            dest.width += dest.x - offset.x;
            dest.x = offset.x;
        }
        if (dest.y < offset.y) {
            dest.height += dest.y - offset.y;
            dest.y = offset.y;
        }
    }
}

