/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageioimpl.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFJPEGDecompressor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class TIFFOldJPEGDecompressor
extends TIFFJPEGDecompressor {
    private static final int DHT = 196;
    private static final int DQT = 219;
    private static final int DRI = 221;
    private static final int SOF0 = 192;
    private static final int SOS = 218;
    private boolean isInterchangeFormat = false;
    private char restartInterval = '\u0000';
    private int subsamplingX = 2;
    private int subsamplingY = 2;

    public void beginDecoding() {
        super.beginDecoding();
        TIFFImageMetadata tim = (TIFFImageMetadata)this.metadata;
        TIFFField f = tim.getTIFFField(513);
        this.isInterchangeFormat = f != null;
    }

    public void decodeRaw(byte[] b, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        TIFFImageMetadata tim = (TIFFImageMetadata)this.metadata;
        if (this.isInterchangeFormat) {
            TIFFField f = tim.getTIFFField(513);
            int jpegInterchangeOffset = f.getAsInt(0);
            this.stream.seek(jpegInterchangeOffset);
            this.JPEGReader.setInput(this.stream, false, true);
        } else {
            int i;
            if (this.tables == null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(255);
                baos.write(216);
                TIFFField f = tim.getTIFFField(519);
                if (f == null) {
                    throw new IIOException("JPEGQTables field missing!");
                }
                long[] off = f.getAsLongs();
                int i2 = 0;
                while (i2 < off.length) {
                    baos.write(255);
                    baos.write(219);
                    int markerLength = 67;
                    baos.write(markerLength >>> 8 & 0xFF);
                    baos.write(markerLength & 0xFF);
                    baos.write(i2);
                    byte[] qtable = new byte[64];
                    this.stream.seek(off[i2]);
                    this.stream.readFully(qtable);
                    baos.write(qtable);
                    ++i2;
                }
                int k = 0;
                while (k < 2) {
                    int tableTagNumber = k == 0 ? 520 : 521;
                    f = tim.getTIFFField(tableTagNumber);
                    if (f == null) {
                        String fieldName = tableTagNumber == 520 ? "JPEGDCTables" : "JPEGACTables";
                        throw new IIOException(fieldName + " field missing!");
                    }
                    off = f.getAsLongs();
                    i = 0;
                    while (i < off.length) {
                        baos.write(255);
                        baos.write(196);
                        byte[] blengths = new byte[16];
                        this.stream.seek(off[i]);
                        this.stream.readFully(blengths);
                        int numCodes = 0;
                        int j = 0;
                        while (j < 16) {
                            numCodes += blengths[j] & 0xFF;
                            ++j;
                        }
                        char markerLength = (char)(19 + numCodes);
                        baos.write(markerLength >>> 8 & 0xFF);
                        baos.write(markerLength & 0xFF);
                        baos.write(i | k << 4);
                        baos.write(blengths);
                        byte[] bcodes = new byte[numCodes];
                        this.stream.readFully(bcodes);
                        baos.write(bcodes);
                        ++i;
                    }
                    ++k;
                }
                f = tim.getTIFFField(515);
                if (f != null) {
                    this.restartInterval = f.getAsChars()[0];
                }
                if ((f = tim.getTIFFField(530)) != null) {
                    this.subsamplingX = f.getAsChars()[0];
                    this.subsamplingY = f.getAsChars()[1];
                }
                this.tables = baos.toByteArray();
            }
            int headerLength = 26 + 5 * this.samplesPerPixel;
            int tableLength = this.tables != null ? this.tables.length : 0;
            int bufLength = tableLength + headerLength + this.byteCount + 2;
            byte[] buf = new byte[bufLength];
            if (this.tables != null) {
                System.arraycopy(this.tables, 0, buf, 0, tableLength);
            }
            int bufOffset = tableLength;
            buf[bufOffset++] = -1;
            buf[bufOffset++] = -64;
            int sval = 8 + 3 * this.samplesPerPixel;
            buf[bufOffset++] = (byte)(sval >>> 8 & 0xFF);
            buf[bufOffset++] = (byte)(sval & 0xFF);
            buf[bufOffset++] = 8;
            sval = (short)this.srcHeight;
            buf[bufOffset++] = (byte)(sval >>> 8 & 0xFF);
            buf[bufOffset++] = (byte)(sval & 0xFF);
            sval = (short)this.srcWidth;
            buf[bufOffset++] = (byte)(sval >>> 8 & 0xFF);
            buf[bufOffset++] = (byte)(sval & 0xFF);
            buf[bufOffset++] = (byte)this.samplesPerPixel;
            if (this.samplesPerPixel == 1) {
                buf[bufOffset++] = 1;
                buf[bufOffset++] = 17;
                buf[bufOffset++] = 0;
            } else {
                i = 0;
                while (i < 3) {
                    buf[bufOffset++] = (byte)(i + 1);
                    buf[bufOffset++] = (byte)(i == 0 ? 17 : (byte)((this.subsamplingX & 0xF) << 4 | this.subsamplingY & 0xF));
                    buf[bufOffset++] = (byte)i;
                    ++i;
                }
            }
            if (this.restartInterval != '\u0000') {
                buf[bufOffset++] = -1;
                buf[bufOffset++] = -35;
                sval = 4;
                buf[bufOffset++] = (byte)(sval >>> 8 & 0xFF);
                buf[bufOffset++] = (byte)(sval & 0xFF);
                buf[bufOffset++] = (byte)(this.restartInterval >>> 8 & 0xFF);
                buf[bufOffset++] = (byte)(this.restartInterval & 0xFF);
            }
            buf[bufOffset++] = -1;
            buf[bufOffset++] = -38;
            sval = (short)(6 + 2 * this.samplesPerPixel);
            buf[bufOffset++] = (byte)(sval >>> 8 & 0xFF);
            buf[bufOffset++] = (byte)(sval & 0xFF);
            buf[bufOffset++] = (byte)this.samplesPerPixel;
            if (this.samplesPerPixel == 1) {
                buf[bufOffset++] = 1;
                buf[bufOffset++] = 0;
            } else {
                i = 0;
                while (i < 3) {
                    buf[bufOffset++] = (byte)(i + 1);
                    buf[bufOffset++] = (byte)(i << 4 | i);
                    ++i;
                }
            }
            buf[bufOffset++] = 0;
            buf[bufOffset++] = 63;
            buf[bufOffset++] = 0;
            this.stream.seek(this.offset);
            this.stream.readFully(buf, bufOffset, this.byteCount);
            bufOffset += this.byteCount;
            buf[bufOffset++] = -1;
            buf[bufOffset++] = -39;
            ByteArrayInputStream bais = new ByteArrayInputStream(buf, 0, bufOffset);
            MemoryCacheImageInputStream is = new MemoryCacheImageInputStream(bais);
            this.JPEGReader.setInput(is, true, true);
        }
        this.JPEGParam.setDestination(this.rawImage);
        this.JPEGReader.read(0, this.JPEGParam);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.JPEGReader.dispose();
    }

    static {
        DHT = 196;
        DQT = 219;
        DRI = 221;
        SOF0 = 192;
        SOS = 218;
    }
}

