/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFCompressor;
import java.io.IOException;

public class TIFFPackBitsCompressor
extends TIFFCompressor {
    public TIFFPackBitsCompressor() {
        super("PackBits", 32773, true);
    }

    private static int packBits(byte[] input, int inOffset, int inCount, byte[] output, int outOffset) {
        int inMax = inOffset + inCount - 1;
        int inMaxMinus1 = inMax - 1;
        while (inOffset <= inMax) {
            int run = 1;
            byte replicate = input[inOffset];
            while (run < 127 && inOffset < inMax && input[inOffset] == input[inOffset + 1]) {
                ++run;
                ++inOffset;
            }
            if (run > 1) {
                ++inOffset;
                output[outOffset++] = (byte)(-(run - 1));
                output[outOffset++] = replicate;
            }
            run = 0;
            int saveOffset = outOffset;
            while (run < 128 && (inOffset < inMax && input[inOffset] != input[inOffset + 1] || inOffset < inMaxMinus1 && input[inOffset] != input[inOffset + 2])) {
                ++run;
                output[++outOffset] = input[inOffset++];
            }
            if (run > 0) {
                output[saveOffset] = (byte)(run - 1);
                ++outOffset;
            }
            if (inOffset != inMax) continue;
            if (run > 0 && run < 128) {
                int n = saveOffset;
                output[n] = (byte)(output[n] + 1);
                output[outOffset++] = input[inOffset++];
                continue;
            }
            output[outOffset++] = 0;
            output[outOffset++] = input[inOffset++];
        }
        return outOffset;
    }

    public int encode(byte[] b, int off, int width, int height, int[] bitsPerSample, int scanlineStride) throws IOException {
        int bitsPerPixel = 0;
        int i = 0;
        while (i < bitsPerSample.length) {
            bitsPerPixel += bitsPerSample[i];
            ++i;
        }
        int bytesPerRow = (bitsPerPixel * width + 7) / 8;
        int bufSize = bytesPerRow + (bytesPerRow + 127) / 128;
        byte[] compData = new byte[bufSize];
        int bytesWritten = 0;
        int i2 = 0;
        while (i2 < height) {
            int bytes = TIFFPackBitsCompressor.packBits(b, off, scanlineStride, compData, 0);
            off += scanlineStride;
            bytesWritten += bytes;
            this.stream.write(compData, 0, bytes);
            ++i2;
        }
        return bytesWritten;
    }
}

