/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy.encoder;

import jj2000.j2k.entropy.encoder.ByteOutputBuffer;
import jj2000.j2k.util.ArrayUtil;

public class MQCoder {
    public static final int LENGTH_LAZY = 0;
    public static final int LENGTH_LAZY_GOOD = 1;
    public static final int LENGTH_NEAR_OPT = 2;
    public static final int TERM_FULL = 0;
    public static final int TERM_NEAR_OPT = 1;
    public static final int TERM_EASY = 2;
    public static final int TERM_PRED_ER = 3;
    static final int[] qe;
    static final int[] nMPS;
    static final int[] nLPS;
    static final int[] switchLM;
    ByteOutputBuffer out;
    int[] mPS;
    int[] I;
    int c;
    int cT;
    int a;
    int b;
    boolean delFF;
    int nrOfWrittenBytes = -1;
    int[] initStates;
    int ttype;
    int ltype;
    int[] savedC;
    int[] savedCT;
    int[] savedA;
    int[] savedB;
    boolean[] savedDelFF;
    int nSaved;
    static final int SAVED_LEN = 96;
    static final int SAVED_INC = 12;

    public void setLenCalcType(int ltype) {
        if (ltype != 0 && ltype != 1 && ltype != 2) {
            throw new IllegalArgumentException("Unrecognized length calculation type code: " + ltype);
        }
        if (ltype == 2) {
            if (this.savedC == null) {
                this.savedC = new int[96];
            }
            if (this.savedCT == null) {
                this.savedCT = new int[96];
            }
            if (this.savedA == null) {
                this.savedA = new int[96];
            }
            if (this.savedB == null) {
                this.savedB = new int[96];
            }
            if (this.savedDelFF == null) {
                this.savedDelFF = new boolean[96];
            }
        }
        this.ltype = ltype;
    }

    public void setTermType(int ttype) {
        if (ttype != 0 && ttype != 1 && ttype != 2 && ttype != 3) {
            throw new IllegalArgumentException("Unrecognized termination type code: " + ttype);
        }
        this.ttype = ttype;
    }

    public MQCoder(ByteOutputBuffer oStream, int nrOfContexts, int[] init) {
        this.out = oStream;
        this.I = new int[nrOfContexts];
        this.mPS = new int[nrOfContexts];
        this.initStates = init;
        this.a = 32768;
        this.c = 0;
        this.cT = this.b == 255 ? 13 : 12;
        this.resetCtxts();
        this.b = 0;
    }

    public final void fastCodeSymbols(int bit, int ctxt, int n) {
        int ns;
        int li = this.I[ctxt];
        int q = qe[li];
        if (q <= 16384 && bit == this.mPS[ctxt] && (ns = (this.a - 32768) / q + 1) > 1) {
            do {
                int la;
                if (n <= ns) {
                    la = n * q;
                    this.a -= la;
                    this.c += la;
                    if (this.a >= 32768) {
                        this.I[ctxt] = li;
                        return;
                    }
                    this.I[ctxt] = nMPS[li];
                    this.a <<= 1;
                    this.c <<= 1;
                    --this.cT;
                    if (this.cT == 0) {
                        this.byteOut();
                    }
                    return;
                }
                la = ns * q;
                this.c += la;
                this.a -= la;
                li = nMPS[li];
                q = qe[li];
                this.a <<= 1;
                this.c <<= 1;
                --this.cT;
                if (this.cT != 0) continue;
                this.byteOut();
            } while ((n -= (ns = (this.a - 32768) / q + 1)) > 0);
        } else {
            int la = this.a;
            do {
                if (bit == this.mPS[ctxt]) {
                    if ((la -= q) >= 32768) {
                        this.c += q;
                        continue;
                    }
                    if (la < q) {
                        la = q;
                    } else {
                        this.c += q;
                    }
                    li = nMPS[li];
                    q = qe[li];
                    la <<= 1;
                    this.c <<= 1;
                    --this.cT;
                    if (this.cT != 0) continue;
                    this.byteOut();
                    continue;
                }
                if ((la -= q) < q) {
                    this.c += q;
                } else {
                    la = q;
                }
                if (switchLM[li] != 0) {
                    this.mPS[ctxt] = 1 - this.mPS[ctxt];
                }
                li = nLPS[li];
                q = qe[li];
                int nc = 0;
                do {
                    ++nc;
                } while ((la <<= 1) < 32768);
                if (this.cT > nc) {
                    this.c <<= nc;
                    this.cT -= nc;
                    continue;
                }
                do {
                    this.c <<= this.cT;
                    this.byteOut();
                } while (this.cT <= (nc -= this.cT));
                this.c <<= nc;
                this.cT -= nc;
            } while (--n > 0);
            this.I[ctxt] = li;
            this.a = la;
        }
    }

    public final void codeSymbols(int[] bits, int[] cX, int n) {
        int la = this.a;
        int i = 0;
        while (i < n) {
            int ctxt = cX[i];
            int li = this.I[ctxt];
            int q = qe[li];
            if (bits[i] == this.mPS[ctxt]) {
                if ((la -= q) >= 32768) {
                    this.c += q;
                } else {
                    if (la < q) {
                        la = q;
                    } else {
                        this.c += q;
                    }
                    this.I[ctxt] = nMPS[li];
                    la <<= 1;
                    this.c <<= 1;
                    --this.cT;
                    if (this.cT == 0) {
                        this.byteOut();
                    }
                }
            } else {
                if ((la -= q) < q) {
                    this.c += q;
                } else {
                    la = q;
                }
                if (switchLM[li] != 0) {
                    this.mPS[ctxt] = 1 - this.mPS[ctxt];
                }
                this.I[ctxt] = nLPS[li];
                int nc = 0;
                do {
                    ++nc;
                } while ((la <<= 1) < 32768);
                if (this.cT > nc) {
                    this.c <<= nc;
                    this.cT -= nc;
                } else {
                    do {
                        this.c <<= this.cT;
                        this.byteOut();
                    } while (this.cT <= (nc -= this.cT));
                    this.c <<= nc;
                    this.cT -= nc;
                }
            }
            ++i;
        }
        this.a = la;
    }

    public final void codeSymbol(int bit, int context) {
        int li = this.I[context];
        int q = qe[li];
        if (bit == this.mPS[context]) {
            this.a -= q;
            if (this.a >= 32768) {
                this.c += q;
            } else {
                if (this.a < q) {
                    this.a = q;
                } else {
                    this.c += q;
                }
                this.I[context] = nMPS[li];
                this.a <<= 1;
                this.c <<= 1;
                --this.cT;
                if (this.cT == 0) {
                    this.byteOut();
                }
            }
        } else {
            int la = this.a;
            if ((la -= q) < q) {
                this.c += q;
            } else {
                la = q;
            }
            if (switchLM[li] != 0) {
                this.mPS[context] = 1 - this.mPS[context];
            }
            this.I[context] = nLPS[li];
            int n = 0;
            do {
                ++n;
            } while ((la <<= 1) < 32768);
            if (this.cT > n) {
                this.c <<= n;
                this.cT -= n;
            } else {
                do {
                    this.c <<= this.cT;
                    this.byteOut();
                } while (this.cT <= (n -= this.cT));
                this.c <<= n;
                this.cT -= n;
            }
            this.a = la;
        }
    }

    private void byteOut() {
        if (this.nrOfWrittenBytes >= 0) {
            if (this.b == 255) {
                this.delFF = true;
                this.b = this.c >>> 20;
                this.c &= 0xFFFFF;
                this.cT = 7;
            } else if (this.c < 0x8000000) {
                if (this.delFF) {
                    this.out.write(255);
                    this.delFF = false;
                    ++this.nrOfWrittenBytes;
                }
                this.out.write(this.b);
                ++this.nrOfWrittenBytes;
                this.b = this.c >>> 19;
                this.c &= 0x7FFFF;
                this.cT = 8;
            } else {
                ++this.b;
                if (this.b == 255) {
                    this.delFF = true;
                    this.c &= 0x7FFFFFF;
                    this.b = this.c >>> 20;
                    this.c &= 0xFFFFF;
                    this.cT = 7;
                } else {
                    if (this.delFF) {
                        this.out.write(255);
                        this.delFF = false;
                        ++this.nrOfWrittenBytes;
                    }
                    this.out.write(this.b);
                    ++this.nrOfWrittenBytes;
                    this.b = this.c >>> 19 & 0xFF;
                    this.c &= 0x7FFFF;
                    this.cT = 8;
                }
            }
        } else {
            this.b = this.c >>> 19;
            this.c &= 0x7FFFF;
            this.cT = 8;
            ++this.nrOfWrittenBytes;
        }
    }

    public int terminate() {
        block0 : switch (this.ttype) {
            case 0: {
                int tempc = this.c + this.a;
                this.c |= 0xFFFF;
                if (this.c >= tempc) {
                    this.c -= 32768;
                }
                int remainingBits = 27 - this.cT;
                do {
                    this.c <<= this.cT;
                    remainingBits = this.b != 255 ? (remainingBits -= 8) : (remainingBits -= 7);
                    this.byteOut();
                } while (remainingBits > 0);
                this.b |= (1 << -remainingBits) - 1;
                if (this.b == 255) {
                    this.delFF = true;
                    break;
                }
                if (this.delFF) {
                    this.out.write(255);
                    this.delFF = false;
                    ++this.nrOfWrittenBytes;
                }
                this.out.write(this.b);
                ++this.nrOfWrittenBytes;
                break;
            }
            case 2: 
            case 3: {
                int k = 11 - this.cT + 1;
                this.c <<= this.cT;
                while (k > 0) {
                    this.byteOut();
                    k -= this.cT;
                    this.c <<= this.cT;
                }
                if (k < 0 && this.ttype == 2) {
                    this.b |= (1 << -k) - 1;
                }
                this.byteOut();
                break;
            }
            case 1: {
                int bUp;
                int cLow = this.c;
                int cUp = this.c + this.a;
                int bLow = bUp = this.b;
                cUp <<= this.cT;
                if (((cLow <<= this.cT) & 0x8000000) != 0) {
                    if (bLow == 255) {
                        this.delFF = true;
                        bLow = cLow >>> 20;
                        bUp = cUp >>> 20;
                        cLow &= 0xFFFFF;
                        cUp &= 0xFFFFF;
                        cLow <<= 7;
                        cUp <<= 7;
                    } else {
                        ++bLow;
                        cLow &= 0xF7FFFFFF;
                    }
                }
                if ((cUp & 0x8000000) != 0) {
                    ++bUp;
                    cUp &= 0xF7FFFFFF;
                }
                while (true) {
                    if (this.delFF) {
                        if (bLow <= 127 && bUp > 127) break block0;
                        this.out.write(255);
                        ++this.nrOfWrittenBytes;
                        this.delFF = false;
                    } else if (bLow <= 255 && bUp > 255) break block0;
                    if (bLow < 255) {
                        if (this.nrOfWrittenBytes >= 0) {
                            this.out.write(bLow);
                        }
                        ++this.nrOfWrittenBytes;
                        bUp -= bLow;
                        bUp <<= 8;
                        bUp |= cUp >>> 19 & 0xFF;
                        bLow = cLow >>> 19 & 0xFF;
                        cLow &= 0x7FFFF;
                        cUp &= 0x7FFFF;
                        cLow <<= 8;
                        cUp <<= 8;
                        continue;
                    }
                    this.delFF = true;
                    bUp -= bLow;
                    bUp <<= 7;
                    bUp |= cUp >> 20 & 0x7F;
                    bLow = cLow >> 20 & 0x7F;
                    cLow &= 0xFFFFF;
                    cUp &= 0xFFFFF;
                    cLow <<= 7;
                    cUp <<= 7;
                }
            }
            default: {
                throw new Error("Illegal termination type code");
            }
        }
        int len = this.nrOfWrittenBytes;
        this.a = 32768;
        this.c = 0;
        this.b = 0;
        this.cT = 12;
        this.delFF = false;
        this.nrOfWrittenBytes = -1;
        return len;
    }

    public final int getNumCtxts() {
        return this.I.length;
    }

    public final void resetCtxt(int c) {
        this.I[c] = this.initStates[c];
        this.mPS[c] = 0;
    }

    public final void resetCtxts() {
        System.arraycopy(this.initStates, 0, this.I, 0, this.I.length);
        ArrayUtil.intArraySet(this.mPS, 0);
    }

    public final int getNumCodedBytes() {
        switch (this.ltype) {
            case 1: {
                int bitsInN3Bytes = this.b >= 254 ? 22 : 23;
                if (11 - this.cT + 16 <= bitsInN3Bytes) {
                    return this.nrOfWrittenBytes + (this.delFF ? 1 : 0) + 1 + 3;
                }
                return this.nrOfWrittenBytes + (this.delFF ? 1 : 0) + 1 + 4;
            }
            case 0: {
                if (27 - this.cT <= 22) {
                    return this.nrOfWrittenBytes + (this.delFF ? 1 : 0) + 1 + 3;
                }
                return this.nrOfWrittenBytes + (this.delFF ? 1 : 0) + 1 + 4;
            }
            case 2: {
                this.saveState();
                return this.nrOfWrittenBytes;
            }
        }
        throw new Error("Illegal length calculation type code");
    }

    public final void reset() {
        this.out.reset();
        this.a = 32768;
        this.c = 0;
        this.b = 0;
        this.cT = this.b == 255 ? 13 : 12;
        this.resetCtxts();
        this.nrOfWrittenBytes = -1;
        this.delFF = false;
        this.nSaved = 0;
    }

    private void saveState() {
        if (this.nSaved == this.savedC.length) {
            Object[] tmp = this.savedC;
            this.savedC = new int[this.nSaved + 12];
            System.arraycopy(tmp, 0, this.savedC, 0, this.nSaved);
            tmp = this.savedCT;
            this.savedCT = new int[this.nSaved + 12];
            System.arraycopy(tmp, 0, this.savedCT, 0, this.nSaved);
            tmp = this.savedA;
            this.savedA = new int[this.nSaved + 12];
            System.arraycopy(tmp, 0, this.savedA, 0, this.nSaved);
            tmp = this.savedB;
            this.savedB = new int[this.nSaved + 12];
            System.arraycopy(tmp, 0, this.savedB, 0, this.nSaved);
            tmp = this.savedDelFF;
            this.savedDelFF = new boolean[this.nSaved + 12];
            System.arraycopy(tmp, 0, this.savedDelFF, 0, this.nSaved);
        }
        this.savedC[this.nSaved] = this.c;
        this.savedCT[this.nSaved] = this.cT;
        this.savedA[this.nSaved] = this.a;
        this.savedB[this.nSaved] = this.b;
        this.savedDelFF[this.nSaved] = this.delFF;
        ++this.nSaved;
    }

    public void finishLengthCalculation(int[] rates, int n) {
        if (this.ltype != 2) {
            if (n > 0 && rates[n - 1] > rates[n]) {
                int tl = rates[n];
                --n;
                do {
                    rates[n--] = tl;
                } while (n >= 0 && rates[n] > tl);
            }
        } else {
            int ridx = n - this.nSaved;
            int minlen = ridx - 1 >= 0 ? rates[ridx - 1] : 0;
            int maxlen = rates[n];
            int sidx = 0;
            while (ridx < n) {
                int cLow = this.savedC[sidx];
                int cUp = this.savedC[sidx] + this.savedA[sidx];
                int bLow = this.savedB[sidx];
                int bUp = this.savedB[sidx];
                if (((cLow <<= this.savedCT[sidx]) & 0x8000000) != 0) {
                    ++bLow;
                    cLow &= 0x7FFFFFF;
                }
                if (((cUp <<= this.savedCT[sidx]) & 0x8000000) != 0) {
                    ++bUp;
                    cUp &= 0x7FFFFFF;
                }
                boolean cdFF = this.savedDelFF[sidx];
                int clen = rates[ridx] + (cdFF ? 1 : 0);
                while (true) {
                    if (clen >= maxlen) {
                        clen = maxlen;
                        break;
                    }
                    if (cdFF) {
                        if (bLow < 128 && bUp >= 128) {
                            --clen;
                            break;
                        }
                    } else if (bLow < 256 && bUp >= 256) break;
                    int nb = clen >= minlen ? this.out.getByte(clen) : 0;
                    bLow -= nb;
                    bUp -= nb;
                    ++clen;
                    if (nb == 255) {
                        bLow <<= 7;
                        bLow |= cLow >> 20 & 0x7F;
                        cLow &= 0xFFFFF;
                        cLow <<= 7;
                        bUp <<= 7;
                        bUp |= cUp >> 20 & 0x7F;
                        cUp &= 0xFFFFF;
                        cUp <<= 7;
                        cdFF = true;
                        continue;
                    }
                    bLow <<= 8;
                    bLow |= cLow >> 19 & 0xFF;
                    cLow &= 0x7FFFF;
                    cLow <<= 8;
                    bUp <<= 8;
                    bUp |= cUp >> 19 & 0xFF;
                    cUp &= 0x7FFFF;
                    cUp <<= 8;
                    cdFF = false;
                }
                rates[ridx] = clen >= minlen ? clen : minlen;
                ++ridx;
                ++sidx;
            }
            this.nSaved = 0;
        }
    }

    static {
        LENGTH_LAZY = 0;
        LENGTH_LAZY_GOOD = 1;
        LENGTH_NEAR_OPT = 2;
        TERM_FULL = 0;
        TERM_NEAR_OPT = 1;
        TERM_EASY = 2;
        TERM_PRED_ER = 3;
        qe = new int[]{22017, 13313, 6145, 2753, 1313, 545, 22017, 21505, 18433, 14337, 12289, 9217, 7169, 5633, 22017, 21505, 20737, 18433, 14337, 13313, 12289, 10241, 9217, 8705, 7169, 6145, 5633, 5121, 4609, 4353, 2753, 2497, 2209, 1313, 1089, 673, 545, 321, 273, 133, 73, 37, 21, 9, 5, 1, 22017};
        nMPS = new int[]{1, 2, 3, 4, 5, 38, 7, 8, 9, 10, 11, 12, 13, 29, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 45, 46};
        nLPS = new int[]{1, 6, 9, 12, 29, 33, 6, 14, 14, 14, 17, 18, 20, 21, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 46};
        switchLM = new int[]{1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        SAVED_LEN = 96;
        SAVED_INC = 12;
    }
}

