/*
 * Decompiled with CFR 0.152.
 */
package core.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class JImagePane
extends JLabel {
    private BufferedImage image;
    private AffineTransform imageTransform;

    public JImagePane() {
    }

    public JImagePane(URL url) {
        this.setURL(url);
    }

    public void setURL(URL url) {
        try {
            this.image = ImageIO.read(url);
        }
        catch (IOException e) {
            this.image = null;
        }
        super.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        double labelWidth = super.getWidth();
        double labelHeight = super.getHeight();
        int imageWidth = this.image.getWidth();
        int imageHeight = this.image.getHeight();
        double sx = labelWidth / (double)imageWidth;
        double sy = labelHeight / (double)imageHeight;
        this.imageTransform = AffineTransform.getScaleInstance(sx, sy);
        g2.drawImage(this.image, this.imageTransform, this);
    }

    public static void main(String[] arg) {
        JImagePane l = new JImagePane();
        l.setPreferredSize(new Dimension(300, 300));
        JFrame f = new JFrame();
        f.getContentPane().add(l);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.show();
    }
}

