/*
 * Decompiled with CFR 0.152.
 */
package core.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

public class JToolbarSeparator
extends JComponent {
    private int orientation;

    public JToolbarSeparator() {
        this(1);
    }

    public JToolbarSeparator(int orientation) {
        this.setOrientation(orientation);
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        if (orientation == 1) {
            this.setMaximumSize(new Dimension(16, Integer.MAX_VALUE));
        } else {
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 16));
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size = this.getSize();
        if (this.orientation == 1) {
            int pos = size.width / 2;
            g.setColor(Color.gray);
            g.drawLine(pos, 3, pos, size.height - 5);
            g.drawLine(pos, 2, pos + 1, 2);
            g.setColor(Color.white);
            g.drawLine(pos + 1, 3, pos + 1, size.height - 5);
            g.drawLine(pos, size.height - 4, pos + 1, size.height - 4);
        } else {
            int pos = size.height / 2;
            g.setColor(Color.gray);
            g.drawLine(2, pos, size.width - 4, pos);
            g.drawLine(1, pos, 1, pos + 1);
            g.setColor(Color.white);
            g.drawLine(2, pos + 1, size.width - 4, pos + 1);
            g.drawLine(size.width - 3, pos, size.width - 3, pos + 1);
        }
    }
}

