/*
 * Decompiled with CFR 0.152.
 */
package core.swing.text;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.DataAccessor;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.java.DAFileProvider;
import org.netbeans.editor.ext.java.JCBaseFinder;
import org.netbeans.editor.ext.java.JCClassProvider;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaDrawLayerFactory;
import org.netbeans.editor.ext.java.JavaFormatter;
import org.netbeans.editor.ext.java.JavaSettingsInitializer;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;

public class JavaKit
extends ExtKit {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    private static final String[] getSetIsPrefixes = new String[]{"get", "set", "is"};
    public static final String makeGetterAction = "make-getter";
    public static final String makeSetterAction = "make-setter";
    public static final String makeIsAction = "make-is";
    public static final String abbrevDebugLineAction = "abbrev-debug-line";
    static final long serialVersionUID = -5445829962533684922L;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("core.swing.text.JavaKit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Settings.addInitializer((Settings.Initializer)new JavaSettingsInitializer((Class)clazz));
        Settings.addInitializer((Settings.Initializer)new SaJavaSettingsInitializer());
        Settings.reset();
        ResourceBundle settings = ResourceBundle.getBundle("settings");
        String jcPath = null;
        try {
            jcPath = settings.getString("Java_Completion");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (jcPath != null) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("core.swing.text.JavaKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            URL skeleton = clazz2.getResource("/" + jcPath + ".jcs");
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("core.swing.text.JavaKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            URL body = clazz3.getResource("/" + jcPath + ".jcb");
            if (skeleton == null || body == null) {
                System.err.println("Warning: Java parser databases not found. Ignoring.");
            } else {
                DAFileProvider provider = new DAFileProvider((DataAccessor)new URLAccessor(skeleton), (DataAccessor)new URLAccessor(body));
                JCBaseFinder finder = new JCBaseFinder();
                finder.append((JCClassProvider)provider);
                JavaCompletion.setFinder((JCFinder)finder);
            }
        }
    }

    public String getContentType() {
        return JAVA_MIME_TYPE;
    }

    public Syntax createSyntax(Document doc) {
        return new JavaSyntax();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument doc) {
        return new JavaSyntaxSupport(doc);
    }

    public Completion createCompletion(ExtEditorUI extEditorUI) {
        return new JavaCompletion(extEditorUI);
    }

    public Formatter createFormatter() {
        return new JavaFormatter(((Object)((Object)this)).getClass());
    }

    protected EditorUI createEditorUI() {
        return new ExtEditorUI();
    }

    protected void initDocument(BaseDocument doc) {
        doc.addLayer((DrawLayer)new JavaDrawLayerFactory.JavaLayer(), 1010);
        doc.addDocumentListener((DocumentListener)new JavaDrawLayerFactory.LParenWatcher());
    }

    protected Action[] createActions() {
        Action[] javaActions = new Action[]{new JavaDefaultKeyTypedAction(), new ExtKit.PrefixMakerAction(makeGetterAction, "get", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeSetterAction, "set", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeIsAction, "is", getSetIsPrefixes), new AbbrevDebugLineAction()};
        return TextAction.augmentList(super.createActions(), javaActions);
    }

    public static class JavaDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        protected void checkIndentHotChars(JTextComponent target, String typedText) {
            boolean reindent = false;
            BaseDocument doc = Utilities.getDocument((JTextComponent)target);
            int dotPos = target.getCaret().getDot();
            if (doc != null) {
                if ("e".equals(typedText)) {
                    try {
                        int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                        if (fnw >= 0 && fnw + 4 == dotPos && "else".equals(doc.getText(fnw, 4))) {
                            reindent = true;
                        }
                    }
                    catch (BadLocationException e) {}
                } else if (":".equals(typedText)) {
                    try {
                        int fnw = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)dotPos);
                        if (fnw >= 0 && fnw + 4 <= doc.getLength() && "case".equals(doc.getText(fnw, 4))) {
                            reindent = true;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                if (reindent) {
                    try {
                        Utilities.reformatLine((BaseDocument)doc, (int)dotPos);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            super.checkIndentHotChars(target, typedText);
        }
    }

    public static class AbbrevDebugLineAction
    extends BaseAction {
        public AbbrevDebugLineAction() {
            super(JavaKit.abbrevDebugLineAction);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                BaseDocument doc = (BaseDocument)target.getDocument();
                StringBuffer sb = new StringBuffer("System.err.println(\"");
                File file = (File)doc.getProperty("file");
                if (file != null) {
                    sb.append(file.getAbsolutePath());
                    sb.append(':');
                }
                try {
                    sb.append(Utilities.getLineOffset((BaseDocument)doc, (int)target.getCaret().getDot()) + 1);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                sb.append(' ');
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                Action a = kit.getActionByName("insert-content");
                if (a != null) {
                    Utilities.performAction((Action)a, (ActionEvent)new ActionEvent(target, 1001, sb.toString()), (JTextComponent)target);
                }
            }
        }
    }

    private static class SaJavaSettingsInitializer
    extends Settings.AbstractInitializer {
        static /* synthetic */ Class class$0;

        public SaJavaSettingsInitializer() {
            super("sa-java-settings-initializer");
        }

        public void updateSettingsMap(Class kitClass, Map settingsMap) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("core.swing.text.JavaKit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (kitClass == clazz) {
                SettingsUtil.updateListSetting((Map)settingsMap, (String)"key-bindings", (Object[])this.getJavaKeyBindings());
            }
        }

        public MultiKeyBinding[] getJavaKeyBindings() {
            return new MultiKeyBinding[]{new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(85, 8), KeyStroke.getKeyStroke(71, 0)}, JavaKit.makeGetterAction), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(85, 8), KeyStroke.getKeyStroke(83, 0)}, JavaKit.makeSetterAction), new MultiKeyBinding(new KeyStroke[]{KeyStroke.getKeyStroke(85, 8), KeyStroke.getKeyStroke(73, 0)}, JavaKit.makeIsAction), new MultiKeyBinding(KeyStroke.getKeyStroke(68, 8), JavaKit.abbrevDebugLineAction)};
        }
    }

    public static class URLAccessor
    implements DataAccessor {
        URL url;
        InputStream stream;
        int streamOff;
        int actOff;

        public URLAccessor(URL url) {
            this.url = url;
        }

        public void append(byte[] buffer, int off, int len) throws IOException {
            throw new IllegalArgumentException("read only!");
        }

        public void read(byte[] buffer, int off, int len) throws IOException {
            InputStream str = this.getStream(this.actOff);
            while (len > 0) {
                int count = str.read(buffer, off, len);
                this.streamOff += count;
                off += count;
                len -= count;
            }
        }

        public void open(boolean requestWrite) throws IOException {
            if (requestWrite) {
                throw new IllegalArgumentException("read only!");
            }
        }

        public void close() throws IOException {
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
        }

        public long getFilePointer() throws IOException {
            return this.actOff;
        }

        public void resetFile() throws IOException {
            throw new IllegalArgumentException("read only!");
        }

        public void seek(long pos) throws IOException {
            this.actOff = (int)pos;
        }

        private InputStream getStream(int off) throws IOException {
            if (this.streamOff > off && this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
            if (this.stream == null) {
                this.stream = this.url.openStream();
                this.streamOff = 0;
            }
            while (this.streamOff < off) {
                long len = this.stream.skip(off - this.streamOff);
                this.streamOff += (int)len;
                if (len != 0L) continue;
                throw new IOException("EOF");
            }
            return this.stream;
        }

        public int getFileLength() {
            try {
                int l = this.url.openConnection().getContentLength();
                return l;
            }
            catch (IOException e) {
                return 0;
            }
        }

        public String toString() {
            return this.url.toString();
        }
    }
}

