/*
 * Decompiled with CFR 0.152.
 */
package core.swing.tree.filesystem;

import core.swing.ResourceManager;
import core.swing.chooser.FileManager;
import core.swing.tree.ObjectTree;
import core.swing.tree.ObjectTreeNode;
import core.swing.tree.ObjectTreeNodeList;
import core.swing.tree.filesystem.FileTreeModel;
import core.swing.tree.filesystem.FileTreeNodeList;
import core.swing.tree.filesystem.FolderTreeNodeList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FileTree
extends ObjectTree {
    protected static String RESOURCES = "core.swing.tree.filesystem.resources.FileTree";
    protected static ResourceManager bundle = ResourceManager.getBundle(RESOURCES);
    protected FileTreeModel fileTreeModel;
    protected File selectedFile;

    public FileTree() {
        this(FileManager.getDefaultDirectory());
    }

    public FileTree(File file) {
        this(new FolderTreeNodeList(file));
    }

    public FileTree(FileTreeNodeList n) {
        this(new FileTreeModel(n));
    }

    public FileTree(FileTreeModel m) {
        super(m);
        this.fileTreeModel = m;
        super.getSelectionModel().setSelectionMode(1);
        this.installActions();
    }

    public void setModel(TreeModel m) {
        super.setModel(m);
        this.refresh();
    }

    public void refresh() {
        this.collapseRow(0);
        this.expandRow(0);
        this.setSelectionRow(0);
    }

    public FileTreeModel getFileTreeModel() {
        return this.fileTreeModel;
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    protected void selectedNode(ObjectTreeNode otn) {
        File sel = (File)otn.getUserObject();
        if (this.selectedFile == null || !this.selectedFile.equals(sel)) {
            this.selectedFile = sel;
        }
    }

    protected String convertNodeToText(ObjectTreeNode otn) {
        try {
            File f = (File)otn.getUserObject();
            return FileManager.getSystemDisplayName(f);
        }
        catch (Exception e) {
            return super.convertNodeToText(otn);
        }
    }

    protected Icon convertNodeToIcon(ObjectTreeNode otn) {
        try {
            File f = (File)otn.getUserObject();
            return FileManager.getSystemIcon(f);
        }
        catch (Exception e) {
            return super.convertNodeToIcon(otn);
        }
    }

    protected void installActions() {
        this.getInputMap().put(KeyStroke.getKeyStroke("alt N"), "newFolder");
        this.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
        this.getInputMap().put(KeyStroke.getKeyStroke("alt M"), "rename");
        this.getActionMap().put("newFolder", new NewFolderAction());
        this.getActionMap().put("delete", new DeleteAction());
        this.getActionMap().put("rename", new RenameAction());
    }

    public static void main(String[] arg) throws InterruptedException {
        FileTree t = new FileTree();
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)new JScrollPane(t), "Center");
        f.pack();
        f.show();
    }

    protected class NewFolderAction
    extends AbstractAction {
        private TreePath targetPath;
        private TreePath parentPath;
        private TreePath childPath;
        private ObjectTreeNodeList parent;
        private ObjectTreeNode target;
        private ObjectTreeNode child;
        private File targetFile;
        private File parentFile;
        private File childFile;
        private int indexof;

        protected NewFolderAction() {
        }

        public void actionPerformed(ActionEvent e) {
            this.targetPath = FileTree.this.getSelectionPath();
            this.target = (ObjectTreeNode)this.targetPath.getLastPathComponent();
            this.targetFile = (File)this.target.getUserObject();
            this.parent = this.target instanceof FileTreeNodeList ? (FileTreeNodeList)this.target : (FileTreeNodeList)this.target.getParent();
            this.parentPath = new TreePath(this.target.getPath());
            this.parentFile = (File)this.parent.getUserObject();
            this.childFile = FileManager.newFolder(this.parentFile);
            if (this.childFile != null) {
                this.parent.rebuild();
                FileTree.this.collapsePath(this.parentPath);
                FileTree.this.expandPath(this.parentPath);
                this.indexof = this.parent.indexOf(new FileTreeNodeList(this.childFile));
                this.child = (FileTreeNodeList)this.parent.elementAt(this.indexof);
                this.childPath = new TreePath(this.child.getPath());
                FileTree.this.setSelectionPath(this.childPath);
                FileTree.this.scrollPathToVisible(this.childPath);
            }
        }
    }

    protected class DeleteAction
    extends AbstractAction {
        private TreePath targetPath;
        private TreePath parentPath;
        private TreePath childPath;
        private ObjectTreeNodeList parent;
        private ObjectTreeNode target;
        private ObjectTreeNode child;
        private File targetFile;
        private File parentFile;
        private File childFile;
        private int indexof;

        protected DeleteAction() {
        }

        public void actionPerformed(ActionEvent e) {
            String title;
            this.targetPath = FileTree.this.getSelectionPath();
            this.target = (ObjectTreeNode)this.targetPath.getLastPathComponent();
            this.targetFile = (File)this.target.getUserObject();
            if (this.target.isRoot()) {
                return;
            }
            String msg = bundle.getString("DeleteDialog.message", new Object[]{this.targetFile});
            int i = JOptionPane.showConfirmDialog(FileTree.this, msg, title = bundle.getString("DeleteDialog.title"), 0);
            if (i == 0) {
                File deleteFile = FileManager.deleteFile(this.targetFile);
                if (deleteFile != null) {
                    this.parent = (ObjectTreeNodeList)this.target.getParent();
                    this.parentPath = new TreePath(this.parent.getPath());
                    this.indexof = this.parent.indexOf(this.target);
                    this.parent.rebuild();
                    FileTree.this.collapsePath(this.parentPath);
                    FileTree.this.expandPath(this.parentPath);
                    if (this.parent.size() - 1 < this.indexof) {
                        FileTree.this.setSelectionPath(this.parentPath);
                        FileTree.this.scrollPathToVisible(this.parentPath);
                    } else {
                        this.child = (ObjectTreeNode)this.parent.elementAt(this.indexof);
                        this.childPath = new TreePath(this.child.getPath());
                        FileTree.this.setSelectionPath(this.childPath);
                        FileTree.this.scrollPathToVisible(this.childPath);
                    }
                } else {
                    msg = bundle.getString("DeleteErrorDialog.message", new Object[]{this.targetFile});
                    title = bundle.getString("DeleteErrorDialog.title");
                    JOptionPane.showMessageDialog(FileTree.this, msg, title, 2);
                }
            }
        }
    }

    protected class RenameAction
    extends AbstractAction {
        private TreePath targetPath;
        private TreePath parentPath;
        private TreePath childPath;
        private ObjectTreeNodeList parent;
        private ObjectTreeNode target;
        private ObjectTreeNode child;
        private File targetFile;
        private File parentFile;
        private File childFile;
        private int indexof;

        protected RenameAction() {
        }

        public void actionPerformed(ActionEvent e) {
            this.targetPath = FileTree.this.getSelectionPath();
            this.target = (ObjectTreeNode)this.targetPath.getLastPathComponent();
            this.targetFile = (File)this.target.getUserObject();
            if (this.target.isRoot()) {
                return;
            }
            String oldName = FileManager.getSystemDisplayName(this.targetFile);
            String newName = (String)JOptionPane.showInputDialog(FileTree.this, null, bundle.getString("RenameDialog.message"), 3, null, null, oldName);
            if (newName != null && !oldName.equalsIgnoreCase(newName)) {
                this.childFile = FileManager.renameFile(this.targetFile, newName);
                if (this.childFile != null) {
                    this.parent = (FileTreeNodeList)this.target.getParent();
                    this.parentPath = new TreePath(this.parent.getPath());
                    this.parent.rebuild();
                    FileTree.this.collapsePath(this.parentPath);
                    FileTree.this.expandPath(this.parentPath);
                    this.indexof = this.parent.indexOf(new ObjectTreeNode(this.childFile));
                    this.child = (ObjectTreeNode)this.parent.elementAt(this.indexof);
                    this.childPath = new TreePath(this.child.getPath());
                    FileTree.this.setSelectionPath(this.childPath);
                    FileTree.this.scrollPathToVisible(this.childPath);
                }
            }
        }
    }
}

