/*
 * Decompiled with CFR 0.152.
 */
package core.xml;

import core.xml.DOMWriterException;
import core.xml.XMLWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import org.w3c.dom.Node;

public class DOMWriterWrapper {
    private static XMLWriter xmlWriter;

    private static void writeByXMLWriter(Node n, Writer out) throws DOMWriterException {
        try {
            if (xmlWriter == null) {
                xmlWriter = new XMLWriter();
            }
            xmlWriter.writeXml(n, out);
            out.flush();
        }
        catch (IOException e) {
            throw new DOMWriterException(e);
        }
    }

    public static void write(Node n, String uri) throws DOMWriterException {
        File f = new File(uri);
        DOMWriterWrapper.write(n, f);
    }

    public static void write(Node n, URI u) throws DOMWriterException {
        File f = new File(u);
        DOMWriterWrapper.write(n, f);
    }

    public static void write(Node n, File file) throws DOMWriterException {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            DOMWriterWrapper.write(n, writer);
        }
        catch (IOException e) {
            throw new DOMWriterException(e);
        }
    }

    public static void write(Node n, Writer out) throws DOMWriterException {
        DOMWriterWrapper.writeByXMLWriter(n, out);
    }

    public static void writeByXMLWriter(Node n, OutputStream out) throws DOMWriterException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        DOMWriterWrapper.write(n, writer);
    }
}

