/*
 * Decompiled with CFR 0.152.
 */
package imhotep.dom;

import core.swing.CommandManager;
import core.swing.ResourceManager;
import imhotep.dom.DomModel;
import imhotep.dom.DomNode;
import imhotep.model.SVGModel;
import imhotep.util.NodeSelection;
import imhotep.util.SVGNodeUtilities;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public class DomTree
extends JTree
implements Comparator {
    private static String RESOURCES = "imhotep.dom.resources.DomTree";
    private static ResourceManager resource = ResourceManager.getBundle(RESOURCES);
    private static CommandManager commands = CommandManager.getSystemBundle();
    private DomModel domModel = new DomModel();
    private SVGModel svgModel;
    private String title;

    public DomTree() {
        super.setModel(this.domModel);
        super.getSelectionModel().setSelectionMode(4);
        this.title = resource.getString("Dom.title");
    }

    public void setSVGModel(SVGModel model) {
        this.svgModel = model;
        if (this.svgModel != null) {
            int state = model.getState();
            SVGDocument data = state == -1 ? null : model.getSVGDocument();
            this.domModel.setData(data);
            super.setEnabled(state == 0);
        } else {
            this.domModel.setData(null);
            super.setEnabled(false);
        }
        super.revalidate();
        super.repaint();
    }

    public SVGModel getSVGModel() {
        return this.svgModel;
    }

    public String getTitle() {
        return this.title;
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DomNode node;
        String stringValue = null;
        stringValue = value instanceof DomNode ? ((node = (DomNode)value).getNode() != null ? SVGNodeUtilities.getName(node.getNode()) : node.toString()) : super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        return stringValue;
    }

    protected void processMouseEvent(MouseEvent evt) {
        if (this.isEnabled() && evt.getID() == 502) {
            TreePath oldPath = super.getSelectionPath();
            TreePath path = super.getPathForLocation(evt.getX(), evt.getY());
            if (path != null) {
                DomNode node = (DomNode)path.getLastPathComponent();
                if (node.isEnabled()) {
                    Node n = node.getNode();
                    NodeSelection ns = this.svgModel.getSelectedNodes();
                    if (evt.isControlDown()) {
                        if (!ns.contains(n)) {
                            NodeSelection newSelection = new NodeSelection(ns);
                            newSelection.add(n);
                            newSelection.sort(this);
                            this.svgModel.setSelectedNodes(newSelection);
                        } else {
                            NodeSelection newSelection = new NodeSelection(ns);
                            newSelection.remove(n);
                            this.svgModel.setSelectedNodes(newSelection);
                        }
                    } else {
                        NodeSelection newSelection = new NodeSelection(n);
                        this.svgModel.setSelectedNodes(newSelection);
                    }
                    super.revalidate();
                    super.repaint();
                } else {
                    super.clearSelection();
                    this.processSelection();
                }
            }
        }
        super.processMouseEvent(evt);
    }

    public void processSelection() {
        if (this.svgModel == null) {
            return;
        }
        NodeSelection ns = this.svgModel.getSelectedNodes();
        if (ns == null) {
            return;
        }
        ns.sort(this);
        TreePath path = null;
        super.clearSelection();
        int i = 0;
        while (i < ns.getLength()) {
            DomNode objNode = this.domModel.findNode(ns.item(i));
            if (objNode != null) {
                path = new TreePath(objNode.getPath());
                super.addSelectionPath(path);
                super.scrollPathToVisible(path);
            }
            ++i;
        }
    }

    public int compare(Object o1, Object o2) {
        try {
            Node n1 = (Node)o1;
            Node n2 = (Node)o2;
            DomNode dn1 = this.domModel.findNode(n1);
            DomNode dn2 = this.domModel.findNode(n2);
            TreePath path1 = new TreePath(dn1.getPath());
            TreePath path2 = new TreePath(dn2.getPath());
            int index1 = this.getRowForPath(path1);
            int index2 = this.getRowForPath(path2);
            return index1 - index2;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

