/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.canvas.tool;

import imhotep.editor.canvas.Canvas;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import javax.swing.event.MouseInputListener;
import org.apache.batik.svggen.SVGSyntax;

public abstract class AbstractTool
implements MouseInputListener,
SVGSyntax {
    protected Point2D pressPoint;
    protected Point2D dragPoint;
    protected Point2D releasePoint;
    protected Canvas svgCanvas;
    protected String name;
    protected static double VALIDATE_VALUE = 1.0;

    public AbstractTool(Canvas canvas) {
        this.svgCanvas = canvas;
    }

    public String getName() {
        return this.name;
    }

    public abstract void startTool();

    public abstract void endTool();

    public abstract void paint(Graphics2D var1);

    protected boolean isValidateShape(Shape s) {
        Rectangle2D r = s.getBounds2D();
        double w = r.getWidth();
        double h = r.getHeight();
        if (w == 0.0 && h == 0.0) {
            return false;
        }
        if (w == 0.0) {
            return h >= VALIDATE_VALUE;
        }
        if (h == 0.0) {
            return w >= VALIDATE_VALUE;
        }
        return w >= VALIDATE_VALUE && h >= VALIDATE_VALUE;
    }

    protected static Cursor createCurser(String url) {
        Cursor curser;
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension size = toolkit.getBestCursorSize(16, 16);
            if (size.getWidth() == 0.0 || size.getHeight() == 0.0) {
                throw new RuntimeException("doesn't support custom cursor");
            }
            URL u = ClassLoader.getSystemClassLoader().getResource(url);
            Image img = toolkit.getImage(u);
            curser = toolkit.createCustomCursor(img, new Point(11, 11), url);
        }
        catch (Exception e) {
            curser = Cursor.getPredefinedCursor(1);
        }
        return curser;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }
}

