/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.canvas.tool;

import imhotep.editor.canvas.Canvas;
import imhotep.editor.canvas.tool.AbstractTool;
import imhotep.model.SVGModel;
import imhotep.util.NodeSelection;
import imhotep.util.SVGGeomUtilities;
import imhotep.util.SVGRendererUtilities;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class LineTool
extends AbstractTool {
    private Line2D shape;

    public LineTool(Canvas canvas) {
        super(canvas);
    }

    public void startTool() {
    }

    public void endTool() {
    }

    public void paint(Graphics2D g2) {
        if (this.shape != null) {
            g2.draw(this.shape);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.pressPoint = e.getPoint();
        if (this.shape == null) {
            this.shape = new Line2D.Double();
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.dragPoint = e.getPoint();
        if (this.shape != null) {
            double x1 = this.pressPoint.getX();
            double y1 = this.pressPoint.getY();
            double x2 = this.dragPoint.getX();
            double y2 = this.dragPoint.getY();
            double tx = x2 - x1;
            double ty = y2 - y1;
            if (e.isShiftDown() && e.isControlDown()) {
                if (Math.abs(tx) > Math.abs(ty)) {
                    this.shape.setLine(x1 - tx, y1, x2, y1);
                } else {
                    this.shape.setLine(x1, y1 - ty, x1, y2);
                }
            } else if (e.isShiftDown()) {
                if (Math.abs(tx) > Math.abs(ty)) {
                    this.shape.setLine(x1, y1, x2, y1);
                } else {
                    this.shape.setLine(x1, y1, x1, y2);
                }
            } else if (e.isControlDown()) {
                this.shape.setLine(x1 - tx, y1 - ty, x2, y2);
            } else {
                this.shape.setLine(x1, y1, x2, y2);
            }
            this.svgCanvas.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.releasePoint = e.getPoint();
        if (this.shape != null && this.isValidateShape(this.shape)) {
            try {
                AffineTransform vt = this.svgCanvas.getViewBoxTransform().createInverse();
                PathIterator pi = this.shape.getPathIterator(vt);
                Line2D line = SVGGeomUtilities.convertLine2D(pi);
                SVGModel model = this.svgCanvas.getSVGModel();
                SVGDocument doc = model.getSVGDocument();
                Element ele = doc.createElementNS("http://www.w3.org/2000/svg", "line");
                ele.setAttributeNS(null, "x1", SVGGeomUtilities.doubleString(line.getX1()));
                ele.setAttributeNS(null, "y1", SVGGeomUtilities.doubleString(line.getY1()));
                ele.setAttributeNS(null, "x2", SVGGeomUtilities.doubleString(line.getX2()));
                ele.setAttributeNS(null, "y2", SVGGeomUtilities.doubleString(line.getY2()));
                ele.setAttributeNS(null, "style", SVGRendererUtilities.LINE_DEFAULT_STYLE);
                model.addEntities(new NodeSelection(ele));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.shape = null;
        this.svgCanvas.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        this.svgCanvas.setCursor(Cursor.getPredefinedCursor(1));
    }
}

