/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.canvas.tool;

import imhotep.editor.canvas.Canvas;
import imhotep.editor.canvas.tool.PolylineTool;
import imhotep.model.SVGModel;
import imhotep.util.NodeSelection;
import imhotep.util.SVGGeomUtilities;
import imhotep.util.SVGRendererUtilities;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class PolygonTool
extends PolylineTool {
    public PolygonTool(Canvas canvas) {
        super(canvas);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && this.shape != null && this.isValidateShape(this.shape)) {
            try {
                this.shape.closePath();
                AffineTransform vt = this.svgCanvas.getViewBoxTransform().createInverse();
                PathIterator pi = this.shape.getPathIterator(vt);
                SVGModel model = this.svgCanvas.getSVGModel();
                SVGDocument doc = model.getSVGDocument();
                Element ele = doc.createElementNS("http://www.w3.org/2000/svg", "polygon");
                ele.setAttributeNS(null, "points", SVGGeomUtilities.toSVGPoints(pi));
                ele.setAttributeNS(null, "style", SVGRendererUtilities.SHAPE_DEFAULT_STYLE);
                model.addEntities(new NodeSelection(ele));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.shape = null;
            this.svgCanvas.repaint();
        }
    }
}

