/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.canvas.tool;

import imhotep.editor.canvas.Canvas;
import imhotep.editor.canvas.tool.AbstractTool;
import imhotep.model.SVGModel;
import imhotep.util.NodeSelection;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class RotateTool
extends AbstractTool {
    private Rectangle2D anchor;
    private Shape outline;
    private Shape shape;
    private int mode;
    private static Cursor rotateCursor = AbstractTool.createCurser("imhotep/menu/resources/draw_rotate.gif");

    public RotateTool(Canvas canvas) {
        super(canvas);
    }

    public void startTool() {
        this.anchor = (Rectangle2D)this.svgCanvas.getHandleBounds(5).clone();
    }

    public void endTool() {
    }

    public void paint(Graphics2D g2) {
        int x = (int)this.anchor.getX();
        int y = (int)this.anchor.getY();
        int w = (int)this.anchor.getWidth();
        int h = (int)this.anchor.getHeight();
        g2.draw(new Line2D.Double(x, y, x + w, y + h));
        g2.draw(new Line2D.Double(x, y + h, x + w, y));
        if (this.shape != null) {
            g2.draw(this.shape);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.pressPoint = e.getPoint();
        this.mode = this.svgCanvas.getHandleNumber(this.pressPoint);
        if (this.mode == 0) {
            SVGModel m = this.svgCanvas.getSVGModel();
            AffineTransform t = this.svgCanvas.getRenderingTransform();
            this.outline = m.getSelectedOutline(t);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.dragPoint = e.getPoint();
        if (this.mode == 0) {
            double[] d = new double[]{this.anchor.getCenterX(), this.anchor.getCenterY(), this.dragPoint.getX(), this.dragPoint.getY()};
            double theta = Math.atan2(d[3] - d[1], d[2] - d[0]);
            AffineTransform at = new AffineTransform();
            at.rotate(theta, d[0], d[1]);
            this.shape = at.createTransformedShape(this.outline);
            this.svgCanvas.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.releasePoint = e.getPoint();
        if (this.dragPoint == null) {
            double ax = this.anchor.getCenterX();
            double ay = this.anchor.getCenterY();
            double nx = this.releasePoint.getX();
            double ny = this.releasePoint.getY();
            double tx = nx - ax;
            double ty = ny - ay;
            AffineTransform a = new AffineTransform();
            a.translate(tx, ty);
            this.anchor.setFrame(a.createTransformedShape(this.anchor).getBounds2D());
            this.svgCanvas.repaint();
            return;
        }
        if (this.mode == 0) {
            try {
                double[] d = new double[]{this.anchor.getCenterX(), this.anchor.getCenterY(), this.dragPoint.getX(), this.dragPoint.getY()};
                AffineTransform vt = this.svgCanvas.getViewBoxTransform().createInverse();
                vt.transform(d, 0, d, 0, 2);
                double theta = Math.atan2(d[3] - d[1], d[2] - d[0]);
                AffineTransform at = new AffineTransform();
                at.rotate(theta, d[0], d[1]);
                SVGModel m = this.svgCanvas.getSVGModel();
                NodeSelection ns = m.getSelectedNodes();
                m.transformEntities(ns, at);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        this.outline = null;
        this.shape = null;
        this.dragPoint = null;
        this.svgCanvas.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        Point movePoint = e.getPoint();
        int num = this.svgCanvas.getHandleNumber(movePoint);
        if (num == 0) {
            this.svgCanvas.setCursor(rotateCursor);
        } else {
            this.svgCanvas.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

