/*
 * Decompiled with CFR 0.152.
 */
package imhotep.editor.source;

import core.swing.NetBeansEditor;
import core.swing.undo.UndoRedoManager;
import imhotep.editor.source.SourceMessage;
import imhotep.model.SVGModel;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class Source
extends NetBeansEditor {
    private JComponent extComponent;
    private SourceMessage mssage = new SourceMessage();
    private JPopupMenu popup;
    private SVGModel model;
    private boolean dispose;
    private MouseListener mouseListener;
    private DocTextChangedInvoker docTextChangedInvoker = new DocTextChangedInvoker();
    private SelectedTextChangedInvoker selectedTextChangedInvoker = new SelectedTextChangedInvoker();
    private boolean sourceChangedFlag = false;
    private String oldSelectedText;

    public Source() {
        this.mouseListener = new MouseListenerImpl();
        super.addCaretListener(this.selectedTextChangedInvoker);
        super.setRequestFocusEnabled(false);
        super.setContentType("text/html");
        this.initExtComponent();
    }

    public void setSVGModel(SVGModel m) {
        this.model = m;
    }

    public SVGModel getSVGModel() {
        return this.model;
    }

    public void active() {
        try {
            if (this.model.isCanvasUndoManagerUpdated()) {
                this.model.updateTempFile();
            }
            BufferedReader r = new BufferedReader(new FileReader(this.model.getTempFile()));
            super.read(r, null);
            UndoRedoManager u = this.model.getSourceUndoManager();
            super.getDocument().addUndoableEditListener(u);
            super.getDocument().putProperty("undo-manager", u);
            super.getDocument().addDocumentListener(this.docTextChangedInvoker);
            this.sourceChangedFlag = false;
        }
        catch (Exception e) {
            super.setText(null);
            e.printStackTrace();
        }
        this.dispose = false;
    }

    public void dispose() {
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
        UndoRedoManager u = this.model.getSourceUndoManager();
        super.getDocument().removeUndoableEditListener(u);
        u.discardAllEdits();
        super.setText("");
        this.dispose = true;
    }

    public void refresh() {
    }

    public void setEnabled(boolean b) {
        System.out.println("setEnabled " + b);
        super.setEnabled(b);
    }

    protected void initExtComponent() {
        this.extComponent = new JPanel(new BorderLayout());
        this.extComponent.add("Center", super.getExtComponent());
    }

    public JComponent getExtComponent() {
        return this.extComponent;
    }

    public void initPopup(JPopupMenu b) {
        this.popup = b;
        super.addMouseListener(this.mouseListener);
    }

    public void setErrorMessage(String msg) {
        this.mssage.setText(msg);
        this.extComponent.add("North", this.mssage);
        this.extComponent.revalidate();
    }

    public void removeErrorMessage() {
        this.mssage.setText(null);
        this.extComponent.remove(this.mssage);
        this.extComponent.revalidate();
    }

    public boolean isShownErrorMessage() {
        return this.extComponent.getComponentCount() > 1;
    }

    public boolean isSourceChanged() {
        return this.sourceChangedFlag;
    }

    protected class DocTextChangedInvoker
    implements DocumentListener {
        protected DocTextChangedInvoker() {
        }

        private void markChanged(DocumentEvent evt) {
            Document doc = evt.getDocument();
            doc.putProperty("modified", Boolean.TRUE);
            doc.removeDocumentListener(this);
            Source.this.sourceChangedFlag = true;
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            this.markChanged(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.markChanged(e);
        }
    }

    protected class SelectedTextChangedInvoker
    implements CaretListener {
        protected SelectedTextChangedInvoker() {
        }

        public void caretUpdate(CaretEvent e) {
            String select = Source.this.getSelectedText();
            if (Source.this.oldSelectedText != null) {
                if (!Source.this.oldSelectedText.equals(select)) {
                    Source.this.model.setSelectedText(select);
                }
            } else if (select != null) {
                Source.this.model.setSelectedText(select);
            }
            Source.this.oldSelectedText = select;
        }
    }

    protected class MouseListenerImpl
    extends MouseAdapter {
        protected MouseListenerImpl() {
        }

        private void maybeShowPopup(MouseEvent e) {
            if (Source.this.popup == null) {
                return;
            }
            if (e.isPopupTrigger()) {
                Source.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }
    }
}

