/*
 * Decompiled with CFR 0.152.
 */
package imhotep.layer;

import core.swing.CommandManager;
import core.swing.ResourceManager;
import imhotep.editor.SVGEditorEvent;
import imhotep.editor.SVGPalette;
import imhotep.layer.LayerTable;
import imhotep.layer.LayerTool;
import imhotep.model.SVGModelEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class LayerPalette
extends SVGPalette {
    private static CommandManager commands = CommandManager.getSystemBundle();
    protected LayerTable layerTable;
    protected LayerTool layerTool;

    public LayerPalette(JFrame f) {
        super(f);
        super.setTitle(this.layerTable.getTitle());
    }

    protected JComponent createContentsComponent() {
        this.layerTable = new LayerTable();
        this.layerTool = new LayerTool(this.layerTable.getActionMap());
        JPanel contents = new JPanel(new BorderLayout());
        contents.add((Component)this.layerTool, "North");
        contents.add((Component)new JScrollPane(this.layerTable), "Center");
        return contents;
    }

    public ResourceManager resource() {
        return null;
    }

    public CommandManager commands() {
        return commands;
    }

    public void doCloseAction() {
        commands.getCommand("imhotep.menu.view.ViewLayer").actionPerformed(this);
    }

    public void editorAdded(SVGEditorEvent evt) {
        evt.getEditor().getSVGModel().addSVGModelListener(this);
    }

    public void editorRemoved(SVGEditorEvent evt) {
        evt.getEditor().getSVGModel().removeSVGModelListener(this);
        this.layerTable.setSVGModel(null);
    }

    public void stateChanged(SVGModelEvent evt) {
        this.layerTable.setSVGModel(evt.getSVGModel());
    }

    public void documentChanged(SVGModelEvent evt) {
        this.layerTable.setSVGModel(evt.getSVGModel());
    }

    public void layerChanged(SVGModelEvent evt) {
        this.layerTable.setSVGModel(evt.getSVGModel());
    }

    public void selectionChanged(SVGModelEvent evt) {
    }

    public void zoomChanged(SVGModelEvent evt) {
    }

    public void undoChanged(SVGModelEvent evt) {
        this.layerTable.setSVGModel(evt.getSVGModel());
    }
}

