/*
 * Decompiled with CFR 0.152.
 */
package imhotep.library;

import core.swing.CommandManager;
import core.swing.ResourceManager;
import imhotep.editor.SVGEditorEvent;
import imhotep.editor.SVGPalette;
import imhotep.library.LibraryPreview;
import imhotep.library.LibraryTool;
import imhotep.library.LibraryTree;
import imhotep.model.SVGModelEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class LibraryPalette
extends SVGPalette
implements PropertyChangeListener {
    private static CommandManager commands = CommandManager.getSystemBundle();
    protected LibraryPreview libPreview;
    protected LibraryTree libTree;
    protected LibraryTool libToolBar;

    public LibraryPalette(JFrame f) {
        super(f);
        super.setTitle(this.libTree.getTitle());
    }

    public ResourceManager resource() {
        return null;
    }

    public CommandManager commands() {
        return commands;
    }

    public void doCloseAction() {
        commands.getCommand("imhotep.menu.view.ViewLibrary").actionPerformed(this);
    }

    protected JComponent createContentsComponent() {
        this.libTree = new LibraryTree();
        this.libPreview = new LibraryPreview(this.libTree.getPreviewTitle());
        this.libToolBar = new LibraryTool(this.libTree.getActionMap());
        this.libTree.addPropertyChangeListener(this);
        JSplitPane split = new JSplitPane(1, new JScrollPane(this.libTree), (Component)((Object)this.libPreview));
        split.setDividerSize(1);
        split.setDividerLocation(100);
        JPanel contents = new JPanel(new BorderLayout());
        contents.add((Component)this.libToolBar, "North");
        contents.add((Component)split, "Center");
        return contents;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("leadSelectionPath".equals(evt.getPropertyName())) {
            File f = this.libTree.getSelectedFile();
            if (f.isFile()) {
                this.libPreview.setURI(f.toURI().toASCIIString());
            } else {
                this.libPreview.setURI(null);
            }
            super.firePalleteChange("leadSelectionPath", null, f);
        }
    }

    public void refresh(Object obj) {
        this.libTree.refresh();
    }

    public void editorAdded(SVGEditorEvent evt) {
        evt.getEditor().getSVGModel().addSVGModelListener(this);
    }

    public void editorRemoved(SVGEditorEvent evt) {
        evt.getEditor().getSVGModel().removeSVGModelListener(this);
    }

    public void stateChanged(SVGModelEvent evt) {
        this.libTree.setSVGModel(evt.getEnableCanvas() ? evt.getSVGModel() : null);
    }
}

