/*
 * Decompiled with CFR 0.152.
 */
package imhotep.menu.file;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import core.swing.JButtonGroup;
import core.swing.JFileTreeChooser;
import core.swing.JFormDialog;
import core.swing.JImagePane;
import core.swing.ResourceManager;
import core.swing.tree.filesystem.FileTree;
import imhotep.model.SVGModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.apache.batik.dom.util.XLinkSupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public class SaveAsWebDialog
extends JFormDialog
implements ListSelectionListener {
    protected static String RESOURCES = "imhotep.menu.file.resources.SaveAsWebDialog";
    protected static ResourceManager bundle = ResourceManager.getBundle(RESOURCES);
    private JTable table;
    private JImagePane preview;
    private JButton name;
    private JButton path;
    private JButton option;
    private Model tableModel;
    private Object[] columns;
    private Object[] options;

    protected JComponent createContentsPanel() {
        this.columns = new Object[]{bundle.getString("EmbededFileModel.path"), bundle.getString("EmbededFileModel.name"), bundle.getString("EmbededFileModel.option")};
        this.options = new Object[]{bundle.getString("EmbededFileModel.option.copy"), bundle.getString("EmbededFileModel.option.nocopy")};
        this.tableModel = new Model(this.columns, this.options[0]);
        this.table = new JTable(this.tableModel);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getSelectionModel().setSelectionMode(0);
        this.path = new JButton(bundle.getString("PathButton.text"));
        this.path.setEnabled(false);
        this.path.addActionListener(new ChangePathAction());
        this.name = new JButton(bundle.getString("NameButton.text"));
        this.name.setEnabled(false);
        this.name.addActionListener(new ChangeNameAction());
        this.option = new JButton(bundle.getString("OptionButton.text"));
        this.option.setEnabled(false);
        this.option.addActionListener(new ChangeOptionAction());
        this.preview = new JImagePane();
        JPanel previewPane = new JPanel(new BorderLayout());
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        TitledBorder titled = BorderFactory.createTitledBorder(loweredetched, "preview");
        previewPane.setBorder(titled);
        previewPane.add((Component)this.preview, "Center");
        JScrollPane tablePane = new JScrollPane(this.table);
        FormLayout layout = new FormLayout("100px, 4dlu, 100px, 4dlu , 100px, 4dlu , 200px", "100px, 4dlu ,100px, 4dlu, p");
        JPanel contents = new JPanel((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        contents.add((Component)tablePane, cc.xywh(1, 1, 5, 3));
        contents.add((Component)previewPane, cc.xywh(7, 1, 1, 3));
        contents.add((Component)this.path, cc.xy(1, 5));
        contents.add((Component)this.name, cc.xy(3, 5));
        contents.add((Component)this.option, cc.xy(5, 5));
        return contents;
    }

    protected void initializeContents() {
        String title = bundle.getString("Dialog.title");
        super.setDialogTitle(title);
    }

    protected void prepareContents() {
    }

    public int initializeContents(SVGDocument doc, File root) {
        this.tableModel.setSVGDocument(doc);
        this.tableModel.setRootPath(root);
        return this.tableModel.getRowCount();
    }

    public void valueChanged(ListSelectionEvent e) {
        int row = this.table.getSelectedRow();
        if (row > -1) {
            this.name.setEnabled(true);
            this.path.setEnabled(true);
            this.option.setEnabled(true);
            try {
                File href = this.tableModel.getFileAt(row);
                this.preview.setURL(href.toURL());
            }
            catch (Exception e1) {
                this.preview.setURL(null);
            }
        }
    }

    public Model getEmbededFileModel() {
        return this.tableModel;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.pack();
        f.show();
        JFileTreeChooser c = new JFileTreeChooser();
        c.setFileSelectionMode(0);
        c.showOpenDialog(f);
        File newSVG = c.getSelectedFile();
        SVGModel model = new SVGModel(newSVG.getName());
        model.open(newSVG);
        SaveAsWebDialog d = new SaveAsWebDialog();
        d.initializeContents(model.getSVGDocument(), newSVG.getParentFile());
        d.showDialog(f);
    }

    public class ChangePathAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int row = SaveAsWebDialog.this.table.getSelectedRow();
            File root = SaveAsWebDialog.this.tableModel.getRootPath();
            FileTree tree = new FileTree(root);
            JScrollPane treePane = new JScrollPane(tree);
            treePane.setPreferredSize(new Dimension(300, 200));
            String title = SaveAsWebDialog.this.path.getText();
            int i = JOptionPane.showConfirmDialog(SaveAsWebDialog.this, treePane, title, 2, 3);
            if (i == 0) {
                URI p = tree.getSelectedFile().toURI();
                URI c = root.toURI();
                URI u = c.relativize(p);
                String nValue = URLDecoder.decode(u.toString());
                SaveAsWebDialog.this.tableModel.setValueAt(nValue, row, 0);
            }
        }
    }

    public class ChangeNameAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            String oldName;
            int row = SaveAsWebDialog.this.table.getSelectedRow();
            String title = SaveAsWebDialog.this.name.getText();
            String newName = (String)JOptionPane.showInputDialog(SaveAsWebDialog.this, null, title, 3, null, null, oldName = (String)SaveAsWebDialog.this.tableModel.getValueAt(row, 1));
            if (newName != null && !oldName.equals(newName)) {
                SaveAsWebDialog.this.tableModel.setValueAt(newName, row, 1);
            }
        }
    }

    public class ChangeOptionAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int row = SaveAsWebDialog.this.table.getSelectedRow();
            String title = SaveAsWebDialog.this.option.getText();
            Object oldValue = SaveAsWebDialog.this.tableModel.getValueAt(row, 2);
            JButtonGroup optionGroup = new JButtonGroup(SaveAsWebDialog.this.options);
            optionGroup.setSelectedItem(oldValue);
            int i = JOptionPane.showConfirmDialog(SaveAsWebDialog.this, optionGroup.getAllElements(), title, 2, 3);
            if (i == 0) {
                Object nValue = optionGroup.getSelectedItem();
                SaveAsWebDialog.this.tableModel.setValueAt(nValue, row, 2);
            }
        }
    }

    public class Model
    extends DefaultTableModel {
        private File root;
        private Vector elements;
        private Object defaultValue;

        public Model(Object[] columns, Object defaultValue) {
            super.setColumnIdentifiers(columns);
            this.defaultValue = defaultValue;
            this.elements = new Vector();
        }

        public void setRootPath(File root) {
            this.root = root;
        }

        public File getRootPath() {
            return this.root;
        }

        public void setDefaultValue(File defaultValue) {
            this.defaultValue = defaultValue;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public void setSVGDocument(SVGDocument doc) {
            this.elements.clear();
            this.appendFile((Element)doc.getRootElement());
            super.setRowCount(this.elements.size());
            super.setColumnCount(3);
            Iterator it = ((AbstractList)this.elements).iterator();
            Element ele = null;
            String href = null;
            File file = null;
            int row = 0;
            while (it.hasNext()) {
                ele = (Element)it.next();
                href = XLinkSupport.getXLinkHref((Element)ele);
                file = new File(href);
                super.setValueAt("", row, 0);
                super.setValueAt(file.getName(), row, 1);
                super.setValueAt(this.defaultValue, row, 2);
                ++row;
            }
            super.fireTableDataChanged();
        }

        private void appendFile(Element ele) {
            String tag = ele.getTagName();
            String href = XLinkSupport.getXLinkHref((Element)ele);
            if (tag.equalsIgnoreCase("image") && href != null && href.startsWith("file:")) {
                this.elements.add(ele);
            }
            Node n = ele.getFirstChild();
            while (n != null) {
                if (n instanceof Element) {
                    this.appendFile((Element)n);
                }
                n = n.getNextSibling();
            }
        }

        public boolean isCellEditable(int r, int c) {
            return false;
        }

        public String getPathAt(int i) {
            return (String)this.getValueAt(i, 0);
        }

        public String getNameAt(int i) {
            return (String)this.getValueAt(i, 1);
        }

        public String getOptionAt(int i) {
            return (String)this.getValueAt(i, 2);
        }

        public Element getElementAt(int rowIndex) {
            return (Element)this.elements.get(rowIndex);
        }

        public File getFileAt(int rowIndex) throws URISyntaxException {
            return new File(new URI(this.getHrefAt(rowIndex)));
        }

        public String getHrefAt(int row) {
            Element ele = this.getElementAt(row);
            String href = XLinkSupport.getXLinkHref((Element)ele);
            return href;
        }
    }
}

