/*
 * Decompiled with CFR 0.152.
 */
package imhotep.model;

import core.swing.undo.UndoRedoManager;
import core.xml.DOMBuilderException;
import imhotep.model.SVGModelListener;
import imhotep.model.SVGModelSupport;
import imhotep.model.undo.DocumentChangeUndo;
import imhotep.model.undo.GroupAddUndo;
import imhotep.model.undo.GroupRemoveUndo;
import imhotep.model.undo.LayerAddUndo;
import imhotep.model.undo.LayerArrangeUndo;
import imhotep.model.undo.LayerAttributeUndo;
import imhotep.model.undo.LayerRemoveUndo;
import imhotep.model.undo.LayerStyleUndo;
import imhotep.model.undo.NodeAddUndo;
import imhotep.model.undo.NodeArrangeUndo;
import imhotep.model.undo.NodeAttributeUndo;
import imhotep.model.undo.NodeRemoveUndo;
import imhotep.model.undo.NodeReplaceUndo;
import imhotep.model.undo.NodeStyleUndo;
import imhotep.model.undo.NodeTransformUndo;
import imhotep.util.FileFilter;
import imhotep.util.NodeSelection;
import imhotep.util.SVGBuilderWrapper;
import imhotep.util.SVGLayerUtilities;
import imhotep.util.SVGNodeUtilities;
import imhotep.util.SVGWriterWrapper;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.DynamicGVTBuilder;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLineElement;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGModel
implements UndoableEditListener {
    public static final double DEFAULT_ZOOM_VALUE = 1.0;
    public static final double MIN_ZOOM_VALUE = 0.1;
    public static final double MAX_ZOOM_VALUE = 4.0;
    public static final int DESTORY = -1;
    public static final int CANVAS = 0;
    public static final int SOURCE = 1;
    public static final int PREVIEW = 2;
    public static final int ARRANGE_TO_TOP = 100;
    public static final int ARRANGE_MOVE_UP = 1;
    public static final int ARRANGE_MOVE_DOWN = -1;
    public static final int ARRANGE_TO_BOTTOM = -100;
    private SVGModelSupport support;
    private SVGOMDocument svgDocument;
    private GraphicsNode root;
    private BridgeContext bridgeContext;
    private DocumentLoader documentLoader;
    private UserAgent userAgent;
    private GVTBuilder gvtBuilder;
    private double zoom = 1.0;
    private int state;
    private double scale;
    private int unit;
    private String name;
    private boolean isClosed;
    private boolean isSaved;
    private File saveFile;
    private File tempFile;
    private SVGSVGElement selectedLayer;
    private NodeSelection selectedNodes;
    private String selectedText;
    private String canvasUndoManagerText;
    private UndoRedoManager canvasUndoManager;
    private UndoRedoManager sourceUndoManager;
    private static int untitledIndex;

    public static int getUntitledIndex() {
        return ++untitledIndex;
    }

    public SVGModel(String name) {
        this.name = name;
        this.support = new SVGModelSupport(this);
        this.selectedNodes = new NodeSelection();
        this.canvasUndoManager = new UndoRedoManager();
        this.sourceUndoManager = new UndoRedoManager();
        this.canvasUndoManager.addUndoableEditListener(this);
        this.sourceUndoManager.addUndoableEditListener(this);
    }

    public void addSVGModelListener(SVGModelListener l) {
        this.support.addSVGModelListener(l);
    }

    public void removeSVGModelListener(SVGModelListener l) {
        this.support.removeSVGModelListener(l);
    }

    public void setSVGDocument(SVGDocument doc) {
        this.clearSVGDocument();
        this.svgDocument = (SVGOMDocument)doc;
        this.userAgent = new UserAgentAdapter();
        this.documentLoader = new DocumentLoader(this.userAgent);
        this.bridgeContext = new BridgeContext(this.userAgent, this.documentLoader);
        this.bridgeContext.setDynamic(true);
        this.gvtBuilder = new DynamicGVTBuilder();
        this.root = this.gvtBuilder.build(this.bridgeContext, (Document)this.svgDocument);
        this.support.fireDocumentChanged();
    }

    public SVGDocument getSVGDocument() {
        return this.svgDocument;
    }

    private void clearSVGDocument() {
        if (this.bridgeContext != null) {
            this.bridgeContext.dispose();
        }
        if (this.documentLoader != null) {
            this.documentLoader.dispose();
        }
        this.bridgeContext = null;
        this.documentLoader = null;
        this.userAgent = null;
        this.gvtBuilder = null;
        this.root = null;
    }

    public SVGDocument exportDocument(NodeSelection nodes) throws DOMBuilderException {
        String w = this.svgDocument.getRootElement().getAttribute("width");
        String h = this.svgDocument.getRootElement().getAttribute("height");
        SVGDocument transDocument = SVGBuilderWrapper.create();
        transDocument.getDocumentElement().setAttribute("width", w);
        transDocument.getDocumentElement().setAttribute("height", h);
        transDocument.getDocumentElement().setAttribute("viewBox", "0 0 " + w + " " + h);
        Node orgNode = null;
        Node transNode = null;
        int i = 0;
        while (i < nodes.getLength()) {
            orgNode = nodes.item(i);
            if (SVGNodeUtilities.isValidateNode(orgNode)) {
                transNode = transDocument.importNode(orgNode, true);
                transDocument.getDocumentElement().appendChild(transNode);
            }
            ++i;
        }
        return transDocument;
    }

    public NodeSelection importDocument(SVGDocument importDoc) {
        Element transRoot = importDoc.getDocumentElement();
        NodeSelection nodeList = new NodeSelection();
        Node node = null;
        Node n = transRoot.getFirstChild();
        while (n != null) {
            if (SVGNodeUtilities.isValidateNode(n)) {
                node = this.svgDocument.importNode(n, true);
                nodeList.add(node);
            }
            n = n.getNextSibling();
        }
        return nodeList;
    }

    public SVGSVGElement getRootElement() {
        return this.svgDocument.getRootElement();
    }

    public String getSVGNameSpace() {
        return "http://www.w3.org/2000/svg";
    }

    public SVGElement convertSVGElement(GraphicsNode graphicsnode) {
        return (SVGElement)this.bridgeContext.getElement(graphicsnode);
    }

    public GraphicsNode convertGraphicsNode(SVGElement svgelement) {
        return this.bridgeContext.getGraphicsNode((Element)svgelement);
    }

    public GraphicsNode getRoot() {
        return this.root;
    }

    public Dimension2D getSVGZoomSize() {
        Dimension2D org = this.getSVGSize();
        Dimension d = new Dimension();
        double w = org.getWidth() * this.zoom;
        double h = org.getHeight() * this.zoom;
        d.setSize(w, h);
        return d;
    }

    public Dimension2D getSVGSize() {
        return this.bridgeContext.getDocumentSize();
    }

    public double getSVGWidth() {
        return this.getSVGSize().getWidth();
    }

    public double getSVGHeight() {
        return this.getSVGSize().getHeight();
    }

    public SVGSVGElement getSelectedLayer() {
        return this.selectedLayer;
    }

    public void setSelectedLayer(SVGSVGElement layer) {
        this.selectedLayer = layer;
        this.support.fireLayerChanged();
    }

    public NodeSelection getSelectedNodes() {
        return this.selectedNodes;
    }

    public void setSelectedNodes(NodeSelection nodes) {
        this.selectedNodes = nodes;
        this.support.fireSelectionChanged();
    }

    public void setSelectedText(String txt) {
        this.selectedText = txt;
        this.support.fireSelectionChanged();
    }

    public String getSelectedText() {
        return this.selectedText;
    }

    public boolean isCanvasUndoManagerUpdated() {
        String newText = this.canvasUndoManager.toString();
        boolean isChanged = !newText.equals(this.canvasUndoManagerText);
        this.canvasUndoManagerText = newText;
        return isChanged;
    }

    public UndoRedoManager getCanvasUndoManager() {
        return this.canvasUndoManager;
    }

    public UndoRedoManager getSourceUndoManager() {
        return this.sourceUndoManager;
    }

    public void undoableEditHappened(UndoableEditEvent evt) {
        this.isSaved = false;
        this.support.fireUndoChanged();
    }

    public void setZoomValue(double zoom) {
        this.zoom = zoom;
        this.support.fireZoomChanged();
    }

    public double getZoomValue() {
        return this.zoom;
    }

    public void setState(int state) {
        this.state = state;
        this.support.fireStateChanged();
    }

    public int getState() {
        return this.state;
    }

    public void setScaleValue(double scale) {
        this.scale = scale;
    }

    public double getScaleValue() {
        return this.scale;
    }

    public void setUnitValue(int unit) {
        this.unit = unit;
    }

    public int getUnitValue() {
        return this.unit;
    }

    public void setURLObject(URL url) {
        this.svgDocument.setURLObject(url);
    }

    public URL getURLObject() {
        return this.svgDocument.getURLObject();
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        if (this.name != null) {
            StringBuffer b = new StringBuffer();
            b.append(this.name);
            b.append(" [");
            b.append(new Double(this.zoom * 100.0).intValue());
            b.append("%]");
            return b.toString();
        }
        return "";
    }

    public void updateTempFile() throws IOException {
        SVGWriterWrapper.write((Node)this.svgDocument, this.tempFile);
        System.out.println("### Update Temp File.....");
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    public void open(String w, String h) throws IOException {
        this.tempFile = FileFilter.createTempFile(new File("."));
        this.saveFile = null;
        this.isClosed = false;
        this.isSaved = false;
        SVGOMDocument newDoc = (SVGOMDocument)SVGBuilderWrapper.create(w, h);
        this.setSVGDocument((SVGDocument)newDoc);
        this.setSelectedLayer(newDoc.getRootElement());
        this.setSelectedNodes(new NodeSelection());
        SVGWriterWrapper.write((Node)newDoc, this.tempFile);
        newDoc.setURLObject(this.tempFile.toURL());
    }

    public void open(File f) throws IOException {
        this.name = f.getName();
        this.tempFile = FileFilter.createTempFile(f.getParentFile());
        this.saveFile = f;
        this.isClosed = false;
        this.isSaved = true;
        SVGOMDocument newDoc = (SVGOMDocument)SVGBuilderWrapper.parse(f);
        this.setSVGDocument((SVGDocument)newDoc);
        this.setSelectedLayer(newDoc.getRootElement());
        this.setSelectedNodes(new NodeSelection());
        SVGWriterWrapper.write((Node)newDoc, this.tempFile);
        newDoc.setURLObject(this.tempFile.toURL());
    }

    public void openAs(File temp) throws IOException {
        this.tempFile = temp;
        this.saveFile = null;
        this.isClosed = false;
        this.isSaved = false;
        SVGOMDocument newDoc = (SVGOMDocument)SVGBuilderWrapper.parse(temp);
        this.setSVGDocument((SVGDocument)newDoc);
        this.setSelectedLayer(newDoc.getRootElement());
        this.setSelectedNodes(new NodeSelection());
        newDoc.setURLObject(this.tempFile.toURL());
    }

    public void save() throws IOException {
        SVGWriterWrapper.write((Node)this.svgDocument, this.saveFile);
        this.isSaved = true;
    }

    public void saveAs(File f) throws IOException {
        this.name = f.getName();
        this.saveFile = f;
        this.isClosed = false;
        this.isSaved = true;
        SVGWriterWrapper.write((Node)this.svgDocument, f);
        this.setURLObject(f.toURL());
        this.support.fireDocumentChanged();
    }

    public void close() {
        try {
            try {
                this.clearSVGDocument();
                this.tempFile.delete();
                this.canvasUndoManager.clear();
                this.sourceUndoManager.clear();
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.svgDocument = null;
            this.bridgeContext = null;
            this.documentLoader = null;
            this.userAgent = null;
            this.gvtBuilder = null;
            this.root = null;
            this.selectedNodes = null;
            this.selectedLayer = null;
            this.selectedText = null;
            this.canvasUndoManager = null;
            this.sourceUndoManager = null;
            this.isClosed = true;
            throw throwable;
        }
        Object var2_4 = null;
        this.svgDocument = null;
        this.bridgeContext = null;
        this.documentLoader = null;
        this.userAgent = null;
        this.gvtBuilder = null;
        this.root = null;
        this.selectedNodes = null;
        this.selectedLayer = null;
        this.selectedText = null;
        this.canvasUndoManager = null;
        this.sourceUndoManager = null;
        this.isClosed = true;
    }

    public Shape getSelectedOutline(AffineTransform ct) {
        GeneralPath path = new GeneralPath();
        if (this.selectedNodes == null || this.selectedNodes.getLength() == 0) {
            return path;
        }
        Shape shape = null;
        int i = 0;
        while (i < this.selectedNodes.getLength()) {
            try {
                Shape gnOutLine;
                SVGElement e = (SVGElement)this.selectedNodes.item(i);
                GraphicsNode gn = this.convertGraphicsNode(e);
                if (gn != null && (gnOutLine = gn.getOutline()) != null) {
                    AffineTransform t = new AffineTransform(ct);
                    AffineTransform gt = gn.getGlobalTransform();
                    if (gt != null) {
                        t.concatenate(gt);
                    }
                    shape = t.createTransformedShape(gnOutLine);
                    path.append(shape, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println(this.selectedNodes.item(i) + " is not SVGElement");
            }
            ++i;
        }
        return path;
    }

    public NodeSelection getNodesAt(AffineTransform ct) {
        NodeSelection selectionTemp = new NodeSelection();
        if (this.svgDocument == null) {
            return selectionTemp;
        }
        SVGSVGElement root = this.svgDocument.getRootElement();
        this.searchAllNode((Node)root, selectionTemp);
        return selectionTemp;
    }

    public NodeSelection getNodesAt(AffineTransform ct, Rectangle2D area) {
        NodeSelection selectionTemp = new NodeSelection();
        if (this.svgDocument == null) {
            return selectionTemp;
        }
        SVGSVGElement root = this.svgDocument.getRootElement();
        this.searchContainsNode(ct, area, (Node)root, selectionTemp);
        return selectionTemp;
    }

    public NodeSelection getNodesAt(AffineTransform ct, Point2D p) {
        NodeSelection selectionTemp = new NodeSelection();
        if (this.svgDocument == null) {
            return selectionTemp;
        }
        Rectangle2D.Double canvasBound = new Rectangle2D.Double();
        canvasBound.setFrameFromCenter(p.getX(), p.getY(), p.getX() + 2.0, p.getY() + 2.0);
        SVGSVGElement root = this.svgDocument.getRootElement();
        this.searchIntersectsNode(ct, canvasBound, (Node)root, selectionTemp);
        return selectionTemp;
    }

    private void searchAllNode(Node p, NodeSelection v) {
        Node c = p.getLastChild();
        while (c != null) {
            if (SVGLayerUtilities.isLayer(c)) {
                this.searchAllNode(c, v);
            } else {
                v.add(0, c);
            }
            c = c.getPreviousSibling();
        }
    }

    private void searchContainsNode(AffineTransform ct, Rectangle2D area, Node p, NodeSelection v) {
        Node c = p.getLastChild();
        while (c != null) {
            if (SVGLayerUtilities.isLayer(c)) {
                if (!SVGLayerUtilities.getLayerLock(c)) {
                    this.searchContainsNode(ct, area, c, v);
                }
            } else if (this.contains(ct, area, c)) {
                v.add(0, c);
            }
            c = c.getPreviousSibling();
        }
    }

    private boolean contains(AffineTransform ct, Rectangle2D area, Node n) {
        if (n instanceof SVGLocatable) {
            Shape gnCanvasOutLine;
            Rectangle2D r;
            SVGElement ele = (SVGElement)n;
            if (ele == null) {
                return false;
            }
            GraphicsNode gn = this.bridgeContext.getGraphicsNode((Element)ele);
            if (gn == null) {
                return false;
            }
            Shape gnOutLine = gn.getOutline();
            if (gnOutLine == null) {
                return false;
            }
            AffineTransform t = new AffineTransform(ct);
            AffineTransform gt = gn.getGlobalTransform();
            if (gt != null) {
                t.concatenate(gt);
            }
            if ((r = (gnCanvasOutLine = t.createTransformedShape(gnOutLine)).getBounds2D()).getWidth() == 0.0) {
                r.setRect(r.getX(), r.getY(), 1.0, r.getHeight());
            }
            if (r.getHeight() == 0.0) {
                r.setRect(r.getX(), r.getY(), r.getWidth(), 1.0);
            }
            if (area.contains(r)) {
                if (n instanceof SVGLineElement) {
                    System.out.println("5");
                }
                return true;
            }
        }
        return false;
    }

    private void searchIntersectsNode(AffineTransform ct, Rectangle2D canvasBound, Node p, NodeSelection v) {
        if (v.getLength() > 0) {
            return;
        }
        Node c = p.getLastChild();
        while (c != null) {
            if (SVGLayerUtilities.isLayer(c)) {
                if (!SVGLayerUtilities.getLayerLock(c)) {
                    this.searchIntersectsNode(ct, canvasBound, c, v);
                }
            } else if (this.intersects(ct, canvasBound, c)) {
                v.add(0, c);
                break;
            }
            c = c.getPreviousSibling();
        }
    }

    private boolean intersects(AffineTransform ct, Rectangle2D area, Node n) {
        if (n instanceof SVGLocatable) {
            Shape gnCanvasOutLine;
            SVGElement ele = (SVGElement)n;
            if (ele == null) {
                return false;
            }
            if (this.bridgeContext == null) {
                return false;
            }
            GraphicsNode gn = this.bridgeContext.getGraphicsNode((Element)ele);
            if (gn == null) {
                return false;
            }
            Shape gnOutLine = gn.getOutline();
            if (gnOutLine == null) {
                return false;
            }
            AffineTransform t = new AffineTransform(ct);
            AffineTransform gt = gn.getGlobalTransform();
            if (gt != null) {
                t.concatenate(gt);
            }
            if ((gnCanvasOutLine = t.createTransformedShape(gnOutLine)).intersects(area)) {
                return true;
            }
        }
        return false;
    }

    public void changeDocument(SVGDocument ns) {
        this.canvasUndoManager.postEdit(new DocumentChangeUndo(this, ns));
    }

    public void addLayer(SVGSVGElement layer) {
        this.canvasUndoManager.postEdit(new LayerAddUndo(this, layer));
    }

    public void removeLayer(SVGSVGElement layer) {
        this.canvasUndoManager.postEdit(new LayerRemoveUndo(this, layer));
    }

    public void arrangeLayer(SVGSVGElement layer, int type) {
        this.canvasUndoManager.postEdit(new LayerArrangeUndo(this, layer, type));
    }

    public void attributeLayer(SVGSVGElement layer, String key, String value) {
        this.canvasUndoManager.postEdit(new LayerAttributeUndo(this, layer, key, value));
    }

    public void styleLayer(SVGSVGElement layer, String key, String value) {
        this.canvasUndoManager.postEdit(new LayerStyleUndo(this, layer, key, value));
    }

    public void addGroup(Element g, NodeSelection nodes) {
        this.canvasUndoManager.postEdit(new GroupAddUndo(this, g, nodes));
    }

    public void removeGroup(Element g) {
        this.canvasUndoManager.postEdit(new GroupRemoveUndo(this, g));
    }

    public void addEntities(NodeSelection nodes) {
        this.canvasUndoManager.postEdit(new NodeAddUndo(this, nodes));
    }

    public void removeEntities(NodeSelection nodes) {
        this.canvasUndoManager.postEdit(new NodeRemoveUndo(this, nodes));
    }

    public void arrangeEntities(NodeSelection nodes, int type) {
        this.canvasUndoManager.postEdit(new NodeArrangeUndo(this, nodes, type));
    }

    public void replaceEntities(NodeSelection nodes, NodeSelection newNodes) {
        this.canvasUndoManager.postEdit(new NodeReplaceUndo(this, nodes, newNodes));
    }

    public void attributeEntities(NodeSelection nodes, String key, String value) {
        this.canvasUndoManager.postEdit(new NodeAttributeUndo(this, nodes, key, value));
    }

    public void styleEntities(NodeSelection nodes, String key, String value) {
        this.canvasUndoManager.postEdit(new NodeStyleUndo(this, nodes, key, value));
    }

    public void transformEntities(NodeSelection nodes, AffineTransform at) {
        this.canvasUndoManager.postEdit(new NodeTransformUndo(this, nodes, at));
    }
}

