/*
 * Decompiled with CFR 0.152.
 */
package imhotep.model.undo;

import imhotep.model.SVGModel;
import imhotep.model.undo.SVGUndoableEdit;
import imhotep.util.NodeSelection;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GroupRemoveUndo
extends SVGUndoableEdit {
    protected NodeSelection target;
    protected NodeSelection parent;
    protected NodeSelection refenence;
    protected Element group;

    public GroupRemoveUndo(SVGModel model, Element g) {
        super(model);
        this.group = g;
        this.target = new NodeSelection(this.group.getChildNodes());
        this.parent = new NodeSelection(this.group.getParentNode());
        this.refenence = new NodeSelection(this.group.getNextSibling());
        this.redo();
    }

    public void redo() throws CannotRedoException {
        Object r = null;
        int i = 0;
        while (i < this.target.getLength()) {
            Node t = this.target.item(i);
            Node p = this.parent.item(0);
            p.insertBefore(t, this.group);
            if (i == this.target.getLength() - 1) {
                p.removeChild(this.group);
            }
            ++i;
        }
        this.svgModel.setSelectedNodes(this.target);
    }

    public void undo() throws CannotUndoException {
        Node r = null;
        int i = 0;
        while (i < this.target.getLength()) {
            Node t = this.target.item(i);
            Node p = this.parent.item(0);
            r = this.refenence.item(0);
            if (i == 0) {
                if (r != null) {
                    p.insertBefore(this.group, r);
                } else {
                    p.appendChild(this.group);
                }
            }
            this.group.appendChild(t);
            ++i;
        }
        this.svgModel.setSelectedNodes(new NodeSelection(this.group));
    }
}

