/*
 * Decompiled with CFR 0.152.
 */
package imhotep.model.undo;

import imhotep.model.SVGModel;
import imhotep.model.undo.SVGUndoableEdit;
import imhotep.util.NodeSelection;
import imhotep.util.SVGAttributeSupport;
import javax.swing.undo.CannotRedoException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGSVGElement;

public class LayerAttributeUndo
extends SVGUndoableEdit {
    protected SVGSVGElement target;
    protected String key;
    protected String newValue;
    protected String oldValue;

    public LayerAttributeUndo(SVGModel svgModel, SVGSVGElement layer, String key, String value) {
        super(svgModel);
        this.target = layer;
        this.key = key;
        this.newValue = value;
        this.oldValue = SVGAttributeSupport.getAttribute((Element)layer, key);
        this.redo();
    }

    public void redo() throws CannotRedoException {
        if ("".equals(this.newValue)) {
            SVGAttributeSupport.removeAttribute((Element)this.target, this.key);
        } else {
            SVGAttributeSupport.setAttribute((Element)this.target, this.key, this.newValue);
        }
        this.svgModel.setSelectedNodes(new NodeSelection());
    }

    public void undo() throws CannotRedoException {
        if ("".equals(this.oldValue)) {
            SVGAttributeSupport.removeAttribute((Element)this.target, this.key);
        } else {
            SVGAttributeSupport.setAttribute((Element)this.target, this.key, this.oldValue);
        }
        this.svgModel.setSelectedNodes(new NodeSelection());
    }
}

