/*
 * Decompiled with CFR 0.152.
 */
package imhotep.model.undo;

import imhotep.model.SVGModel;
import imhotep.model.undo.SVGUndoableEdit;
import imhotep.util.NodeSelection;
import imhotep.util.SVGAttributeSupport;
import javax.swing.undo.CannotRedoException;
import org.w3c.dom.Node;

public class NodeAttributeUndo
extends SVGUndoableEdit {
    protected NodeSelection target;
    protected String key;
    protected String newValue;
    protected String[] oldValue;

    public NodeAttributeUndo(SVGModel svgModel, NodeSelection nodes, String key, String value) {
        super(svgModel);
        this.target = nodes;
        this.key = key;
        this.newValue = value;
        this.oldValue = new String[nodes.getLength()];
        int i = 0;
        while (i < nodes.getLength()) {
            this.oldValue[i] = SVGAttributeSupport.getAttribute(nodes.item(i), key);
            ++i;
        }
        this.redo();
    }

    public void redo() throws CannotRedoException {
        Node t = null;
        int i = 0;
        while (i < this.target.getLength()) {
            t = this.target.item(i);
            if ("".equals(this.newValue)) {
                SVGAttributeSupport.removeAttribute(t, this.key);
            } else {
                SVGAttributeSupport.setAttribute(t, this.key, this.newValue);
            }
            ++i;
        }
        this.svgModel.setSelectedNodes(this.target);
    }

    public void undo() throws CannotRedoException {
        Node t = null;
        int i = 0;
        while (i < this.target.getLength()) {
            t = this.target.item(i);
            if ("".equals(this.oldValue[i])) {
                SVGAttributeSupport.removeAttribute(t, this.key);
            } else {
                SVGAttributeSupport.setAttribute(t, this.key, this.oldValue[i]);
            }
            ++i;
        }
        this.svgModel.setSelectedNodes(this.target);
    }
}

