/*
 * Decompiled with CFR 0.152.
 */
package imhotep.model.undo;

import imhotep.model.SVGModel;
import imhotep.model.undo.SVGUndoableEdit;
import imhotep.util.NodeSelection;
import imhotep.util.SVGTransformSupport;
import java.awt.geom.AffineTransform;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.w3c.dom.Node;

public class NodeTransformUndo
extends SVGUndoableEdit {
    protected NodeSelection target;
    protected AffineTransform transform;

    public NodeTransformUndo(SVGModel model, NodeSelection nodes, AffineTransform transform) {
        super(model);
        this.target = nodes;
        this.transform = transform;
        this.redo();
    }

    public void redo() throws CannotRedoException {
        Node t = null;
        int i = 0;
        while (i < this.target.getLength()) {
            t = this.target.item(i);
            SVGTransformSupport.setTransform(t, this.transform);
            ++i;
        }
        this.svgModel.setSelectedNodes(this.target);
    }

    public void undo() throws CannotUndoException {
        Node t = null;
        int i = 0;
        while (i < this.target.getLength()) {
            t = this.target.item(i);
            SVGTransformSupport.removeTransform(t, this.transform);
            ++i;
        }
        this.svgModel.setSelectedNodes(this.target);
    }
}

