/*
 * Decompiled with CFR 0.152.
 */
package imhotep.properties.style;

import core.swing.CommandManager;
import core.swing.table.TableCellButtonEditor;
import imhotep.model.SVGModel;
import imhotep.properties.style.StyleModel;
import imhotep.util.NodeSelection;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGElement;

public class StyleTable
extends JTable {
    private static CommandManager commands = CommandManager.getSystemBundle();
    private SVGModel svgModel;
    private StyleModel styleModel = new StyleModel();

    public StyleTable() {
        super.setModel(this.styleModel);
        super.getColumnModel().getColumn(1).setCellEditor(new ValueEditor());
        super.setSelectionMode(0);
        super.setRowHeight(20);
    }

    public void setSVGModel(SVGModel model) {
        this.svgModel = model;
        this.styleModel.setData(null);
        super.setEnabled(false);
        if (this.svgModel != null) {
            Node n;
            int state = this.svgModel.getState();
            NodeSelection ns = this.svgModel.getSelectedNodes();
            int size = ns.getLength();
            if (size > 0 && (n = ns.item(size - 1)) instanceof SVGElement) {
                this.styleModel.setData((Element)n);
                super.setEnabled(state == 0);
            }
        }
        super.revalidate();
        super.repaint();
    }

    public SVGModel getSVGModel() {
        return this.svgModel;
    }

    public JComponent getExtComponent() {
        return new JScrollPane(this);
    }

    private void styleActionPerformed() {
        String key = (String)this.getValueAt(this.getEditingRow(), 0);
        if (key == null) {
            return;
        }
        commands.getCommand("imhotep.properties.style.action.Style").actionPerformed(key);
    }

    public class ValueEditor
    extends TableCellButtonEditor {
        protected void actionPerformed() {
            StyleTable.this.styleActionPerformed();
        }
    }
}

