/*
 * Decompiled with CFR 0.152.
 */
package imhotep.util;

import core.xml.DOMBuilderException;
import core.xml.DOMBuilderWrapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SVGBuilderWrapper {
    private static SAXSVGDocumentFactory svgFactory = new ExtendsSAXSVGDocumentFactory();
    private static String path = "D:/project-imhotep/183.jpg.svg";

    private SVGBuilderWrapper() {
    }

    public static SVGDocument create() throws DOMBuilderException {
        DOMImplementation svgImpl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        SVGDocument doc = (SVGDocument)svgImpl.createDocument(svgNS, "svg", null);
        return doc;
    }

    public static SVGDocument create(String w, String h) throws DOMBuilderException {
        SVGDocument doc = SVGBuilderWrapper.create();
        doc.getDocumentElement().setAttribute("width", w);
        doc.getDocumentElement().setAttribute("height", h);
        doc.getDocumentElement().setAttribute("viewBox", "0 0 " + w + " " + h);
        return doc;
    }

    public static SVGDocument parse(String uri) throws DOMBuilderException {
        try {
            SVGDocument doc = svgFactory.createSVGDocument(uri);
            DOMBuilderWrapper.normalizeDocument((Document)doc);
            SVGBuilderWrapper.normalizeDocument(doc);
            return doc;
        }
        catch (IOException e) {
            if (e instanceof DOMBuilderException) {
                throw (DOMBuilderException)e;
            }
            throw new DOMBuilderException(e);
        }
    }

    public static SVGDocument parse(URI uri) throws DOMBuilderException {
        String u = uri.toString();
        return SVGBuilderWrapper.parse(u);
    }

    public static SVGDocument parse(File f) throws DOMBuilderException {
        URI u = f.toURI();
        return SVGBuilderWrapper.parse(u);
    }

    public static SVGDocument parse(Reader r) throws DOMBuilderException {
        try {
            SVGDocument doc = svgFactory.createSVGDocument(null, r);
            DOMBuilderWrapper.normalizeDocument((Document)doc);
            SVGBuilderWrapper.normalizeDocument(doc);
            return doc;
        }
        catch (IOException e) {
            if (e instanceof DOMBuilderException) {
                throw (DOMBuilderException)e;
            }
            throw new DOMBuilderException(e);
        }
    }

    public static SVGDocument parse(InputStream in) throws DOMBuilderException {
        try {
            SVGDocument doc = svgFactory.createSVGDocument(null, in);
            DOMBuilderWrapper.normalizeDocument((Document)doc);
            SVGBuilderWrapper.normalizeDocument(doc);
            return doc;
        }
        catch (IOException e) {
            if (e instanceof DOMBuilderException) {
                throw (DOMBuilderException)e;
            }
            throw new DOMBuilderException(e);
        }
    }

    private static void normalizeDocument(SVGDocument doc) {
        ArrayList<Node> arraylist = new ArrayList<Node>();
        DocumentTraversal documenttraversal = (DocumentTraversal)doc;
        NodeIterator nodeiterator = documenttraversal.createNodeIterator((Node)doc, 4, null, false);
        Node node = nodeiterator.nextNode();
        while (node != null) {
            Text text;
            String s;
            if (node instanceof Text && (s = (text = (Text)node).getNodeValue().trim()).length() == 0) {
                arraylist.add(node);
            }
            node = nodeiterator.nextNode();
        }
        int i = 0;
        while (i < arraylist.size()) {
            Node node1 = (Node)arraylist.get(i);
            Node node2 = node1.getParentNode();
            node2.removeChild(node1);
            ++i;
        }
    }

    public static void main(String[] args) throws IOException {
        File f = new File(path);
        long e = 0L;
        SVGDocument doc = null;
        System.out.println("111-------------");
        long s = System.currentTimeMillis();
        doc = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName()).createSVGDocument(f.toURI().toString());
        e = System.currentTimeMillis();
        System.out.println(e - s);
        System.out.println("2222-------------");
        s = System.currentTimeMillis();
        doc = SVGBuilderWrapper.parse(f);
        e = System.currentTimeMillis();
        System.out.println(e - s);
    }

    private static class ExtendsSAXSVGDocumentFactory
    extends SAXSVGDocumentFactory {
        public ExtendsSAXSVGDocumentFactory() {
            super(XMLResourceDescriptor.getXMLParserClassName());
        }

        protected Document createDocument(InputSource is) throws IOException {
            try {
                XMLReader parser = XMLReaderFactory.createXMLReader(((SAXDocumentFactory)this).parserClassName);
                parser.setContentHandler((ContentHandler)((Object)this));
                parser.setDTDHandler((DTDHandler)((Object)this));
                parser.setEntityResolver((EntityResolver)((Object)this));
                parser.setErrorHandler((ErrorHandler)(((SAXDocumentFactory)this).errorHandler == null ? this : ((SAXDocumentFactory)this).errorHandler));
                parser.setFeature("http://xml.org/sax/features/namespaces", true);
                parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                parser.setFeature("http://xml.org/sax/features/validation", ((SAXDocumentFactory)this).isValidating);
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)this);
                parser.parse(is);
            }
            catch (SAXException e) {
                throw new DOMBuilderException(e);
            }
            catch (DOMException e) {
                throw new DOMBuilderException(e);
            }
            ((SAXDocumentFactory)this).currentNode = null;
            Document ret = ((SAXDocumentFactory)this).document;
            ((SAXDocumentFactory)this).document = null;
            return ret;
        }
    }
}

