/*
 * Decompiled with CFR 0.152.
 */
package imhotep.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import org.apache.batik.svggen.SVGSyntax;
import org.apache.batik.util.XMLConstants;
import org.w3c.dom.svg.SVGDocument;

public class SVGGeomUtilities
implements SVGSyntax,
XMLConstants {
    private static DecimalFormat format = new DecimalFormat("#.###");

    private SVGGeomUtilities() {
    }

    public static Dimension toSVGDimension(SVGDocument doc) {
        try {
            String w = doc.getDocumentElement().getAttribute("width");
            String h = doc.getDocumentElement().getAttribute("height");
            return new Dimension(Integer.parseInt(w), Integer.parseInt(h));
        }
        catch (Exception e) {
            return new Dimension(1, 1);
        }
    }

    public static String toSVGColor(Color c) {
        StringBuffer b = new StringBuffer();
        b.append("rgb(");
        b.append(c.getRed());
        b.append(",");
        b.append(c.getGreen());
        b.append(",");
        b.append(c.getBlue());
        b.append(")");
        return b.toString();
    }

    public static String toSVGPoints(PathIterator shape) {
        StringBuffer points = new StringBuffer(" ");
        float[] seg = new float[6];
        int segType = 0;
        while (!shape.isDone()) {
            segType = shape.currentSegment(seg);
            switch (segType) {
                case 0: {
                    SVGGeomUtilities.appendPoint(points, seg[0], seg[1]);
                    break;
                }
                case 1: {
                    SVGGeomUtilities.appendPoint(points, seg[0], seg[1]);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            shape.next();
        }
        return points.substring(0, points.length() - 1);
    }

    public static String toSVGPathData(PathIterator pi) {
        StringBuffer d = new StringBuffer("");
        float[] seg = new float[6];
        int segType = 0;
        while (!pi.isDone()) {
            segType = pi.currentSegment(seg);
            switch (segType) {
                case 0: {
                    d.append("M");
                    SVGGeomUtilities.appendPoint(d, seg[0], seg[1]);
                    break;
                }
                case 1: {
                    d.append("L");
                    SVGGeomUtilities.appendPoint(d, seg[0], seg[1]);
                    break;
                }
                case 4: {
                    d.append("Z");
                    break;
                }
                case 2: {
                    d.append("Q");
                    SVGGeomUtilities.appendPoint(d, seg[0], seg[1]);
                    SVGGeomUtilities.appendPoint(d, seg[2], seg[3]);
                    break;
                }
                case 3: {
                    d.append("C");
                    SVGGeomUtilities.appendPoint(d, seg[0], seg[1]);
                    SVGGeomUtilities.appendPoint(d, seg[2], seg[3]);
                    SVGGeomUtilities.appendPoint(d, seg[4], seg[5]);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            pi.next();
        }
        if (d.length() > 0) {
            return d.toString().trim();
        }
        return "";
    }

    private static void appendPoint(StringBuffer d, float x, float y) {
        d.append(SVGGeomUtilities.doubleString(x));
        d.append(" ");
        d.append(SVGGeomUtilities.doubleString(y));
        d.append(" ");
    }

    public static String doubleString(double val) {
        return format.format(val);
    }

    public static Line2D convertLine2D(PathIterator pi) {
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double[] seg = new double[6];
        int segType = 0;
        while (!pi.isDone()) {
            segType = pi.currentSegment(seg);
            switch (segType) {
                case 0: {
                    x1 = seg[0];
                    y1 = seg[1];
                    break;
                }
                case 1: {
                    x2 = seg[0];
                    y2 = seg[1];
                    break;
                }
                case 4: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            pi.next();
        }
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        return line;
    }

    public static Point2D convertPoint2D(PathIterator pi) {
        double x1 = 0.0;
        double y1 = 0.0;
        double[] seg = new double[6];
        int segType = 0;
        while (!pi.isDone()) {
            segType = pi.currentSegment(seg);
            switch (segType) {
                case 0: {
                    x1 = seg[0];
                    y1 = seg[1];
                    break;
                }
                case 1: {
                    break;
                }
                case 4: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            pi.next();
        }
        Point2D.Double point = new Point2D.Double(x1, y1);
        return point;
    }
}

