/*
 * Decompiled with CFR 0.152.
 */
package com.ysystems.ycad.lib.ydxf;

import com.ysystems.ycad.lib.ydxf.YdxfKeyword;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;

public class YdxfPutBuffer {
    private static final int MAX_FRACTION_DIGITS = 6;
    public int put_type = 1;
    public static final int PUT_TYPE_MAIN = 1;
    public static final int PUT_TYPE_FONT = 2;
    public static final int PUT_DOING_OTHER = 0;
    public static final int PUT_DOING_BLOCKS_SECTION = 1;
    public static final int PUT_DOING_ENTITY_SECTION = 2;
    public int put_doing = 0;
    private OutputStream os;
    private PrintStream osp;
    private StringBuffer sb = new StringBuffer(1024);
    private Hashtable kw_cod_str = YdxfKeyword.create_kw_cod_str();

    public void setOutput(int put_type, OutputStream os) {
        this.put_type = put_type;
        this.os = os;
        this.osp = new PrintStream(this.os);
    }

    public void close() {
        this.osp.close();
        this.osp = null;
        try {
            this.os.close();
        }
        catch (IOException e) {
            System.out.println("YdxfPutBuffer:close()|IOException");
            System.out.println("YdxfPutBuffer:close()|message=[" + e.getMessage() + "]");
            e.printStackTrace();
        }
        this.os = null;
    }

    public void putKeywordValue(int grpcod, Integer val) {
        String ws = (String)this.kw_cod_str.get(val);
        if (ws == null) {
            System.out.println("YdxfPutBuffer.putKeyworkdValue: bad keyword val (" + val + "]");
            return;
        }
        this.osp.print(grpcod);
        this.putLineSep();
        this.osp.print(ws);
        this.putLineSep();
    }

    public void putStringValue(int grpcod, String val) {
        this.osp.print(grpcod);
        this.putLineSep();
        this.osp.print(val);
        this.putLineSep();
    }

    public void putIntValue(int grpcod, int val) {
        this.osp.print(grpcod);
        this.putLineSep();
        this.osp.print(val);
        this.putLineSep();
    }

    public void putDoubleValue(int grpcod, double val) {
        this.osp.print(grpcod);
        this.putLineSep();
        this.sb.setLength(0);
        this.sb.append(val + 5.0E-7);
        int sblen = this.sb.length();
        int dpidx = -1;
        int i = 0;
        while (i < sblen) {
            if (this.sb.charAt(i) == '.') {
                dpidx = i;
                break;
            }
            ++i;
        }
        if (dpidx == -1) {
            this.osp.print(val);
            this.putLineSep();
            return;
        }
        if (sblen > dpidx + 7) {
            sblen = dpidx + 7;
            this.sb.setLength(sblen);
        }
        i = sblen - 1;
        while (i > dpidx + 1) {
            if (this.sb.charAt(i) != '0') break;
            this.sb.setLength(--sblen);
            --i;
        }
        i = 0;
        while (i < sblen) {
            this.osp.print(this.sb.charAt(i));
            ++i;
        }
        this.putLineSep();
    }

    public void putLineSep() {
        this.osp.print("\n");
    }

    public void putFlush() {
        this.osp.flush();
    }
}

