/*
 * Decompiled with CFR 0.152.
 */
package com.ysystems.ycad.lib.yxxf;

import com.ysystems.ycad.lib.yxxf.YxxfGfxPointP;

public class YxxfGfxPointW
implements Cloneable {
    public static final YxxfGfxPointW W0 = new YxxfGfxPointW(0.0, 0.0, 0.0);
    public static final YxxfGfxPointW Wx = new YxxfGfxPointW(1.0, 0.0, 0.0);
    public static final YxxfGfxPointW Wy = new YxxfGfxPointW(0.0, 1.0, 0.0);
    public static final YxxfGfxPointW Wz = new YxxfGfxPointW(0.0, 0.0, 1.0);
    public double x;
    public double y;
    public double z;

    public YxxfGfxPointW() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public YxxfGfxPointW(YxxfGfxPointW p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public YxxfGfxPointW(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void copyInto(YxxfGfxPointW p) {
        p.x = this.x;
        p.y = this.y;
        p.z = this.z;
    }

    public YxxfGfxPointW set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public YxxfGfxPointW setP(double dist, double azim, double elev) {
        double radius = dist * Math.cos(elev);
        this.x = radius * Math.cos(azim);
        this.y = radius * Math.sin(azim);
        this.z = dist * Math.sin(elev);
        return this;
    }

    public YxxfGfxPointW set(YxxfGfxPointW PntW) {
        this.x = PntW.x;
        this.y = PntW.y;
        this.z = PntW.z;
        return this;
    }

    public YxxfGfxPointW set(YxxfGfxPointP PntP) {
        double radius = PntP.dist * Math.cos(PntP.elev);
        this.x = radius * Math.cos(PntP.azim);
        this.y = radius * Math.sin(PntP.azim);
        this.z = PntP.dist * Math.sin(PntP.elev);
        return this;
    }

    public void crossProduct(YxxfGfxPointW a, YxxfGfxPointW b) {
        this.x = a.y * b.z - a.z * b.y;
        this.y = a.z * b.x - a.x * b.z;
        this.z = a.x * b.y - a.y * b.x;
    }

    public static void calcAAA(YxxfGfxPointW Ax_out, YxxfGfxPointW Ay_out, YxxfGfxPointW Az_in) {
        if (Math.abs(Az_in.x) < 0.015625 && Math.abs(Az_in.y) < 0.015625) {
            Ax_out.crossProduct(Wy, Az_in);
        } else {
            Ax_out.crossProduct(Wz, Az_in);
        }
        Ax_out.normalize();
        Ay_out.crossProduct(Az_in, Ax_out);
        Ay_out.normalize();
    }

    public void angle() {
        double vecLength = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x = Math.acos(this.x / vecLength);
        this.y = Math.acos(this.y / vecLength);
        this.z = Math.acos(this.z / vecLength);
    }

    public void angle(YxxfGfxPointW p) {
        double vecLength = Math.sqrt(p.x * p.x + p.y * p.y + p.z * p.z);
        this.x = Math.acos(p.x / vecLength);
        this.y = Math.acos(p.y / vecLength);
        this.z = Math.acos(p.z / vecLength);
    }

    public void angleX(YxxfGfxPointW p) {
        this.x = YxxfGfxPointW.calcangle(0.0, 0.0, p.y, p.z);
        this.y = YxxfGfxPointW.calcangle(0.0, 0.0, p.z, p.x);
        this.z = YxxfGfxPointW.calcangle(0.0, 0.0, p.x, p.y);
    }

    public static double calcangle(double x1, double y1, double x2, double y2) {
        double tmpx = x2 - x1;
        double tmpy = y2 - y1;
        double hypt = Math.sqrt(tmpx * tmpx + tmpy * tmpy);
        if (tmpx < 0.0) {
            if (tmpy < 0.0) {
                return Math.PI + Math.acos(-tmpx / hypt);
            }
            return Math.PI - Math.acos(-tmpx / hypt);
        }
        if (tmpy < 0.0) {
            return Math.PI * 2 - Math.acos(tmpx / hypt);
        }
        return Math.acos(tmpx / hypt);
    }

    public void normalize() {
        double vecLength = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x /= vecLength;
        this.y /= vecLength;
        this.z /= vecLength;
    }

    public void normalize(YxxfGfxPointW p) {
        double vecLength = Math.sqrt(p.x * p.x + p.y * p.y + p.z * p.z);
        this.x = p.x / vecLength;
        this.y = p.y / vecLength;
        this.z = p.z / vecLength;
    }

    public double distance() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double distance(YxxfGfxPointW p1) {
        return Math.sqrt((this.x - p1.x) * (this.x - p1.x) + (this.y - p1.y) * (this.y - p1.y) + (this.z - p1.z) * (this.z - p1.z));
    }

    protected Object clone() {
        try {
            YxxfGfxPointW zclone = (YxxfGfxPointW)super.clone();
            return zclone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public String toString() {
        return "YxxfGfxPointW[" + this.x + " " + this.y + " " + this.z + "]";
    }
}

