/*
 * Decompiled with CFR 0.152.
 */
package com.ysystems.ycad.lib.yxxf;

import com.ysystems.ycad.lib.yxxf.YxxfGfxContext;
import com.ysystems.ycad.lib.yxxf.YxxfGfxPointW;
import com.ysystems.ycad.lib.yxxf.YxxfShape;
import com.ysystems.ycad.lib.yxxf.YxxfShapeChar;

public class YxxfGfxShapeChar {
    private YxxfShape shape = null;
    private boolean textvert = false;
    private YxxfGfxPointW tmppnt1 = new YxxfGfxPointW();
    private YxxfGfxPointW tmppnt2 = new YxxfGfxPointW();
    private YxxfGfxPointW center = new YxxfGfxPointW();
    private YxxfGfxPointW[] locstack = new YxxfGfxPointW[]{new YxxfGfxPointW(), new YxxfGfxPointW(), new YxxfGfxPointW(), new YxxfGfxPointW(), new YxxfGfxPointW(), new YxxfGfxPointW(), new YxxfGfxPointW(), new YxxfGfxPointW(), new YxxfGfxPointW(), new YxxfGfxPointW(), new YxxfGfxPointW(), new YxxfGfxPointW()};
    private int locstack_topidx = -1;
    private int locstack_size = 12;

    public YxxfGfxShapeChar() {
    }

    public YxxfGfxShapeChar(YxxfShape shape, boolean textvert) {
        this.shape = shape;
        this.textvert = textvert;
    }

    public YxxfShape setShape(YxxfShape shape) {
        this.shape = shape;
        return this.shape;
    }

    public boolean setTextvert(boolean textvert) {
        this.textvert = textvert;
        return this.textvert;
    }

    public void draw(YxxfGfxContext gc, YxxfShapeChar shapechar, double geomscale, YxxfGfxPointW currpnt, YxxfGfxPointW nextpnt) {
        char[] geom = shapechar.getGeom();
        int geomlen = geom.length;
        boolean pendown = true;
        boolean cmndprocess = true;
        this.locstack_topidx = -1;
        int geomidx = 0;
        block35: while (geomidx < geomlen) {
            char geomchar = geom[geomidx];
            if (geomchar == '\u0000') break;
            switch (geomchar) {
                case '\u0001': {
                    ++geomidx;
                    if (cmndprocess) {
                        pendown = true;
                    }
                    cmndprocess = true;
                    break;
                }
                case '\u0002': {
                    ++geomidx;
                    if (cmndprocess) {
                        pendown = false;
                    }
                    cmndprocess = true;
                    break;
                }
                case '\u0003': {
                    ++geomidx;
                    if (cmndprocess) {
                        geomscale /= (double)geom[geomidx];
                    }
                    ++geomidx;
                    cmndprocess = true;
                    break;
                }
                case '\u0004': {
                    ++geomidx;
                    if (cmndprocess) {
                        geomscale *= (double)geom[geomidx];
                    }
                    ++geomidx;
                    cmndprocess = true;
                    break;
                }
                case '\u0005': {
                    ++geomidx;
                    if (cmndprocess && this.locstack_topidx < this.locstack_size - 1) {
                        this.locstack[++this.locstack_topidx].set(currpnt);
                    }
                    cmndprocess = true;
                    break;
                }
                case '\u0006': {
                    ++geomidx;
                    if (cmndprocess && this.locstack_topidx >= 0) {
                        currpnt.set(this.locstack[this.locstack_topidx--]);
                    }
                    cmndprocess = true;
                    break;
                }
                case '\u0007': {
                    ++geomidx;
                    if (cmndprocess) {
                        YxxfShapeChar lookupshapechar = new YxxfShapeChar();
                        YxxfShapeChar foundshapechar = this.shape.findShapeChar(lookupshapechar.setValue(geom[geomidx]));
                        if (foundshapechar == null) {
                            foundshapechar = this.shape.findShapeChar(lookupshapechar.setValue('?'));
                        }
                        if (foundshapechar == null) continue block35;
                        this.draw(gc, foundshapechar, geomscale, currpnt, nextpnt);
                        pendown = false;
                    }
                    ++geomidx;
                    cmndprocess = true;
                    break;
                }
                case '\b': {
                    ++geomidx;
                    if (cmndprocess) {
                        nextpnt.set(currpnt.x + (double)((byte)geom[geomidx]) * geomscale, currpnt.y + (double)((byte)geom[geomidx + 1]) * geomscale, 0.0);
                        if (pendown) {
                            gc.drawLine__ECS__cont__flat__wid_none(currpnt, nextpnt);
                        }
                        currpnt.set(nextpnt);
                    }
                    geomidx += 2;
                    cmndprocess = true;
                    break;
                }
                case '\t': {
                    ++geomidx;
                    while (true) {
                        if (geom[geomidx] == '\u0000' && geom[geomidx + 1] == '\u0000') {
                            geomidx += 2;
                            break;
                        }
                        if (cmndprocess) {
                            nextpnt.set(currpnt.x + (double)((byte)geom[geomidx]) * geomscale, currpnt.y + (double)((byte)geom[geomidx + 1]) * geomscale, 0.0);
                            if (pendown) {
                                gc.drawLine__ECS__cont__flat__wid_none(currpnt, nextpnt);
                            }
                            currpnt.set(nextpnt);
                        }
                        geomidx += 2;
                    }
                    cmndprocess = true;
                    break;
                }
                case '\n': {
                    ++geomidx;
                    if (cmndprocess) {
                        char radius = geom[geomidx];
                        byte octdesc = (byte)geom[geomidx + 1];
                        byte octdescabs = octdesc < 0 ? octdesc : octdesc;
                        int begoct = (octdescabs & 0x70) >>> 4;
                        int incoct = octdescabs & 7;
                        if (incoct == 0) {
                            incoct = 8;
                        }
                        double begang = (double)begoct * 45.0;
                        double swgang = octdesc < 0 ? (double)(-incoct) * 45.0 : (double)incoct * 45.0;
                        this.center.set(currpnt.x - Math.cos(begang * (Math.PI / 180)) * (double)radius * geomscale, currpnt.y - Math.sin(begang * (Math.PI / 180)) * (double)radius * geomscale, 0.0);
                        if (pendown) {
                            gc.drawCircle__ECS__cont__flat__wid_none(this.center, (double)radius * geomscale, begang * (Math.PI / 180), swgang * (Math.PI / 180));
                        }
                        currpnt.set(this.center.x + Math.cos((begang + swgang) * (Math.PI / 180)) * (double)radius * geomscale, this.center.y + Math.sin((begang + swgang) * (Math.PI / 180)) * (double)radius * geomscale, 0.0);
                    }
                    geomidx += 2;
                    cmndprocess = true;
                    break;
                }
                case '\u000b': {
                    ++geomidx;
                    if (cmndprocess) {
                        char begoffset = geom[geomidx];
                        char endoffset = geom[geomidx + 1];
                        int radius = geom[geomidx + 2] * 256 + geom[geomidx + 3];
                        byte octdesc = (byte)geom[geomidx + 4];
                        byte octdescabs = octdesc < 0 ? octdesc : octdesc;
                        int begoct = (octdescabs & 0x70) >>> 4;
                        int incoct = octdescabs & 7;
                        if (incoct == 0) {
                            incoct = 8;
                        }
                        double begang = 0.0;
                        double swgang = 0.0;
                        if (octdesc < 0) {
                            begang = (double)begoct * 45.0 - (double)begoffset * 0.17578125;
                            swgang = endoffset != '\u0000' ? (double)(incoct - 1) * 45.0 + (double)endoffset * 0.17578125 - (double)begoffset * 0.17578125 : (double)incoct * 45.0 - (double)begoffset * 0.17578125;
                            swgang = -swgang;
                        } else {
                            begang = (double)begoct * 45.0 + (double)begoffset * 0.17578125;
                            swgang = endoffset != '\u0000' ? (double)(incoct - 1) * 45.0 + (double)endoffset * 0.17578125 - (double)begoffset * 0.17578125 : (double)incoct * 45.0 - (double)begoffset * 0.17578125;
                        }
                        this.center.set(currpnt.x - Math.cos(begang * (Math.PI / 180)) * (double)radius * geomscale, currpnt.y - Math.sin(begang * (Math.PI / 180)) * (double)radius * geomscale, 0.0);
                        if (pendown) {
                            gc.drawCircle__ECS__cont__flat__wid_none(this.center, (double)radius * geomscale, begang * (Math.PI / 180), swgang * (Math.PI / 180));
                        }
                        currpnt.set(this.center.x + Math.cos((begang + swgang) * (Math.PI / 180)) * (double)radius * geomscale, this.center.y + Math.sin((begang + swgang) * (Math.PI / 180)) * (double)radius * geomscale, 0.0);
                    }
                    geomidx += 5;
                    cmndprocess = true;
                    break;
                }
                case '\f': {
                    ++geomidx;
                    if (cmndprocess) {
                        nextpnt.set(currpnt.x + (double)((byte)geom[geomidx]) * geomscale, currpnt.y + (double)((byte)geom[geomidx + 1]) * geomscale, 0.0);
                        if (pendown) {
                            this.drawArc_XY_Bulge(gc, currpnt, nextpnt, (double)((byte)geom[geomidx + 2]) * geomscale);
                        }
                        currpnt.set(nextpnt);
                    }
                    geomidx += 3;
                    cmndprocess = true;
                    break;
                }
                case '\r': {
                    ++geomidx;
                    while (true) {
                        if (geom[geomidx] == '\u0000' && geom[geomidx + 1] == '\u0000') {
                            geomidx += 2;
                            break;
                        }
                        if (cmndprocess) {
                            nextpnt.set(currpnt.x + (double)((byte)geom[geomidx]) * geomscale, currpnt.y + (double)((byte)geom[geomidx + 1]) * geomscale, 0.0);
                            if (pendown) {
                                this.drawArc_XY_Bulge(gc, currpnt, nextpnt, (double)((byte)geom[geomidx + 2]) * geomscale);
                            }
                            currpnt.set(nextpnt);
                        }
                        geomidx += 3;
                    }
                    cmndprocess = true;
                    break;
                }
                case '\u000e': {
                    ++geomidx;
                    if (this.textvert) {
                        cmndprocess = true;
                        break;
                    }
                    cmndprocess = false;
                    break;
                }
                case '\u000f': {
                    ++geomidx;
                    System.out.println("        tcmd0x0F:0x0F NOT USED");
                    cmndprocess = true;
                    break;
                }
                default: {
                    if (cmndprocess) {
                        double y;
                        double x;
                        char veclen = (char)(geomchar >>> 4);
                        switch (geomchar & 0xF) {
                            case 0: {
                                x = (double)veclen * geomscale;
                                y = 0.0;
                                break;
                            }
                            case 1: {
                                x = (double)veclen * geomscale;
                                y = (double)veclen * geomscale / 2.0;
                                break;
                            }
                            case 2: {
                                x = (double)veclen * geomscale;
                                y = (double)veclen * geomscale;
                                break;
                            }
                            case 3: {
                                x = (double)veclen * geomscale / 2.0;
                                y = (double)veclen * geomscale;
                                break;
                            }
                            case 4: {
                                x = 0.0;
                                y = (double)veclen * geomscale;
                                break;
                            }
                            case 5: {
                                x = (double)(-veclen) * geomscale / 2.0;
                                y = (double)veclen * geomscale;
                                break;
                            }
                            case 6: {
                                x = (double)(-veclen) * geomscale;
                                y = (double)veclen * geomscale;
                                break;
                            }
                            case 7: {
                                x = (double)(-veclen) * geomscale;
                                y = (double)veclen * geomscale / 2.0;
                                break;
                            }
                            case 8: {
                                x = (double)(-veclen) * geomscale;
                                y = 0.0;
                                break;
                            }
                            case 9: {
                                x = (double)(-veclen) * geomscale;
                                y = (double)(-veclen) * geomscale / 2.0;
                                break;
                            }
                            case 10: {
                                x = (double)(-veclen) * geomscale;
                                y = (double)(-veclen) * geomscale;
                                break;
                            }
                            case 11: {
                                x = (double)(-veclen) * geomscale / 2.0;
                                y = (double)(-veclen) * geomscale;
                                break;
                            }
                            case 12: {
                                x = 0.0;
                                y = (double)(-veclen) * geomscale;
                                break;
                            }
                            case 13: {
                                x = (double)veclen * geomscale / 2.0;
                                y = (double)(-veclen) * geomscale;
                                break;
                            }
                            case 14: {
                                x = (double)veclen * geomscale;
                                y = (double)(-veclen) * geomscale;
                                break;
                            }
                            case 15: {
                                x = (double)veclen * geomscale;
                                y = (double)(-veclen) * geomscale / 2.0;
                                break;
                            }
                            default: {
                                x = 0.0;
                                y = 0.0;
                            }
                        }
                        nextpnt.set(currpnt.x + x, currpnt.y + y, 0.0);
                        if (pendown) {
                            gc.drawLine__ECS__cont__flat__wid_none(currpnt, nextpnt);
                        }
                        currpnt.set(nextpnt);
                    }
                    ++geomidx;
                    cmndprocess = true;
                }
            }
        }
    }

    public void drawArc_XY_Bulge(YxxfGfxContext gc, YxxfGfxPointW currpnt, YxxfGfxPointW nextpnt, double bulge) {
        double swgang;
        double begang;
        boolean angdircw;
        if (bulge == 0.0) {
            gc.drawLine__ECS__cont__flat__wid_none(currpnt, nextpnt);
            return;
        }
        if (bulge < 0.0) {
            bulge = -bulge;
            angdircw = true;
        } else {
            angdircw = false;
        }
        double chordlen = YxxfGfxContext.calcdis(currpnt.x, currpnt.y, nextpnt.x, nextpnt.y);
        double sagitta = bulge * chordlen / 254.0;
        double radius = (chordlen * chordlen / 4.0 + sagitta * sagitta) / (sagitta + sagitta);
        double apothem = radius - sagitta;
        double midpntx = (currpnt.x + nextpnt.x) / 2.0;
        double midpnty = (currpnt.y + nextpnt.y) / 2.0;
        this.tmppnt1.set(nextpnt.x - currpnt.x, nextpnt.y - currpnt.y, nextpnt.z - currpnt.z);
        this.tmppnt1.normalize();
        this.tmppnt2.crossProduct(this.tmppnt1, YxxfGfxPointW.Wz);
        this.tmppnt2.normalize();
        if (angdircw) {
            this.center.set(midpntx + apothem * this.tmppnt2.x, midpnty + apothem * this.tmppnt2.y, 0.0);
            begang = YxxfGfxContext.calcangle(this.center.x, this.center.y, currpnt.x, currpnt.y);
            double endang = YxxfGfxContext.calcangle(this.center.x, this.center.y, nextpnt.x, nextpnt.y);
            swgang = endang > begang ? endang - begang - Math.PI - Math.PI : endang - begang;
        } else {
            this.center.set(midpntx - apothem * this.tmppnt2.x, midpnty - apothem * this.tmppnt2.y, 0.0);
            begang = YxxfGfxContext.calcangle(this.center.x, this.center.y, currpnt.x, currpnt.y);
            double endang = YxxfGfxContext.calcangle(this.center.x, this.center.y, nextpnt.x, nextpnt.y);
            swgang = endang < begang ? endang - begang + Math.PI + Math.PI : endang - begang;
        }
        gc.drawCircle__ECS__cont__flat__wid_none(this.center, radius, begang, swgang);
    }
}

