/*
 * Decompiled with CFR 0.152.
 */
package imhotepc.transcoder;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.batik.dom.svg.ExtensibleSVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.AbstractTranscoder;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscoderSupport;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.XMLFilter;

public abstract class AbstractToSVGTranscoder
extends AbstractTranscoder
implements SVGConstants {
    public static final int TRANSCODER_ERROR_BASE = 255;
    public static final int ERROR_NULL_INPUT = 255;
    public static final int ERROR_INCOMPATIBLE_INPUT_TYPE = 256;
    public static final int ERROR_INCOMPATIBLE_OUTPUT_TYPE = 257;
    public static final TranscodingHints.Key KEY_HEIGHT = SVGAbstractTranscoder.KEY_HEIGHT;
    public static final TranscodingHints.Key KEY_WIDTH = SVGAbstractTranscoder.KEY_WIDTH;

    public void transcode(TranscoderInput input, TranscoderOutput output) throws TranscoderException {
        DOMImplementation domImpl = ExtensibleSVGDOMImplementation.getDOMImplementation();
        Document doc = domImpl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        SVGGraphics2D g2d = this.createSVGGraphics2D(doc);
        Element root = this.readInputToSVG(g2d, doc, input);
        this.writeSVGToOutput(g2d, root, output);
    }

    protected abstract SVGGraphics2D createSVGGraphics2D(Document var1);

    protected abstract Element readInputToSVG(SVGGraphics2D var1, Document var2, TranscoderInput var3) throws TranscoderException;

    protected DataInputStream getInputStream(TranscoderInput input) throws TranscoderException {
        InputStream in;
        if (input == null) {
            ((TranscoderSupport)this).handler.fatalError(new TranscoderException("255"));
        }
        if ((in = input.getInputStream()) != null) {
            return new DataInputStream(new BufferedInputStream(in));
        }
        String uri = input.getURI();
        if (uri != null) {
            try {
                URL url = new URL(uri);
                in = url.openStream();
                return new DataInputStream(new BufferedInputStream(in));
            }
            catch (MalformedURLException e) {
                ((TranscoderSupport)this).handler.fatalError(new TranscoderException((Exception)e));
            }
            catch (IOException e) {
                ((TranscoderSupport)this).handler.fatalError(new TranscoderException((Exception)e));
            }
        }
        ((TranscoderSupport)this).handler.fatalError(new TranscoderException("256"));
        return null;
    }

    protected void writeSVGToOutput(SVGGraphics2D svgGenerator, Element svgRoot, TranscoderOutput output) throws TranscoderException {
        block9: {
            Document doc;
            XMLFilter xmlFilter = output.getXMLFilter();
            if (xmlFilter != null) {
                ((TranscoderSupport)this).handler.fatalError(new TranscoderException("257"));
            }
            if ((doc = output.getDocument()) != null) {
                ((TranscoderSupport)this).handler.fatalError(new TranscoderException("257"));
            }
            try {
                OutputStream os = output.getOutputStream();
                if (os != null) {
                    svgGenerator.stream(svgRoot, (Writer)new OutputStreamWriter(os, "UTF-8"));
                    return;
                }
                Writer wr = output.getWriter();
                if (wr != null) {
                    svgGenerator.stream(svgRoot, wr);
                    return;
                }
                String uri = output.getURI();
                if (uri == null) break block9;
                try {
                    URL url = new URL(uri);
                    URLConnection urlCnx = url.openConnection();
                    os = urlCnx.getOutputStream();
                    svgGenerator.stream(svgRoot, (Writer)new OutputStreamWriter(os, "UTF-8"));
                    return;
                }
                catch (MalformedURLException e) {
                    ((TranscoderSupport)this).handler.fatalError(new TranscoderException((Exception)e));
                }
                catch (IOException e) {
                    ((TranscoderSupport)this).handler.fatalError(new TranscoderException((Exception)e));
                }
            }
            catch (IOException e) {
                throw new TranscoderException((Exception)e);
            }
        }
        throw new TranscoderException("257");
    }

    public String getInputUrl(TranscoderInput input) throws TranscoderException {
        String uri;
        if (input == null) {
            ((TranscoderSupport)this).handler.fatalError(new TranscoderException("255"));
        }
        if ((uri = input.getURI()) != null) {
            try {
                URL url = new URL(uri);
                InputStream in = url.openStream();
                return uri;
            }
            catch (MalformedURLException e) {
                ((TranscoderSupport)this).handler.fatalError(new TranscoderException((Exception)e));
            }
            catch (IOException e) {
                ((TranscoderSupport)this).handler.fatalError(new TranscoderException((Exception)e));
            }
        }
        ((TranscoderSupport)this).handler.fatalError(new TranscoderException("256"));
        return null;
    }
}

