/*
 * Decompiled with CFR 0.152.
 */
package imhotepc.transcoder.dxf.tosvg;

import imhotepc.transcoder.AbstractToSVGTranscoder;
import imhotepc.transcoder.dxf.tosvg.DXFGraphics2D;
import imhotepc.transcoder.dxf.tosvg.DXFTranscoder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.w3c.dom.Document;

public class DXF2SVGViewer
extends JFrame
implements ActionListener,
GVTTreeBuilderListener,
GVTTreeRendererListener {
    private Transcoder converter;
    private File input;
    private File output = new File("temp.svg");
    private JFileChooser chooser = new JFileChooser();
    private JSVGCanvas canvas = new JSVGCanvas();
    private JButton button;
    private JCheckBox isImaged;
    private JTextArea source;
    private JTextField width;
    private JTextField height;

    public DXF2SVGViewer() {
        super("DXF2SVGViewer");
        this.canvas.setDocumentState(2);
        this.canvas.setDoubleBuffered(false);
        this.canvas.addGVTTreeBuilderListener((GVTTreeBuilderListener)this);
        this.canvas.addGVTTreeRendererListener((GVTTreeRendererListener)this);
        this.canvas.setPreferredSize(new Dimension(640, 480));
        this.button = new JButton("Open");
        this.button.addActionListener(this);
        this.isImaged = new JCheckBox("Use DXFGraphics2D");
        this.isImaged.setSelected(true);
        this.source = new JTextArea();
        this.width = new JTextField(4);
        this.width.setText("640");
        this.height = new JTextField(4);
        this.height.setText("480");
        JPanel p = new JPanel();
        p.add(new JLabel("width"));
        p.add(this.width);
        p.add(new JLabel("height"));
        p.add(this.height);
        p.add(this.isImaged);
        p.add(this.button);
        JTabbedPane tab = new JTabbedPane();
        tab.addTab("Canvas", new JScrollPane((Component)this.canvas));
        tab.addTab("Source", new JScrollPane(this.source));
        super.setDefaultCloseOperation(3);
        super.getContentPane().setLayout(new BorderLayout());
        super.getContentPane().add((Component)p, "North");
        super.getContentPane().add((Component)tab, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        int r = this.chooser.showOpenDialog(this.button);
        if (r == 0) {
            Float w = new Float(this.width.getText());
            Float h = new Float(this.height.getText());
            this.canvas.setPreferredSize(new Dimension(w.intValue(), h.intValue()));
            this.canvas.revalidate();
            this.input = this.chooser.getSelectedFile();
            try {
                TranscoderInput i = new TranscoderInput(this.input.toURL().toString());
                TranscoderOutput o = new TranscoderOutput((OutputStream)new FileOutputStream(this.output));
                this.converter = this.isImaged.isSelected() ? new DXFTranscoder(){

                    protected SVGGraphics2D createSVGGraphics2D(Document doc) {
                        return new DXFGraphics2D(doc);
                    }
                } : new DXFTranscoder(){

                    protected SVGGraphics2D createSVGGraphics2D(Document doc) {
                        return new SVGGraphics2D(doc);
                    }
                };
                this.converter.addTranscodingHint(AbstractToSVGTranscoder.KEY_WIDTH, (Object)w);
                this.converter.addTranscodingHint(AbstractToSVGTranscoder.KEY_HEIGHT, (Object)h);
                this.converter.transcode(i, o);
                this.canvas.setURI(this.output.toURI().toASCIIString());
                new ReadThread().start();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public void gvtBuildStarted(GVTTreeBuilderEvent arg0) {
        System.out.println("gvtBuildStarted");
    }

    public void gvtBuildCompleted(GVTTreeBuilderEvent arg0) {
        System.out.println("gvtBuildCompleted");
    }

    public void gvtBuildCancelled(GVTTreeBuilderEvent arg0) {
        System.out.println("gvtBuildCancelled");
    }

    public void gvtBuildFailed(GVTTreeBuilderEvent arg0) {
        System.out.println("gvtBuildFailed");
    }

    public void gvtRenderingPrepare(GVTTreeRendererEvent arg0) {
        System.out.println("gvtRenderingPrepare");
    }

    public void gvtRenderingStarted(GVTTreeRendererEvent arg0) {
        System.out.println("gvtRenderingStarted");
    }

    public void gvtRenderingCompleted(GVTTreeRendererEvent arg0) {
        System.out.println("gvtRenderingCompleted");
    }

    public void gvtRenderingCancelled(GVTTreeRendererEvent arg0) {
        System.out.println("gvtRenderingCancelled");
    }

    public void gvtRenderingFailed(GVTTreeRendererEvent arg0) {
        System.out.println("gvtRenderingFailed");
    }

    public static void main(String[] args) {
        DXF2SVGViewer viewer = new DXF2SVGViewer();
        viewer.pack();
        viewer.show();
    }

    public class ReadThread
    extends Thread {
        public void run() {
            try {
                DXF2SVGViewer.this.source.read(new BufferedReader(new FileReader(DXF2SVGViewer.this.output)), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

