/*
 * Decompiled with CFR 0.152.
 */
package imhotepc.transcoder.dxf.tosvg;

import imhotepc.transcoder.AbstractToSVGTranscoder;
import imhotepc.transcoder.dxf.tosvg.DXFGraphics2D;
import imhotepc.transcoder.dxf.tosvg.DXFPainter;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscoderSupport;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DXFTranscoder
extends AbstractToSVGTranscoder {
    protected SVGGraphics2D createSVGGraphics2D(Document doc) {
        return new DXFGraphics2D(doc);
    }

    protected Element readInputToSVG(SVGGraphics2D svgGenerator, Document svgDocument, TranscoderInput input) throws TranscoderException {
        String srcurl = super.getInputUrl(input);
        Float widthHint = (Float)((TranscoderSupport)this).hints.get((Object)AbstractToSVGTranscoder.KEY_WIDTH);
        Float heightHint = (Float)((TranscoderSupport)this).hints.get((Object)AbstractToSVGTranscoder.KEY_HEIGHT);
        DXFPainter painter = new DXFPainter(srcurl, widthHint.intValue(), heightHint.intValue());
        painter.paint((Graphics2D)svgGenerator);
        Element svgRoot = svgDocument.getDocumentElement();
        if (!svgRoot.hasChildNodes()) {
            svgRoot = svgGenerator.getRoot();
        }
        String w = "" + widthHint.intValue();
        String h = "" + heightHint.intValue();
        svgRoot.setAttributeNS(null, "width", w);
        svgRoot.setAttributeNS(null, "height", h);
        svgRoot.setAttributeNS(null, "viewBox", "0 0 " + w + " " + h);
        return svgRoot;
    }

    public static void main(String[] args) {
        String transcoder = args[1];
        String width = args[3];
        String height = args[5];
        String inputFile = args[7];
        String outputFile = args[9];
        try {
            System.out.println("#Transcoder Name    : " + transcoder);
            Class<?> clazz = Class.forName(transcoder);
            Transcoder t = (Transcoder)clazz.newInstance();
            t.addTranscodingHint(AbstractToSVGTranscoder.KEY_WIDTH, (Object)new Float(width));
            t.addTranscodingHint(AbstractToSVGTranscoder.KEY_HEIGHT, (Object)new Float(height));
            t.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
            System.out.println("#Transcoder Class   : " + t.getClass());
            System.out.println("#");
            System.out.println("#Input File Name    : " + inputFile);
            File in = new File(inputFile);
            if (!in.exists()) {
                in = new File(new URI(inputFile));
            }
            TranscoderInput input = new TranscoderInput(in.toURI().toASCIIString());
            if (!in.canRead()) {
                throw new IOException("Can not Read");
            }
            System.out.println("#Input File         : " + input.getURI());
            System.out.println("#");
            System.out.println("#Output File Name   : " + outputFile);
            File out = new File(outputFile);
            if (!out.exists()) {
                out = new File(new URI(outputFile));
            }
            FileOutputStream outStream = new FileOutputStream(out);
            TranscoderOutput output = new TranscoderOutput((OutputStream)outStream);
            output.setURI(out.toURI().toASCIIString());
            if (!out.canWrite()) {
                throw new IOException("Can not Write");
            }
            System.out.println("#Output File        : " + input.getURI());
            System.out.println("#");
            System.out.print("#transcode...");
            t.transcode(input, output);
            System.out.println("... Success");
            System.out.println("#");
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e);
            System.exit(-1);
        }
    }
}

