/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.dom.svg.ListHandler;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;

public abstract class AbstractSVGList {
    protected boolean valid;
    protected List itemList;

    protected abstract String getItemSeparator();

    protected abstract SVGItem createSVGItem(Object var1);

    protected abstract void doParse(String var1, ListHandler var2) throws ParseException;

    protected abstract void checkItemType(Object var1) throws SVGException;

    protected abstract String getValueAsString();

    protected abstract void setAttributeValue(String var1);

    protected abstract DOMException createDOMException(short var1, String var2, Object[] var3);

    protected AbstractSVGList() {
    }

    public int getNumberOfItems() {
        this.revalidate();
        if (this.itemList != null) {
            return this.itemList.size();
        }
        return 0;
    }

    public void clear() throws DOMException {
        this.revalidate();
        if (this.itemList != null) {
            this.clear(this.itemList);
            this.resetAttribute();
        }
    }

    protected SVGItem initializeImpl(Object object) throws DOMException, SVGException {
        this.checkItemType(object);
        if (this.itemList == null) {
            this.itemList = new ArrayList(1);
        } else {
            this.clear(this.itemList);
        }
        SVGItem sVGItem = this.removeIfNeeded(object);
        this.itemList.add(sVGItem);
        sVGItem.setParent(this);
        this.resetAttribute();
        return sVGItem;
    }

    protected SVGItem getItemImpl(int n) throws DOMException {
        this.revalidate();
        if (n < 0 || n >= this.itemList.size()) {
            throw this.createDOMException((short)1, "AbstractSVGList.getItem.OutOfBoundsException", null);
        }
        return (SVGItem)this.itemList.get(n);
    }

    protected SVGItem insertItemBeforeImpl(Object object, int n) throws DOMException, SVGException {
        this.checkItemType(object);
        this.revalidate();
        if (n < 0) {
            throw this.createDOMException((short)1, "AbstractSVGList.insertItemBefore.OutOfBoundsException", null);
        }
        if (n > this.itemList.size()) {
            n = this.itemList.size();
        }
        SVGItem sVGItem = this.removeIfNeeded(object);
        this.itemList.add(n, sVGItem);
        sVGItem.setParent(this);
        this.resetAttribute();
        return sVGItem;
    }

    protected SVGItem replaceItemImpl(Object object, int n) throws DOMException, SVGException {
        this.checkItemType(object);
        this.revalidate();
        if (n < 0 || n >= this.itemList.size()) {
            throw this.createDOMException((short)1, "AbstractSVGList.replaceItem.OutOfBoundsException", null);
        }
        SVGItem sVGItem = this.removeIfNeeded(object);
        this.itemList.set(n, sVGItem);
        sVGItem.setParent(this);
        this.resetAttribute();
        return sVGItem;
    }

    protected SVGItem removeItemImpl(int n) throws DOMException {
        this.revalidate();
        if (n < 0 || n >= this.itemList.size()) {
            throw this.createDOMException((short)1, "AbstractSVGList.removeItem.OutOfBoundsException", null);
        }
        SVGItem sVGItem = (SVGItem)this.itemList.remove(n);
        sVGItem.setParent(null);
        this.resetAttribute();
        return sVGItem;
    }

    protected SVGItem appendItemImpl(Object object) throws DOMException, SVGException {
        this.checkItemType(object);
        this.revalidate();
        SVGItem sVGItem = this.removeIfNeeded(object);
        this.itemList.add(sVGItem);
        sVGItem.setParent(this);
        if (this.itemList.size() <= 1) {
            this.resetAttribute();
        } else {
            this.resetAttribute(sVGItem);
        }
        return sVGItem;
    }

    protected SVGItem removeIfNeeded(Object object) {
        SVGItem sVGItem = null;
        if (object instanceof SVGItem) {
            sVGItem = (SVGItem)object;
            if (sVGItem.getParent() != null) {
                sVGItem.getParent().removeItem(sVGItem);
            }
        } else {
            sVGItem = this.createSVGItem(object);
        }
        return sVGItem;
    }

    protected void revalidate() {
        if (this.valid) {
            return;
        }
        try {
            ListBuilder listBuilder = new ListBuilder();
            this.doParse(this.getValueAsString(), listBuilder);
            if (listBuilder.getList() != null) {
                this.clear(this.itemList);
            }
            this.itemList = listBuilder.getList();
        }
        catch (ParseException parseException) {
            this.itemList = null;
        }
        this.valid = true;
    }

    protected void setValueAsString(List list) throws DOMException {
        Object object;
        StringBuffer stringBuffer = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (SVGItem)iterator.next();
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(object.getValueAsString());
                continue;
            }
            stringBuffer.append(this.getItemSeparator());
            stringBuffer.append(object.getValueAsString());
        }
        object = null;
        object = stringBuffer == null ? null : stringBuffer.toString();
        this.setAttributeValue((String)object);
        this.valid = true;
    }

    public void itemChanged() {
        this.resetAttribute();
    }

    protected void resetAttribute() {
        this.setValueAsString(this.itemList);
    }

    protected void resetAttribute(SVGItem sVGItem) {
        StringBuffer stringBuffer = new StringBuffer(this.getValueAsString());
        stringBuffer.append(this.getItemSeparator());
        stringBuffer.append(sVGItem.getValueAsString());
        this.setAttributeValue(stringBuffer.toString());
        this.valid = true;
    }

    public void invalidate() {
        this.valid = false;
    }

    protected void removeItem(SVGItem sVGItem) {
        if (this.itemList.contains(sVGItem)) {
            this.itemList.remove(sVGItem);
            sVGItem.setParent(null);
            this.resetAttribute();
        }
    }

    protected void clear(List list) {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SVGItem sVGItem = (SVGItem)iterator.next();
            sVGItem.setParent(null);
        }
        list.clear();
    }

    protected class ListBuilder
    implements ListHandler {
        protected List list;

        public List getList() {
            return this.list;
        }

        public void startList() {
            if (this.list == null) {
                this.list = new ArrayList();
            }
        }

        public void item(SVGItem sVGItem) {
            sVGItem.setParent(AbstractSVGList.this);
            this.list.add(sVGItem);
        }

        public void endList() {
        }
    }
}

