/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.Map;
import org.apache.fop.fonts.BFEntry;
import org.apache.fop.fonts.CIDFont;
import org.apache.fop.fonts.CIDFontType;
import org.apache.fop.fonts.FontType;

public class MultiByteFont
extends CIDFont {
    private static int uniqueCounter = 1;
    private String ttcName = null;
    private String encoding = "Identity-H";
    private String embedResourceName = null;
    private int defaultWidth = 0;
    private CIDFontType cidType = CIDFontType.CIDTYPE2;
    private String namePrefix = null;
    private BFEntry[] bfentries = null;

    public MultiByteFont() {
        this.usedGlyphs.put(new Integer(0), new Integer(0));
        this.usedGlyphsIndex.put(new Integer(0), new Integer(0));
        ++this.usedGlyphsCount;
        this.usedGlyphs.put(new Integer(1), new Integer(1));
        this.usedGlyphsIndex.put(new Integer(1), new Integer(1));
        ++this.usedGlyphsCount;
        this.usedGlyphs.put(new Integer(2), new Integer(2));
        this.usedGlyphsIndex.put(new Integer(2), new Integer(2));
        ++this.usedGlyphsCount;
        int cnt = 0;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            cnt = uniqueCounter++;
        }
        int ctm = (int)(System.currentTimeMillis() & 0xFFFFL);
        this.namePrefix = new String(String.valueOf(cnt) + "E" + Integer.toHexString(ctm));
        this.setFontType(FontType.TYPE0);
    }

    public CIDFontType getCIDType() {
        return this.cidType;
    }

    public String getCidBaseFont() {
        if (this.isEmbeddable()) {
            return String.valueOf(this.namePrefix) + super.getFontName();
        }
        return super.getFontName();
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getFontName() {
        if (this.isEmbeddable()) {
            return String.valueOf(this.namePrefix) + super.getFontName();
        }
        return super.getFontName();
    }

    public String getOrdering() {
        return "UCS";
    }

    public String getRegistry() {
        return "Adobe";
    }

    public int getSupplement() {
        return 0;
    }

    public String getTTCName() {
        return this.ttcName;
    }

    public Map getUsedGlyphs() {
        return this.usedGlyphs;
    }

    public int getWidth(int i, int size) {
        if (this.isEmbeddable()) {
            Integer idx = (Integer)this.usedGlyphsIndex.get(new Integer(i));
            return size * this.width[idx];
        }
        return size * this.width[i];
    }

    public int[] getWidths() {
        int[] arr = new int[this.width.length];
        System.arraycopy(this.width, 0, arr, 0, this.width.length - 1);
        return arr;
    }

    public boolean isEmbeddable() {
        return this.getEmbedFileName() != null || this.embedResourceName != null;
    }

    public char mapChar(char c) {
        char idx = c;
        int retIdx = 0;
        int i = 0;
        while (i < this.bfentries.length && retIdx == 0) {
            if (this.bfentries[i].getUnicodeStart() <= idx && this.bfentries[i].getUnicodeEnd() >= idx) {
                retIdx = this.bfentries[i].getGlyphStartIndex() + idx - this.bfentries[i].getUnicodeStart();
            }
            ++i;
        }
        if (this.isEmbeddable()) {
            Integer newIdx = (Integer)this.usedGlyphs.get(new Integer(retIdx));
            if (newIdx == null) {
                this.usedGlyphs.put(new Integer(retIdx), new Integer(this.usedGlyphsCount));
                this.usedGlyphsIndex.put(new Integer(this.usedGlyphsCount), new Integer(retIdx));
                retIdx = this.usedGlyphsCount++;
            } else {
                retIdx = newIdx;
            }
        }
        return (char)retIdx;
    }

    public void setBFEntries(BFEntry[] bfentries) {
        this.bfentries = bfentries;
    }

    public void setCIDType(CIDFontType cidType) {
        this.cidType = cidType;
    }

    public void setDefaultWidth(int defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    public void setTTCName(String ttcName) {
        this.ttcName = ttcName;
    }

    public void setWidthArray(int[] wds) {
        this.width = wds;
    }
}

