/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.InputStream;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.FopImage;

public abstract class AbstractFopImage
implements FopImage {
    protected int loaded = 0;
    protected int width = 0;
    protected int height = 0;
    protected InputStream inputStream = null;
    protected FopImage.ImageInfo imageInfo = null;
    protected ColorSpace colorSpace = null;
    protected int bitsPerPixel = 0;
    protected byte[] bitmaps = null;
    protected int bitmapsSize = 0;
    protected boolean isTransparent = false;
    protected Color transparentColor = null;

    public AbstractFopImage(FopImage.ImageInfo info) {
        this.inputStream = info.inputStream;
        this.imageInfo = info;
        if (this.imageInfo.width != -1) {
            this.width = this.imageInfo.width;
            this.height = this.imageInfo.height;
            this.loaded |= 1;
        }
    }

    public byte[] getBitmaps() {
        return this.bitmaps;
    }

    public int getBitmapsSize() {
        return this.bitmapsSize;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public int getHeight() {
        return this.height;
    }

    public ICC_Profile getICCProfile() {
        return null;
    }

    public String getMimeType() {
        return this.imageInfo.mimeType;
    }

    public byte[] getRessourceBytes() {
        return null;
    }

    public int getRessourceBytesSize() {
        return 0;
    }

    public byte[] getSoftMask() {
        return null;
    }

    public Color getTransparentColor() {
        return this.transparentColor;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean hasSoftMask() {
        return false;
    }

    public boolean isTransparent() {
        return this.isTransparent;
    }

    public synchronized boolean load(int type, FOUserAgent ua) {
        if ((this.loaded & type) != 0) {
            return true;
        }
        boolean success = true;
        if ((type & 1) != 0 && (this.loaded & 1) == 0) {
            boolean bl = success = success && this.loadDimensions(ua);
            if (!success) {
                return false;
            }
            this.loaded |= 1;
        }
        if ((type & 4) != 0 && (this.loaded & 4) == 0) {
            boolean bl = success = success && this.loadBitmap(ua);
            if (success) {
                this.loaded |= 4;
            }
        }
        if ((type & 2) != 0 && (this.loaded & 2) == 0) {
            boolean bl = success = success && this.loadOriginalData(ua);
            if (success) {
                this.loaded |= 2;
            }
        }
        return success;
    }

    protected boolean loadBitmap(FOUserAgent ua) {
        return false;
    }

    protected boolean loadDimensions(FOUserAgent ua) {
        return false;
    }

    protected boolean loadOriginalData(FOUserAgent ua) {
        return false;
    }
}

