/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFObject;

public class PDFNumber
extends PDFObject {
    private Number number;

    public static String doubleOut(double doubleDown) {
        double trouble;
        StringBuffer p = new StringBuffer();
        if (doubleDown < 0.0) {
            doubleDown = -doubleDown;
            p.append("-");
        }
        if ((trouble = doubleDown % 1.0) > 0.95) {
            p.append((int)doubleDown + 1);
        } else if (trouble < 0.05) {
            p.append((int)doubleDown);
        } else {
            String doubleString = new String(String.valueOf(doubleDown));
            int decimal = doubleString.indexOf(".");
            if (decimal != -1) {
                p.append(doubleString.substring(0, decimal));
                if (doubleString.length() - decimal > 6) {
                    p.append(doubleString.substring(decimal, decimal + 6));
                } else {
                    p.append(doubleString.substring(decimal));
                }
            } else {
                p.append(doubleString);
            }
        }
        return p.toString();
    }

    public static String doubleOut(double doubleDown, int dec) {
        double trouble;
        StringBuffer p = new StringBuffer();
        if (doubleDown < 0.0) {
            doubleDown = -doubleDown;
            p.append("-");
        }
        if ((trouble = doubleDown % 1.0) > 1.0 - 5.0 / Math.pow(10.0, dec)) {
            p.append((int)doubleDown + 1);
        } else if (trouble < 5.0 / Math.pow(10.0, dec)) {
            p.append((int)doubleDown);
        } else {
            String doubleString = new String(String.valueOf(doubleDown));
            int decimal = doubleString.indexOf(".");
            if (decimal != -1) {
                p.append(doubleString.substring(0, decimal));
                if (doubleString.length() - decimal > dec) {
                    p.append(doubleString.substring(decimal, decimal + dec));
                } else {
                    p.append(doubleString.substring(decimal));
                }
            } else {
                p.append(doubleString);
            }
        }
        return p.toString();
    }

    public static String doubleOut(Double doubleDown) {
        return PDFNumber.doubleOut((double)doubleDown);
    }

    public Number getNumber() {
        return this.number;
    }

    public void setNumber(Number number) {
        this.number = number;
    }

    protected String toPDFString() {
        if (this.getNumber() == null) {
            throw new IllegalArgumentException("The number of this PDFNumber must not be empty");
        }
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getObjectID());
        sb.append(this.getNumber().toString());
        sb.append("\nendobj\n");
        return sb.toString();
    }
}

