/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFText;

public abstract class PDFObject {
    private int objnum;
    private int generation = 0;
    private PDFDocument document;

    public static final byte[] encode(String text) {
        return PDFDocument.encode(text);
    }

    protected byte[] encodeString(String string) {
        return this.encodeText(string);
    }

    protected byte[] encodeText(String text) {
        if (this.getDocumentSafely().isEncryptionActive()) {
            byte[] buf = PDFText.toUTF16(text);
            return PDFText.escapeByteArray(this.getDocument().getEncryption().encrypt(buf, this));
        }
        return PDFObject.encode(PDFText.escapeText(text, true));
    }

    public final PDFDocument getDocument() {
        return this.document;
    }

    public final PDFDocument getDocumentSafely() {
        PDFDocument doc = this.getDocument();
        if (doc == null) {
            throw new IllegalStateException("Parent PDFDocument is unavailable");
        }
        return doc;
    }

    public int getGeneration() {
        return this.generation;
    }

    public String getObjectID() {
        return String.valueOf(this.getObjectNumber()) + " " + this.getGeneration() + " obj\n";
    }

    public int getObjectNumber() {
        if (this.objnum == 0) {
            throw new IllegalStateException("Object has no number assigned: " + this.toString());
        }
        return this.objnum;
    }

    public boolean hasObjectNumber() {
        return this.objnum > 0;
    }

    protected int output(OutputStream stream) throws IOException {
        byte[] pdf = this.toPDF();
        stream.write(pdf);
        return pdf.length;
    }

    public String referencePDF() {
        String ref = String.valueOf(this.getObjectNumber()) + " " + this.getGeneration() + " R";
        return ref;
    }

    public void setDocument(PDFDocument doc) {
        this.document = doc;
    }

    public void setObjectNumber(int objnum) {
        this.objnum = objnum;
    }

    protected byte[] toPDF() {
        return PDFObject.encode(this.toPDFString());
    }

    protected String toPDFString() {
        throw new UnsupportedOperationException("Not implemented. Use output(OutputStream) instead.");
    }
}

