/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.StreamCache;

public class PDFPattern
extends PDFPathPaint {
    protected PDFResources resources = null;
    protected int patternType = 2;
    protected String patternName = null;
    protected int paintType = 2;
    protected int tilingType = 1;
    protected List bBox = null;
    protected double xStep = -1.0;
    protected double yStep = -1.0;
    protected PDFShading shading = null;
    protected List xUID = null;
    protected StringBuffer extGState = null;
    protected List matrix = null;
    protected StringBuffer patternDataStream = null;

    public PDFPattern(int thePatternType, PDFShading theShading, List theXUID, StringBuffer theExtGState, List theMatrix) {
        this.patternType = 2;
        this.shading = theShading;
        this.xUID = theXUID;
        this.extGState = theExtGState;
        this.matrix = theMatrix;
    }

    public PDFPattern(PDFResources theResources, int thePatternType, int thePaintType, int theTilingType, List theBBox, double theXStep, double theYStep, List theMatrix, List theXUID, StringBuffer thePatternDataStream) {
        this.resources = theResources;
        this.patternType = 1;
        this.paintType = thePaintType;
        this.tilingType = theTilingType;
        this.bBox = theBBox;
        this.xStep = theXStep;
        this.yStep = theYStep;
        this.matrix = theMatrix;
        this.xUID = theXUID;
        this.patternDataStream = thePatternDataStream;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PDFPattern)) {
            return false;
        }
        PDFPattern patt = (PDFPattern)obj;
        if (this.patternType != patt.patternType) {
            return false;
        }
        if (this.paintType != patt.paintType) {
            return false;
        }
        if (this.tilingType != patt.tilingType) {
            return false;
        }
        if (this.xStep != patt.xStep) {
            return false;
        }
        if (this.yStep != patt.yStep) {
            return false;
        }
        if (this.bBox != null ? !this.bBox.equals(patt.bBox) : patt.bBox != null) {
            return false;
        }
        if (this.bBox != null ? !this.bBox.equals(patt.bBox) : patt.bBox != null) {
            return false;
        }
        if (this.xUID != null ? !this.xUID.equals(patt.xUID) : patt.xUID != null) {
            return false;
        }
        if (this.extGState != null ? !this.extGState.equals(patt.extGState) : patt.extGState != null) {
            return false;
        }
        if (this.matrix != null ? !this.matrix.equals(patt.matrix) : patt.matrix != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(patt.resources) : patt.resources != null) {
            return false;
        }
        if (this.shading != null ? !this.shading.equals(patt.shading) : patt.shading != null) {
            return false;
        }
        return !(this.patternDataStream != null ? !this.patternDataStream.equals(patt.patternDataStream) : patt.patternDataStream != null);
    }

    public String getColorSpaceOut(boolean fillNotStroke) {
        if (fillNotStroke) {
            return "/Pattern cs /" + this.getName() + " scn \n";
        }
        return "/Pattern CS /" + this.getName() + " SCN \n";
    }

    public String getName() {
        return this.patternName;
    }

    protected int output(OutputStream stream) throws IOException {
        int vectorSize = 0;
        int tempInt = 0;
        StringBuffer p = new StringBuffer(64);
        p.append(this.getObjectID());
        p.append("<< \n/Type /Pattern \n");
        if (this.resources != null) {
            p.append("/Resources " + this.resources.referencePDF() + " \n");
        }
        p.append("/PatternType " + this.patternType + " \n");
        AbstractPDFStream pdfStream = null;
        StreamCache encodedStream = null;
        if (this.patternType == 1) {
            p.append("/PaintType " + this.paintType + " \n");
            p.append("/TilingType " + this.tilingType + " \n");
            if (this.bBox != null) {
                vectorSize = this.bBox.size();
                p.append("/BBox [ ");
                tempInt = 0;
                while (tempInt < vectorSize) {
                    p.append(PDFNumber.doubleOut((Double)this.bBox.get(tempInt)));
                    p.append(" ");
                    ++tempInt;
                }
                p.append("] \n");
            }
            p.append("/XStep " + PDFNumber.doubleOut(new Double(this.xStep)) + " \n");
            p.append("/YStep " + PDFNumber.doubleOut(new Double(this.yStep)) + " \n");
            if (this.matrix != null) {
                vectorSize = this.matrix.size();
                p.append("/Matrix [ ");
                tempInt = 0;
                while (tempInt < vectorSize) {
                    p.append(PDFNumber.doubleOut((Double)this.matrix.get(tempInt)));
                    p.append(" ");
                    ++tempInt;
                }
                p.append("] \n");
            }
            if (this.xUID != null) {
                vectorSize = this.xUID.size();
                p.append("/XUID [ ");
                tempInt = 0;
                while (tempInt < vectorSize) {
                    p.append(String.valueOf(String.valueOf((Integer)this.xUID.get(tempInt))) + " ");
                    ++tempInt;
                }
                p.append("] \n");
            }
            if (this.patternDataStream != null) {
                pdfStream = new PDFStream();
                pdfStream.setDocument(this.getDocumentSafely());
                ((PDFStream)pdfStream).add(this.patternDataStream.toString());
                pdfStream.getFilterList().addDefaultFilters(this.getDocument().getFilterMap(), "content");
                encodedStream = pdfStream.encodeStream();
                p.append(pdfStream.getFilterList().buildFilterDictEntries());
                p.append("/Length " + (encodedStream.getSize() + 1) + " \n");
            }
        } else {
            if (this.shading != null) {
                p.append("/Shading " + this.shading.referencePDF() + " \n");
            }
            if (this.xUID != null) {
                vectorSize = this.xUID.size();
                p.append("/XUID [ ");
                tempInt = 0;
                while (tempInt < vectorSize) {
                    p.append(String.valueOf(String.valueOf((Integer)this.xUID.get(tempInt))) + " ");
                    ++tempInt;
                }
                p.append("] \n");
            }
            if (this.extGState != null) {
                p.append("/ExtGState " + this.extGState + " \n");
            }
            if (this.matrix != null) {
                vectorSize = this.matrix.size();
                p.append("/Matrix [ ");
                tempInt = 0;
                while (tempInt < vectorSize) {
                    p.append(PDFNumber.doubleOut((Double)this.matrix.get(tempInt)));
                    p.append(" ");
                    ++tempInt;
                }
                p.append("] \n");
            }
        }
        p.append(">> \n");
        byte[] buffer = PDFObject.encode(p.toString());
        int length = buffer.length;
        stream.write(buffer);
        if (pdfStream != null) {
            length += pdfStream.outputStreamData(encodedStream, stream);
        }
        buffer = PDFObject.encode("\nendobj\n");
        stream.write(buffer);
        return length += buffer.length;
    }

    public void setName(String name) {
        if (name.indexOf(" ") >= 0) {
            throw new IllegalArgumentException("Pattern name must not contain any spaces");
        }
        this.patternName = name;
    }

    public byte[] toPDF() {
        return null;
    }
}

