/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.fop.apps.Document;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.render.ps.PSGenerator;
import org.apache.fop.render.ps.PSGraphics2D;
import org.apache.fop.render.ps.PSProcSets;

public class PSDocumentGraphics2D
extends PSGraphics2D {
    private int width;
    private int height;

    public PSDocumentGraphics2D(PSDocumentGraphics2D g) {
        super(g);
    }

    PSDocumentGraphics2D(boolean textAsShapes) {
        super(textAsShapes);
        if (!textAsShapes) {
            this.fontInfo = new Document(null);
            FontSetup.setup(this.fontInfo, null);
        }
        this.currentFontName = "";
        this.currentFontSize = 0;
    }

    public PSDocumentGraphics2D(boolean textAsShapes, OutputStream stream, int width, int height) throws IOException {
        this(textAsShapes);
        this.setupDocument(stream, width, height);
    }

    public Graphics create() {
        return new PSDocumentGraphics2D(this);
    }

    public void drawString(String s, float x, float y) {
        if (this.textAsShapes) {
            Font font = super.getFont();
            FontRenderContext frc = super.getFontRenderContext();
            GlyphVector gv = font.createGlyphVector(frc, s);
            Shape glyphOutline = gv.getOutline(x, y);
            super.fill(glyphOutline);
        } else {
            super.drawString(s, x, y);
        }
    }

    public void finish() throws IOException {
        this.gen.writeln("showpage");
        this.gen.writeDSCComment("PageTrailer");
        this.gen.writeDSCComment("EndPage");
        this.gen.writeDSCComment("Trailer");
        this.gen.writeDSCComment("EOF");
        this.gen.flush();
    }

    public Document getFontInfo() {
        return this.fontInfo;
    }

    public void setBackgroundColor(Color col) {
    }

    public void setSVGDimension(float w, float h) throws IOException {
        this.gen.concatMatrix((float)this.width / w, 0.0, 0.0, (float)this.height / h, 0.0, 0.0);
    }

    public void setupDocument(OutputStream stream, int width, int height) throws IOException {
        this.width = width;
        this.height = height;
        Integer zero = new Integer(0);
        Long pagewidth = new Long(this.width);
        Long pageheight = new Long(this.height);
        this.setPSGenerator(new PSGenerator(stream));
        this.gen.writeln("%!PS-Adobe-3.0");
        this.gen.writeDSCComment("Creator", new String[]{"FOP PostScript Transcoder for SVG"});
        this.gen.writeDSCComment("CreationDate", new Object[]{new Date()});
        this.gen.writeDSCComment("Pages", new Object[]{new Integer(1)});
        this.gen.writeDSCComment("BoundingBox", new Object[]{zero, zero, pagewidth, pageheight});
        this.gen.writeDSCComment("EndComments");
        this.gen.writeDSCComment("BeginDefaults");
        this.gen.writeDSCComment("EndDefaults");
        this.gen.writeDSCComment("BeginProlog");
        this.gen.writeDSCComment("EndProlog");
        this.gen.writeDSCComment("BeginSetup");
        PSProcSets.writeFOPStdProcSet(this.gen);
        PSProcSets.writeFOPEPSProcSet(this.gen);
        PSProcSets.writeFontDict(this.gen, this.fontInfo);
        this.gen.writeDSCComment("EndSetup");
        Integer pageNumber = new Integer(1);
        this.gen.writeDSCComment("Page", new Object[]{pageNumber.toString(), pageNumber});
        this.gen.writeDSCComment("PageBoundingBox", new Object[]{zero, zero, pagewidth, pageheight});
        this.gen.writeDSCComment("BeginPageSetup");
        this.gen.writeln("FOPFonts begin");
        this.gen.writeln("0.001 0.001 scale");
        this.gen.concatMatrix(1.0, 0.0, 0.0, -1.0, 0.0, pageheight.doubleValue() * 1000.0);
        this.gen.writeDSCComment("EndPageSetup");
    }
}

