package unisql.itrack;

import java.io.*;
import java.util.Arrays;

abstract public class ITrackFile {

/*=======================================================================
 |      PRIVATE VARIABLES
 =======================================================================*/

private static final String saveRootDir = "itrack";
private static final String formFileExt = ".itk";
private static final String upload_tmp_dir = "tmp";

/*=======================================================================
 |      PUBLIC METHODS
 =======================================================================*/

public static String getFileUploadTmpDir()
{
  String tmpDir = saveRootDir + "/" + upload_tmp_dir;
  File f = new File(tmpDir);
  f.mkdirs();

  return tmpDir;
}

public static String[] getFormfileList(String working_tablename)
{
  String[] fileList;
  String dirpath = getFormfileDirPath(working_tablename);

  ITFileFilter ff = new ITFileFilter(formFileExt);
  File f = new File(dirpath);
  String[] s = f.list(ff);
  if (s == null) {
    fileList = new String[1];
    fileList[0] = "";
    return fileList;
  }

  fileList = new String[s.length + 1];
  fileList[0] = "";
  for (int i=0 ; i < s.length ; i++) {
    fileList[i+1] = s[i].substring(0, s[i].lastIndexOf(formFileExt));
  }
  
  Arrays.sort(fileList);
  
  return fileList;
}

public static ITrackSearchForm loadFormfile(String working_tablename, String filename)
	throws IOException, ClassNotFoundException
{
  String filepath = getFormfilePath(working_tablename, filename);
  return (ITrackSearchForm.load(filepath));
}

public static ITrackSearchForm loadTmpFormfile(String working_tablename, String userid)
	throws IOException, ClassNotFoundException
{
  String filepath = getTmpFormfilePath(working_tablename, userid);
  return (ITrackSearchForm.load(filepath));
}

public static void deleteFormfile(String working_tablename, String userid, String filename)
{
  if (filename == null)
    return;

  if (!filename.startsWith(userid + "."))
    return;

  String filepath = getFormfilePath(working_tablename, filename);
  File f = new File(filepath);
  if (f == null || !f.exists())
    return;
  f.delete();
}

public static void saveFormfile(String working_tablename, String userid, String filename, ITrackSearchForm srchFrm) throws IOException
{
  if (!filename.startsWith(userid + "."))
    return;

  String filepath = getFormfilePath(working_tablename, filename);
  srchFrm.save(filepath);
}

public static void saveTmpFormfile(String working_tablename, String userid, ITrackSearchForm srchFrm)
	throws IOException
{
  String filepath = getTmpFormfilePath(working_tablename, userid);
  srchFrm.save(filepath);
}


/*=======================================================================
 |      PACKAGE ACCESS METHODS
 =======================================================================*/

/*=======================================================================
 |      PRIVATE METHODS
 =======================================================================*/

private static String getFormfileDirPath(String working_tablename)
{
  String dirpath = saveRootDir + "/" + working_tablename;
  File f = new File(dirpath);
  f.mkdirs();
  return dirpath;
}

private static String getTmpFormfilePath(String working_tablename, String userid)
{
  String dirpath = getFormfileDirPath(working_tablename);
  return (dirpath + "/" + userid + formFileExt + ".tmp");
}


private static String getFormfilePath(String working_tablename, String filename)
{
  String dirpath = getFormfileDirPath(working_tablename);

  return (dirpath + "/" + filename + formFileExt);
}

/*
private static String getFormfilePath(String working_tablename, String userid, String filename)
{
  return getFormfilePath(working_tablename, userid + "." + filename);
}
*/

	private static final String templateFileExt = ".tpl";

	public static String[] getTemplateFileList(String working_tablename)
	{
		String[] fileList;
		String dirpath = getFormfileDirPath(working_tablename);

		ITFileFilter ff = new ITFileFilter(templateFileExt);
		File f = new File(dirpath);
		String[] s = f.list(ff);
		if (s == null)
		{
			fileList = new String[1];
			fileList[0] = "";
			return fileList;
		}

		fileList = new String[s.length + 1];
		fileList[0] = "";
		for (int i = 0; i < s.length; i++)
		{
			fileList[i + 1] = s[i].substring(0, s[i].lastIndexOf(templateFileExt));
		}
		Arrays.sort(fileList);

		return fileList;
	}

	public static ITrackTemplate loadTemplateFile(String working_tablename,
			String filename) throws IOException, ClassNotFoundException
	{
		String filepath = getTemplateFilePath(working_tablename, filename);
		return (ITrackTemplate.load(filepath));
	}

	public static ITrackTemplate loadTmpTemplateFile(String working_tablename,
			String userid) throws IOException, ClassNotFoundException
	{
		String filepath = getTmpTemplateFilePath(working_tablename, userid);
		return (ITrackTemplate.load(filepath));
	}

	public static void saveTemplateFile(String working_tablename, String userid,
			String filename, ITrackTemplate srchFrm) throws IOException
	{
		if (!filename.startsWith(userid + "."))
			return;

		String filepath = getTemplateFilePath(working_tablename, filename);
		srchFrm.save(filepath);
	}

	public static void saveTmpTemplateFile(String working_tablename, String userid,
			ITrackTemplate srchFrm) throws IOException
	{
		String filepath = getTmpTemplateFilePath(working_tablename, userid);
		srchFrm.save(filepath);
	}
	
	private static String getTemplateFileDirPath(String working_tablename)
	{
		String dirpath = saveRootDir + "/" + working_tablename;
		File f = new File(dirpath);
		f.mkdirs();
		return dirpath;
	}

	private static String getTmpTemplateFilePath(String working_tablename,
			String userid)
	{
		String dirpath = getTemplateFileDirPath(working_tablename);
		return (dirpath + "/" + userid + templateFileExt + ".tmp");
	}

	private static String getTemplateFilePath(String working_tablename,
			String filename)
	{
		String dirpath = getTemplateFileDirPath(working_tablename);

		return (dirpath + "/" + filename + templateFileExt);
	}
	
	public static void deleteTemplateFile(String working_tablename, String userid,
			String filename)
	{
		if (filename == null)
			return;

		if (!filename.startsWith(userid + "."))
			return;

		String filepath = getTemplateFilePath(working_tablename, filename);
		File f = new File(filepath);
		if (f == null || !f.exists())
			return;
		f.delete();
	}
}

class ITFileFilter implements FilenameFilter {

private String suffix;

ITFileFilter(String suffix)
{
    this.suffix = suffix;
}

public boolean accept(File dir, String name)
{
    return (name.endsWith(suffix));
}

}

