package unisql.itrack;

import javax.servlet.jsp.*;
import java.io.*;

abstract public class ITrackHTML {

/*=======================================================================
 |      PUBLIC METHODS
 =======================================================================*/

static public void Head(JspWriter out, String title)  throws IOException
{
  out.println("<HEAD>");
  out.println("<link rel=\"stylesheet\" href=\"./style.css\" type=\"text/css\">");
  if (title != null) {
    out.println("<TITLE>" + title + "</TITLE>");
  }
  out.println("</HEAD>");
}

static public void Table(JspWriter out, String attrStr) throws IOException
{
  out.println("<table " + attrStr + " >");
}

static public void Table(JspWriter out) throws IOException
{
  Table(out, "");
}

static public void TableEnd(JspWriter out) throws IOException
{
  out.println("</table>");
}

static public void Th(JspWriter out) throws IOException
{
  out.println("<th>");
}

static public void Tr(JspWriter out) throws IOException
{
  out.println("<tr>");
}

static public void Tr(JspWriter out, String attrStr) throws IOException
{
  out.println("<TR " + attrStr + ">");
}

static public void Td(JspWriter out) throws IOException
{
  Td(out, "");
}

static public void Td(JspWriter out, String attrStr) throws IOException
{
  out.print("<td ");
  out.print(attrStr);
  out.print(" >");
  out.println("");
}

static public void Td(JspWriter out, String id, int width, String etc)
	throws IOException
{
  StringBuffer attrStr = new StringBuffer("");
  if (id != null) {
    attrStr.append(" id='");
    attrStr.append(id);
    attrStr.append("' ");
  }
  if (width > 0) {
    attrStr.append(" width='");
    attrStr.append(width);
    attrStr.append("' ");
  }
  if (etc != null) {
    attrStr.append(etc);
  }

  Td(out, attrStr.toString());
}

static public void A(JspWriter out, String attrStr, String msg) throws IOException
{
  out.print("<a " + attrStr + " >");
  out.print(msg);
  out.println("</a>");
}

static public void A(StringBuffer buf, String attrStr, String msg)
{
  buf.append("<a ");
  buf.append(attrStr);
  buf.append(" >");
  buf.append(msg);
  buf.append("</a>");
}

static public void Form(JspWriter out, String attrStr) throws IOException
{
  out.println("<form " + attrStr + " >");
}

static public void FormEnd(JspWriter out) throws IOException
{
  out.println("</form>");
}


static public void Space(JspWriter out, int count) throws IOException
{
  for (int i=0 ; i < count ; i++) {
    out.print("&nbsp;");
  }
}

static public void InputText4SearchForm(JspWriter out, String name, String value, String attrStr) throws IOException
{
	out.println("<INPUT TYPE=TEXT " +
	      "NAME=\"" + name + "\" " +
	      "VALUE=\"" + value.replaceAll("\"", "&quot;") + "\" " +
	      attrStr + ">");
}

static public void InputText(JspWriter out, String name, String value, String attrStr) throws IOException
{
	int maxLength = 20;
	if (name.equals("title")) {
		maxLength = 200;
	} else if (name.equals("reviewer")) {
		maxLength = 40;
	} else if (name.equals("issue_build_number") 
			|| name.equals("resolved_build_number")
			|| name.equals("flag")) {
		maxLength = 30;
	} else if (name.equals("cvs_revision")) {
		maxLength = 200;
	}
			
	out.println("<INPUT TYPE=TEXT " +
	      "NAME=\"" + name + "\" " +
	      "VALUE=\"" + value.replaceAll("\"", "&quot;") + "\" " +
	      attrStr + " maxlength = " + maxLength + ">");
}

static public void Select(JspWriter out, String name, String attrStr, String[] optionArr, int selectedIndex) throws IOException
{
  String[][] op;
  if (optionArr == null) {
    op = null;
  }
  else {
    op = new String[optionArr.length][2];
    for (int i=0 ; i < optionArr.length ; i++) {
      op[i][0] = optionArr[i];
      op[i][1] = optionArr[i];
    }
  }
  Select(out, name, attrStr, op, selectedIndex);
}

static public void Select(JspWriter out, String name, String attrStr, String[][] values, int selectedIndex)
	throws IOException
{
  out.println("<SELECT " +
	      "NAME=\"" + name + "\" " +
	      attrStr + ">");

  if (values != null) {
    for (int i=0 ; i < values.length ; i++) {
      ITrackHTML.Option(out, values[i][0], values[i][1],
			  (selectedIndex == i ? "selected" : ""));
    }
  }

  out.println("</SELECT>");
}

static public void Select(JspWriter out, String name, String attrStr, String[] values, String selectedValue)
	throws IOException
{
  String[] strArr = new String[1];
  if (selectedValue == null)
    strArr[0] = "";
  else
    strArr[0] = selectedValue;

  Select(out, name, attrStr, values, strArr);
}

static public void Select(JspWriter out, String name, String attrStr, String[] values, String[] selectedValues)
	throws IOException
{
  out.println("<SELECT " +
	      "NAME=\"" + name + "\" " +
	      attrStr + ">");

  if (values != null) {
    boolean selected;
    for (int i=0 ; i < values.length ; i++) {
      selected = false;
      if (selectedValues != null) {
	for (int j=0 ; j < selectedValues.length ; j++) {
	  if (selectedValues[j] != null && selectedValues[j].equals(values[i])) {
	    selected = true;
	    break;
	  }
	}
      }

      ITrackHTML.Option(out, values[i], values[i],
			  (selected == true ? "selected" : ""));
    }
  }

  out.println("</SELECT>");
}

static public void Textarea(JspWriter out, String name, String value, String attrStr) throws IOException
{
  out.print("<TEXTAREA " +
	      "NAME=\"" + name + "\" " +
	      attrStr + " >");
  out.print(value);
  out.println("</TEXTAREA>");
}

static public void InputFile(JspWriter out, String name, String attrStr)
	throws IOException
{
  out.println("<INPUT TYPE=FILE " +
	      "NAME=\"" + name + "\" " +
	      attrStr + " >");
}

static public void InputHidden(JspWriter out, String name, String value)
	throws IOException
{
  out.println("<INPUT TYPE=HIDDEN " +
	      "NAME=\"" + name + "\" " +
	      "VALUE=\"" + value.replaceAll("\"", "&quot;") + "\" " + " >");
}

static public void InputCheckbox(JspWriter out, String name, String value, boolean checked, String attrStr)
	throws IOException
{
  String checkedStr = "";
  if (checked)
    checkedStr = " checked ";

  out.println("<INPUT TYPE=CHECKBOX " +
	      "NAME=\"" + name + "\" " +
	      checkedStr + attrStr + ">" + value);
}

static public void InputSubmit(JspWriter out, String name, String value, String attrStr) throws IOException
{
  out.println("<INPUT TYPE=SUBMIT " +
	      "NAME=\"" + name + "\" " +
	      "VALUE=\"" + value + "\" " + attrStr + ">");
}

static public void InputReset(JspWriter out, String name, String value, String attrStr) throws IOException
{
  out.println("<INPUT TYPE=RESET " +
	      "NAME=\"" + name + "\" " +
	      "VALUE=\"" + value + "\" " + attrStr + ">");
}

static public void InputButton(JspWriter out, String name, String value, String attrStr) throws IOException
{
  out.println("<INPUT TYPE=BUTTON " +
	      "NAME=\"" + name + "\" " +
	      "VALUE=\"" + value + "\" " + attrStr + ">");
}

static public void Pre(JspWriter out, String msg)
	throws IOException
{
  out.println("<PRE>" + msg + "</PRE>");
}

static public void writeErrorMsg(JspWriter out, String msg) throws IOException
{
  out.println(msg);
}

/*=======================================================================
 |      PUBLIC METHODS
 =======================================================================*/

static private void Option(JspWriter out, String value, String attrStr)
	throws IOException
{
  Option(out, value, value, attrStr);
}

static private void Option(JspWriter out, String value, String display_value, String attrStr)
	throws IOException
{
  out.println("<OPTION " +
	      "VALUE=\"" + value + "\" " +
	      attrStr + " >" + display_value);
}

}
